/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_interactive_console.console;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.shared_core.log.Log;
import org.python.pydev.shared_interactive_console.console.ScriptConsoleGlobalHistory;

public class ScriptConsoleHistory {
    private final List<String> lines = ScriptConsoleGlobalHistory.INSTANCE.get();
    private int localHistoryStart;
    private int currLine;
    private Document historyAsDoc;
    private String matchStart = "";
    private volatile boolean closed = false;

    public ScriptConsoleHistory() {
        StringBuilder globalHistory = new StringBuilder();
        for (String line : this.lines) {
            globalHistory.append(line);
            globalHistory.append("\n");
        }
        if (this.lines.size() == 0 || this.lines.get(this.lines.size() - 1).length() != 0) {
            this.lines.add("");
        }
        this.localHistoryStart = this.lines.size() - 1;
        this.currLine = this.lines.size() - 1;
        this.historyAsDoc = new Document(globalHistory.toString());
    }

    public void update(String line) {
        this.lines.set(this.lines.size() - 1, line);
    }

    public void commit() {
        String lineToAddToHistory = this.getBufferLine();
        try {
            this.historyAsDoc.replace(this.historyAsDoc.getLength(), 0, String.valueOf(lineToAddToHistory) + "\n");
        }
        catch (BadLocationException e) {
            Log.log((Throwable)e);
        }
        if (lineToAddToHistory.length() == 0) {
            this.currLine = this.lines.size() - 1;
            return;
        }
        this.lines.set(this.lines.size() - 1, lineToAddToHistory);
        this.lines.add("");
        this.currLine = this.lines.size() - 1;
    }

    public boolean prev() {
        int initialCurrLine = this.currLine;
        while (this.currLine > 0) {
            --this.currLine;
            String curr = this.get();
            if (!curr.startsWith(this.matchStart)) continue;
            return true;
        }
        this.currLine = initialCurrLine;
        return false;
    }

    public boolean next() {
        int initialCurrLine = this.currLine;
        while (this.currLine < this.lines.size() - 2) {
            ++this.currLine;
            String curr = this.get();
            if (!curr.startsWith(this.matchStart)) continue;
            return true;
        }
        this.currLine = initialCurrLine;
        return false;
    }

    public IDocument getAsDoc() {
        return this.historyAsDoc;
    }

    public String getBufferLine() {
        return this.lines.get(this.lines.size() - 1);
    }

    public String get() {
        if (this.lines.isEmpty()) {
            return "";
        }
        return this.lines.get(this.currLine);
    }

    public List<String> getAsList() {
        ArrayList<String> list = new ArrayList<String>(this.lines);
        if (list.size() > 0) {
            list.remove(list.size() - 1);
        }
        return list;
    }

    public void setMatchStart(String string) {
        this.matchStart = string;
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        ScriptConsoleGlobalHistory.INSTANCE.append(this.lines.subList(this.localHistoryStart, this.lines.size() - 1));
    }

    public void clear() {
        ScriptConsoleGlobalHistory.INSTANCE.clear();
        this.lines.clear();
        this.lines.add("");
        this.localHistoryStart = 0;
        this.historyAsDoc.set("");
        this.currLine = 0;
    }
}

