/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_interactive_console.console.codegen;

import java.io.File;
import org.eclipse.ui.ide.ResourceUtil;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_interactive_console.console.codegen.IScriptConsoleCodeGenerator;

public final class PythonSnippetUtils {
    public static String getRunfileCommand(File file) {
        return StringUtils.format((String)"runfile(%s)\n", (Object[])new Object[]{PythonSnippetUtils.getSingleQuotedString(file.toString())});
    }

    private static String getQuotedString(char quote, String string) {
        if (string == null || string.length() == 0) {
            return "" + quote + quote;
        }
        FastStringBuffer buf = new FastStringBuffer();
        buf.append(quote);
        char[] characters = string.toCharArray();
        int j = 0;
        while (j < characters.length) {
            char character = characters[j];
            if (character == quote) {
                buf.append('\\');
            } else if (character == '\\') {
                buf.append('\\');
            }
            buf.append(character);
            ++j;
        }
        buf.append(quote);
        return buf.toString();
    }

    public static String getSingleQuotedString(String string) {
        return PythonSnippetUtils.getQuotedString('\'', string);
    }

    public static String getDoubleQuotedString(String string) {
        return PythonSnippetUtils.getQuotedString('\"', string);
    }

    public static IScriptConsoleCodeGenerator getScriptConsoleCodeGeneratorAdapter(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof IScriptConsoleCodeGenerator) {
            return (IScriptConsoleCodeGenerator)object;
        }
        Object adaptedNode = ResourceUtil.getAdapter((Object)object, IScriptConsoleCodeGenerator.class, (boolean)true);
        if (adaptedNode instanceof IScriptConsoleCodeGenerator) {
            return (IScriptConsoleCodeGenerator)adaptedNode;
        }
        return null;
    }
}

