/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.IllegalCharsetNameException;
import java.util.zip.ZipFile;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.core.log.Log;
import org.python.pydev.shared_core.callbacks.ICallback0;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.string.FastStringBuffer;

public class FileUtilsFileBuffer {
    public static char[] INVALID_FILESYSTEM_CHARS = new char[]{'!', '@', '#', '$', '%', '^', '&', '*', '(', ')', '[', ']', '{', '}', '=', '+', '.', ' ', '`', '~', '\'', '\"', ',', ';'};

    public static String getValidProjectName(IProject project) {
        String name = project.getName();
        char[] cArray = INVALID_FILESYSTEM_CHARS;
        int n = INVALID_FILESYSTEM_CHARS.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            name = name.replace(c, '_');
            ++n2;
        }
        return name;
    }

    public static IDocument getDocFromFile(File f) throws IOException {
        return FileUtilsFileBuffer.getDocFromFile(f, true);
    }

    public static String getStringFromZip(File f, String pathInZip) throws Exception {
        return (String)FileUtilsFileBuffer.getCustomReturnFromZip(f, pathInZip, String.class);
    }

    public static IDocument getDocFromZip(File f, String pathInZip) throws Exception {
        return (IDocument)FileUtilsFileBuffer.getCustomReturnFromZip(f, pathInZip, IDocument.class);
    }

    public static Object getCustomReturnFromZip(File f, String pathInZip, Class<? extends Object> returnType) throws Exception {
        try (ZipFile zipFile = new ZipFile(f, 1);){
            Object object;
            InputStream inputStream = zipFile.getInputStream(zipFile.getEntry(pathInZip));
            try {
                object = FileUtils.getStreamContents((InputStream)inputStream, null, null, returnType);
            }
            catch (Throwable throwable) {
                inputStream.close();
                throw throwable;
            }
            inputStream.close();
            return object;
        }
    }

    public static String getStringFromFile(File f, boolean loadIfNotInWorkspace) throws IOException {
        return (String)FileUtilsFileBuffer.getCustomReturnFromFile(f, loadIfNotInWorkspace, String.class);
    }

    public static IDocument getDocFromFile(File f, boolean loadIfNotInWorkspace) throws IOException {
        return (IDocument)FileUtilsFileBuffer.getCustomReturnFromFile(f, loadIfNotInWorkspace, IDocument.class);
    }

    public static Object getCustomReturnFromFile(File f, boolean loadIfNotInWorkspace, Class<? extends Object> returnType) throws IOException {
        IPath path = Path.fromOSString((String)FileUtils.getFileAbsolutePath((File)f));
        IDocument doc = FileUtilsFileBuffer.getDocFromPath(path);
        if (doc != null) {
            if (returnType == null || returnType == IDocument.class) {
                return doc;
            }
            if (returnType == String.class) {
                return doc.get();
            }
            if (returnType == FastStringBuffer.class) {
                return new FastStringBuffer(doc.get(), 16);
            }
            throw new RuntimeException("Don't know how to treat requested return type: " + returnType);
        }
        if (doc == null && loadIfNotInWorkspace) {
            FileInputStream stream = new FileInputStream(f);
            try {
                String encoding = FileUtils.getPythonFileEncoding((File)f);
                Object object = FileUtils.getStreamContents((InputStream)stream, (String)encoding, null, returnType);
                return object;
            }
            finally {
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (Exception e) {
                    Log.log(e);
                }
            }
        }
        return doc;
    }

    public static ITextFileBuffer getBufferFromPath(IPath path) {
        return FileUtils.getBufferFromPath((IPath)path);
    }

    public static IDocument getDocFromPath(IPath path) {
        return FileUtils.getDocFromPath((IPath)path);
    }

    public static ICallback0<IDocument> getDocOnCallbackFromResource(final IResource resource) {
        return new ICallback0<IDocument>(){
            private IDocument cache;
            private boolean calledOnce = false;

            public IDocument call() {
                if (!this.calledOnce) {
                    this.calledOnce = true;
                    this.cache = FileUtilsFileBuffer.getDocFromResource(resource);
                }
                return this.cache;
            }
        };
    }

    public static IDocument getDocFromResource(IResource resource) {
        return FileUtils.getDocFromResource((IResource)resource);
    }

    public static String getPythonFileEncoding(IDocument doc, String fileLocation) throws IllegalCharsetNameException {
        StringReader inputStreamReader = new StringReader(doc.get());
        return FileUtils.getPythonFileEncoding((Reader)inputStreamReader, (String)fileLocation);
    }
}

