/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core.cache;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.python.pydev.core.FastBufferedReader;
import org.python.pydev.core.ObjectsPool;
import org.python.pydev.core.cache.CompleteIndexKey;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;

public final class DiskCache
implements Serializable {
    private static final long serialVersionUID = 5L;
    private static final boolean DEBUG = false;
    private transient Object lock;
    private String folderToPersist;
    private Map<CompleteIndexKey, CompleteIndexKey> keys = new HashMap<CompleteIndexKey, CompleteIndexKey>();

    private void readObject(ObjectInputStream aStream) throws IOException, ClassNotFoundException {
        this.lock = new Object();
        aStream.defaultReadObject();
        this.keys = (Map)aStream.readObject();
        this.folderToPersist = (String)aStream.readObject();
    }

    public void writeTo(FastStringBuffer tempBuf) {
        tempBuf.append("-- START DISKCACHE\n");
        tempBuf.append(this.folderToPersist);
        tempBuf.append('\n');
        for (CompleteIndexKey key : this.keys.values()) {
            tempBuf.append(key.key.name);
            tempBuf.append('|');
            tempBuf.append(key.lastModified);
            if (key.key.file != null) {
                tempBuf.append('|');
                tempBuf.append(key.key.file.toString());
            }
            tempBuf.append('\n');
        }
        tempBuf.append("-- END DISKCACHE\n");
    }

    public static DiskCache loadFrom(FastBufferedReader reader, ObjectsPool.ObjectsPoolMap objectsPoolMap) throws IOException {
        DiskCache diskCache = new DiskCache();
        FastStringBuffer line = reader.readLine();
        if (line.startsWith("-- ")) {
            throw new RuntimeException("Unexpected line: " + line);
        }
        diskCache.folderToPersist = line.toString();
        FastStringBuffer buf = new FastStringBuffer();
        CompleteIndexKey key = null;
        char[] internalCharsArray = line.getInternalCharsArray();
        while (true) {
            line = reader.readLine();
            key = null;
            if (line == null || line.startsWith("-- ")) {
                if (line != null && line.startsWith("-- END DISKCACHE")) {
                    return diskCache;
                }
                throw new RuntimeException("Unexpected line: " + line);
            }
            int length = line.length();
            int part = 0;
            int i = 0;
            while (i < length) {
                char c = internalCharsArray[i];
                if (c == '|') {
                    switch (part) {
                        case 0: {
                            key = new CompleteIndexKey(ObjectsPool.internLocal(objectsPoolMap, buf.toString()));
                            diskCache.add(key);
                            break;
                        }
                        case 1: {
                            key.lastModified = StringUtils.parsePositiveLong((FastStringBuffer)buf);
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unexpected part in line: " + line);
                        }
                    }
                    ++part;
                    buf.clear();
                } else {
                    buf.append(c);
                }
                ++i;
            }
            if (buf.length() <= 0) continue;
            switch (part) {
                case 1: {
                    key.lastModified = StringUtils.parsePositiveLong((FastStringBuffer)buf);
                    break;
                }
                case 2: {
                    key.key.file = new File(ObjectsPool.internLocal(objectsPoolMap, buf.toString()));
                }
            }
            buf.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream aStream) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            aStream.defaultWriteObject();
            aStream.writeObject(this.keys);
            aStream.writeObject(this.folderToPersist);
        }
    }

    private DiskCache() {
        this.lock = new Object();
    }

    public DiskCache(File folderToPersist, String suffix) {
        this();
        this.folderToPersist = FileUtils.getFileAbsolutePath((File)folderToPersist);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(CompleteIndexKey key) {
        Object object = this.lock;
        synchronized (object) {
            this.keys.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(CompleteIndexKey key) {
        Object object = this.lock;
        synchronized (object) {
            this.keys.put(key, key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.keys.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<CompleteIndexKey, CompleteIndexKey> keys() {
        Object object = this.lock;
        synchronized (object) {
            return new HashMap<CompleteIndexKey, CompleteIndexKey>(this.keys);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFolderToPersist(String folderToPersist) {
        Object object = this.lock;
        synchronized (object) {
            File file = new File(folderToPersist);
            if (!file.exists()) {
                file.mkdirs();
            }
            this.folderToPersist = folderToPersist;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFolderToPersist() {
        Object object = this.lock;
        synchronized (object) {
            return this.folderToPersist;
        }
    }
}

