/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core.docutils;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.python.pydev.core.ObjectsPool;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.log.Log;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;

public final class PyStringUtils {
    private static final boolean DEBUG = false;
    public static final char[] BRACKETS = new char[]{'{', '}', '(', ')', '[', ']'};
    public static final char[] CLOSING_BRACKETS = new char[]{'}', ')', ']'};

    private PyStringUtils() {
    }

    public static int indexOf(String string, char character, boolean ignoreInStringLiteral) {
        if (string == null || character < '\u0000' || string.length() == 0) {
            return -1;
        }
        int index = string.indexOf(character);
        if (-1 == index) {
            return index;
        }
        if (ignoreInStringLiteral) {
            int len = string.length();
            boolean inString = false;
            char nextc = '\u0000';
            char c = '\u0000';
            int i = -1;
            try {
                while (i < len) {
                    c = string.charAt(++i);
                    if (i + 1 < len) {
                        nextc = string.charAt(i + 1);
                    }
                    if ('\\' == c) {
                        ++i;
                        continue;
                    }
                    if (!inString && character == c) {
                        index = i;
                        break;
                    }
                    if ('\"' != c && '\'' != c) continue;
                    if ('\"' == nextc || '\'' == nextc) {
                        ++i;
                        continue;
                    }
                    inString = !inString;
                }
            }
            catch (StringIndexOutOfBoundsException e) {
                index = -1;
            }
        }
        return index;
    }

    public static String findSubstring(String string, char character, boolean ignoreInStringLiteral) {
        String result = null;
        int index = PyStringUtils.indexOf(string, character, ignoreInStringLiteral);
        if (index >= 0) {
            result = string.substring(index + 1);
        }
        return result;
    }

    public static String fixWhitespaceColumnsToLeftFromDocstring(String docString, String indentationToAdd) {
        char c;
        FastStringBuffer buf = new FastStringBuffer();
        List splitted = StringUtils.splitInLines((String)docString);
        int i = 0;
        while (i < splitted.size()) {
            String initialString = (String)splitted.get(i);
            if (i == 0) {
                buf.append(initialString);
            } else {
                String string = StringUtils.leftTrim((String)initialString);
                buf.append(indentationToAdd);
                if (string.length() > 0) {
                    buf.append(string);
                } else {
                    int length = initialString.length();
                    if (length > 0) {
                        char c2;
                        if (length > 1 && ((c2 = initialString.charAt(length - 2)) == '\n' || c2 == '\r')) {
                            buf.append(c2);
                        }
                        if ((c2 = initialString.charAt(length - 1)) == '\n' || c2 == '\r') {
                            buf.append(c2);
                        }
                    }
                }
            }
            ++i;
        }
        if (buf.length() > 0 && ((c = buf.lastChar()) == '\r' || c == '\n')) {
            buf.append(indentationToAdd);
        }
        return buf.toString();
    }

    public static String removeWhitespaceColumnsToLeft(String hoverInfo) {
        FastStringBuffer buf = new FastStringBuffer();
        int firstCharPosition = Integer.MAX_VALUE;
        List splitted = StringUtils.splitInLines((String)hoverInfo);
        for (String line : splitted) {
            if (line.trim().length() <= 0) continue;
            int found = PySelection.getFirstCharPosition((String)line);
            firstCharPosition = Math.min(found, firstCharPosition);
        }
        if (firstCharPosition != Integer.MAX_VALUE) {
            for (String line : splitted) {
                if (line.length() <= firstCharPosition) continue;
                buf.append(line.substring(firstCharPosition));
            }
            return buf.toString();
        }
        return hoverInfo;
    }

    public static String removeWhitespaceColumnsToLeftAndApplyIndent(String code, String indent, boolean indentCommentLinesAt0Pos) {
        FastStringBuffer buf = new FastStringBuffer();
        int firstCharPosition = Integer.MAX_VALUE;
        List splitted = StringUtils.splitInLines((String)code);
        for (String line : splitted) {
            if (!indentCommentLinesAt0Pos && line.startsWith("#") || line.trim().length() <= 0) continue;
            int found = PySelection.getFirstCharPosition((String)line);
            firstCharPosition = Math.min(found, firstCharPosition);
        }
        if (firstCharPosition != Integer.MAX_VALUE) {
            for (String line : splitted) {
                if (indentCommentLinesAt0Pos || !line.startsWith("#")) {
                    buf.append(indent);
                    if (line.length() > firstCharPosition) {
                        buf.append(line.substring(firstCharPosition));
                        continue;
                    }
                    buf.append(line);
                    continue;
                }
                buf.append(line);
            }
            return buf.toString();
        }
        return code;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void splitWithIntern(String string, char toSplit, Collection<String> addTo) {
        Object object = ObjectsPool.lock;
        synchronized (object) {
            int len = string.length();
            int last = 0;
            char c = '\u0000';
            int i = 0;
            while (i < len) {
                c = string.charAt(i);
                if (c == toSplit) {
                    if (last != i) {
                        addTo.add(ObjectsPool.internUnsynched(string.substring(last, i)));
                    }
                    while (c == toSplit && i < len - 1) {
                        c = string.charAt(++i);
                    }
                    last = i;
                }
                ++i;
            }
            if (c != toSplit) {
                if (last == 0 && len > 0) {
                    addTo.add(ObjectsPool.internUnsynched(string));
                } else if (last < len) {
                    addTo.add(ObjectsPool.internUnsynched(string.substring(last, len)));
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean isValidIdentifier(String str, boolean acceptPoint) {
        int len = str.length();
        if (str == null || len == 0) {
            return false;
        }
        char c = '\u0000';
        boolean lastWasPoint = false;
        int i = 0;
        while (i < len) {
            block9: {
                c = str.charAt(i);
                if (i == 0) {
                    if (!Character.isJavaIdentifierStart(c)) {
                        return false;
                    }
                } else if (!Character.isJavaIdentifierPart(c)) {
                    if (acceptPoint && c == '.') {
                        if (lastWasPoint) {
                            return false;
                        }
                        lastWasPoint = true;
                        break block9;
                    } else {
                        return false;
                    }
                }
                lastWasPoint = false;
            }
            ++i;
        }
        return c != '.';
    }

    public static boolean hasOpeningBracket(String trimmedLine) {
        return trimmedLine.indexOf(123) != -1 || trimmedLine.indexOf(40) != -1 || trimmedLine.indexOf(91) != -1;
    }

    public static boolean hasClosingBracket(String trimmedLine) {
        return trimmedLine.indexOf(125) != -1 || trimmedLine.indexOf(41) != -1 || trimmedLine.indexOf(93) != -1;
    }

    public static boolean hasUnbalancedClosingPeers(String line) {
        HashMap<Character, Integer> stack = new HashMap<Character, Integer>();
        int len = line.length();
        int i = 0;
        while (i < len) {
            char c = line.charAt(i);
            switch (c) {
                case '(': 
                case '[': 
                case '{': {
                    Integer iStack = (Integer)stack.get(Character.valueOf(c));
                    if (iStack == null) {
                        iStack = 0;
                    }
                    iStack = iStack + 1;
                    stack.put(Character.valueOf(c), iStack);
                    break;
                }
                case ')': 
                case ']': 
                case '}': {
                    char peer = StringUtils.getPeer((char)c);
                    Integer iStack = (Integer)stack.get(Character.valueOf(peer));
                    if (iStack == null) {
                        iStack = 0;
                    }
                    iStack = iStack - 1;
                    stack.put(Character.valueOf(peer), iStack);
                }
            }
            ++i;
        }
        Iterator iterator = stack.values().iterator();
        while (iterator.hasNext()) {
            i = (Integer)iterator.next();
            if (i >= 0) continue;
            return true;
        }
        return false;
    }

    public static String urlEncodeKeyValuePair(String key, String value) {
        String result = null;
        try {
            result = String.valueOf(URLEncoder.encode(key, "UTF-8")) + "=" + URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Log.log(e);
        }
        return result;
    }

    public static boolean isPythonIdentifier(String param) {
        int len = param.length();
        if (len == 0) {
            return false;
        }
        char c = param.charAt(0);
        if (!Character.isLetter(c) && c != '_' && c <= '\u0080') {
            return false;
        }
        int i = 1;
        while (i < len) {
            c = param.charAt(i);
            if (!Character.isLetter(c) && !Character.isDigit(c) && c != '_' && c <= '\u0080') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String getExeAsFileSystemValidPath(String executableOrJar) {
        return "v1_" + StringUtils.md5((String)executableOrJar);
    }
}

