

#include <windows.h>
#include <stdio.h>


int main(int, char **);
int RunPyroScript(void);



#define ISOK(result) (atoi(result+1)>=200 && atoi(result+1)<=299)



//-------------------------------------------------------------------------
//  main function to test 
//-------------------------------------------------------------------------
int main(int argc, char **argv)
{
	int ok= RunPyroScript();

	return ok ? 0 : 1;
}


//-------------------------------------------------------------------------
//  function to execute commands in PyroBatch via PYROBATCHCONTROL.DLL
//-------------------------------------------------------------------------
int RunPyroScript(void)
{
	int ok, allok= FALSE;
	char result[1024]= "", initresult[1024];
	const char *dllname= "..\\pyrobatchcontrol\\debug\\pyrobatchcontrol.dll";
	HINSTANCE hinstPyroBatchControl= NULL;
	int (__stdcall *fnPyroBatch)(const char *app, const char *command, char *result, int resultmax)= NULL;


	// load pyrobatchcontrol.dll and get address of PyroBatch function
	hinstPyroBatchControl= LoadLibrary(dllname);
	if (hinstPyroBatchControl) {
		fnPyroBatch= (int (__stdcall*)(const char *app, const char*,char*,int))GetProcAddress(hinstPyroBatchControl, "_PyroBatch@16");
	}


	// if dll found and ok
	if (fnPyroBatch) {
		const char *app= "pyrobatch";


		// start pyrobatch.exe or initiate communication with existing instance
		ok= fnPyroBatch(app, "start", initresult, sizeof(initresult));
		printf("%d %s\n", ok, initresult);


		if (ok && ISOK(initresult)) { // pyrobatch.exe running
			ok= fnPyroBatch(app, "Connect 'duke', 'test', 'asdf'", result, sizeof(result));
			printf("%d %s\n", ok, result);

			if (ok && ISOK(result)) {  // ok, connected
				ok= fnPyroBatch(app, "LocalChDir 'd:\\t'", result, sizeof(result));
				printf("%d %s\n", ok, result);

				ok= fnPyroBatch(app, "Get 'new.mdb'", result, sizeof(result));
				printf("%d %s\n", ok, result);
				allok= ok; // an ok here is what we really want

				ok= fnPyroBatch(app, "Disconnect", result, sizeof(result));
				printf("%d %s\n", ok, result);
			}

			// disconnect from pyrobatch

			if (strncmp(initresult, "#200", 4)==0)	// just unattach (pyrobatch.exe was already running)
				ok= fnPyroBatch(app, "bye", result, sizeof(result));
			else
			if (strncmp(initresult, "#201", 4)==0)	// close pyrobatch (we started it)
				ok= fnPyroBatch(app, "term", result, sizeof(result));

			printf("%d %s\n", ok, result);
		}
	}
	else {
		printf("could not load %s\n", dllname);
	}

	
	// unload pyrobatchcontrol.dll
	if (hinstPyroBatchControl) {
		FreeLibrary(hinstPyroBatchControl);
		hinstPyroBatchControl= NULL;
		fnPyroBatch= NULL;
	}

	return allok;
}



