/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.ActivityOptions;
import android.app.PendingIntent;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.PowerManager;
import android.os.Process;
import android.provider.Settings;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.widget.ImageView;
import android.widget.RemoteViews;
import android.widget.TextView;
import org.chromium.base.ThreadUtils;

@TargetApi(value=21)
public class ApiCompatibilityUtils {
    private ApiCompatibilityUtils() {
    }

    public static boolean isLayoutRtl(View view) {
        if (Build.VERSION.SDK_INT >= 17) {
            return view.getLayoutDirection() == 1;
        }
        return false;
    }

    public static int getLayoutDirection(Configuration configuration) {
        if (Build.VERSION.SDK_INT >= 17) {
            return configuration.getLayoutDirection();
        }
        return 0;
    }

    public static boolean isPrintingSupported() {
        return Build.VERSION.SDK_INT >= 19;
    }

    public static void setLayoutDirection(View view, int layoutDirection) {
        if (Build.VERSION.SDK_INT >= 17) {
            view.setLayoutDirection(layoutDirection);
        }
    }

    public static void setTextAlignment(View view, int textAlignment) {
        if (Build.VERSION.SDK_INT >= 17) {
            view.setTextAlignment(textAlignment);
        }
    }

    public static void setTextDirection(View view, int textDirection) {
        if (Build.VERSION.SDK_INT >= 17) {
            view.setTextDirection(textDirection);
        }
    }

    public static void setMarginEnd(ViewGroup.MarginLayoutParams layoutParams, int end) {
        if (Build.VERSION.SDK_INT >= 17) {
            layoutParams.setMarginEnd(end);
        } else {
            layoutParams.rightMargin = end;
        }
    }

    public static int getMarginEnd(ViewGroup.MarginLayoutParams layoutParams) {
        if (Build.VERSION.SDK_INT >= 17) {
            return layoutParams.getMarginEnd();
        }
        return layoutParams.rightMargin;
    }

    public static void setMarginStart(ViewGroup.MarginLayoutParams layoutParams, int start) {
        if (Build.VERSION.SDK_INT >= 17) {
            layoutParams.setMarginStart(start);
        } else {
            layoutParams.leftMargin = start;
        }
    }

    public static int getMarginStart(ViewGroup.MarginLayoutParams layoutParams) {
        if (Build.VERSION.SDK_INT >= 17) {
            return layoutParams.getMarginStart();
        }
        return layoutParams.leftMargin;
    }

    public static void setPaddingRelative(View view, int start, int top, int end, int bottom) {
        if (Build.VERSION.SDK_INT >= 17) {
            view.setPaddingRelative(start, top, end, bottom);
        } else {
            view.setPadding(start, top, end, bottom);
        }
    }

    public static int getPaddingStart(View view) {
        if (Build.VERSION.SDK_INT >= 17) {
            return view.getPaddingStart();
        }
        return view.getPaddingLeft();
    }

    public static int getPaddingEnd(View view) {
        if (Build.VERSION.SDK_INT >= 17) {
            return view.getPaddingEnd();
        }
        return view.getPaddingRight();
    }

    public static void setCompoundDrawablesRelative(TextView textView, Drawable start, Drawable top, Drawable end, Drawable bottom) {
        if (Build.VERSION.SDK_INT == 17) {
            boolean isRtl = ApiCompatibilityUtils.isLayoutRtl((View)textView);
            textView.setCompoundDrawables(isRtl ? end : start, top, isRtl ? start : end, bottom);
        } else if (Build.VERSION.SDK_INT > 17) {
            textView.setCompoundDrawablesRelative(start, top, end, bottom);
        } else {
            textView.setCompoundDrawables(start, top, end, bottom);
        }
    }

    public static void setCompoundDrawablesRelativeWithIntrinsicBounds(TextView textView, Drawable start, Drawable top, Drawable end, Drawable bottom) {
        if (Build.VERSION.SDK_INT == 17) {
            boolean isRtl = ApiCompatibilityUtils.isLayoutRtl((View)textView);
            textView.setCompoundDrawablesWithIntrinsicBounds(isRtl ? end : start, top, isRtl ? start : end, bottom);
        } else if (Build.VERSION.SDK_INT > 17) {
            textView.setCompoundDrawablesRelativeWithIntrinsicBounds(start, top, end, bottom);
        } else {
            textView.setCompoundDrawablesWithIntrinsicBounds(start, top, end, bottom);
        }
    }

    public static void setCompoundDrawablesRelativeWithIntrinsicBounds(TextView textView, int start, int top, int end, int bottom) {
        if (Build.VERSION.SDK_INT == 17) {
            boolean isRtl = ApiCompatibilityUtils.isLayoutRtl((View)textView);
            textView.setCompoundDrawablesWithIntrinsicBounds(isRtl ? end : start, top, isRtl ? start : end, bottom);
        } else if (Build.VERSION.SDK_INT > 17) {
            textView.setCompoundDrawablesRelativeWithIntrinsicBounds(start, top, end, bottom);
        } else {
            textView.setCompoundDrawablesWithIntrinsicBounds(start, top, end, bottom);
        }
    }

    public static void postInvalidateOnAnimation(View view) {
        if (Build.VERSION.SDK_INT >= 16) {
            view.postInvalidateOnAnimation();
        } else {
            view.postInvalidate();
        }
    }

    public static void postOnAnimation(View view, Runnable action) {
        if (Build.VERSION.SDK_INT >= 16) {
            view.postOnAnimation(action);
        } else {
            view.postDelayed(action, ApiCompatibilityUtils.getFrameTime());
        }
    }

    public static void postOnAnimationDelayed(View view, Runnable action, long delayMillis) {
        if (Build.VERSION.SDK_INT >= 16) {
            view.postOnAnimationDelayed(action, delayMillis);
        } else {
            view.postDelayed(action, ApiCompatibilityUtils.getFrameTime() + delayMillis);
        }
    }

    private static long getFrameTime() {
        if (Build.VERSION.SDK_INT >= 11) {
            return ValueAnimator.getFrameDelay();
        }
        return 10L;
    }

    public static void setContentDescriptionForRemoteView(RemoteViews remoteViews, int viewId, CharSequence contentDescription) {
        if (Build.VERSION.SDK_INT >= 15) {
            remoteViews.setContentDescription(viewId, contentDescription);
        }
    }

    public static void startActivity(Context context, Intent intent, Bundle options) {
        if (Build.VERSION.SDK_INT >= 16) {
            context.startActivity(intent, options);
        } else {
            context.startActivity(intent);
        }
    }

    public static Bundle toBundle(ActivityOptions options) {
        if (Build.VERSION.SDK_INT >= 16) {
            return options.toBundle();
        }
        return null;
    }

    public static void setBackgroundForView(View view, Drawable drawable2) {
        if (Build.VERSION.SDK_INT >= 16) {
            view.setBackground(drawable2);
        } else {
            view.setBackgroundDrawable(drawable2);
        }
    }

    public static void removeOnGlobalLayoutListener(View view, ViewTreeObserver.OnGlobalLayoutListener listener) {
        if (Build.VERSION.SDK_INT >= 16) {
            view.getViewTreeObserver().removeOnGlobalLayoutListener(listener);
        } else {
            view.getViewTreeObserver().removeGlobalOnLayoutListener(listener);
        }
    }

    public static void setImageAlpha(ImageView iv, int alpha) {
        if (Build.VERSION.SDK_INT >= 16) {
            iv.setImageAlpha(alpha);
        } else {
            iv.setAlpha(alpha);
        }
    }

    public static String getCreatorPackage(PendingIntent intent) {
        if (Build.VERSION.SDK_INT >= 17) {
            return intent.getCreatorPackage();
        }
        return intent.getTargetPackage();
    }

    @TargetApi(value=17)
    public static boolean isDeviceProvisioned(Context context) {
        if (Build.VERSION.SDK_INT < 17) {
            return true;
        }
        if (context == null) {
            return true;
        }
        if (context.getContentResolver() == null) {
            return true;
        }
        return Settings.Global.getInt((ContentResolver)context.getContentResolver(), (String)"device_provisioned", (int)0) != 0;
    }

    public static void finishAndRemoveTask(Activity activity) {
        if (Build.VERSION.SDK_INT > 21) {
            activity.finishAndRemoveTask();
        } else if (Build.VERSION.SDK_INT == 21) {
            new FinishAndRemoveTaskWithRetry(activity).run();
        } else {
            activity.finish();
        }
    }

    public static boolean isInteractive(Context context) {
        PowerManager manager = (PowerManager)context.getSystemService("power");
        if (Build.VERSION.SDK_INT >= 20) {
            return manager.isInteractive();
        }
        return manager.isScreenOn();
    }

    public static int getActivityNewDocumentFlag() {
        if (Build.VERSION.SDK_INT >= 21) {
            return 524288;
        }
        return 524288;
    }

    public static boolean shouldSkipFirstUseHints(ContentResolver contentResolver) {
        if (Build.VERSION.SDK_INT >= 21) {
            return Settings.Secure.getInt((ContentResolver)contentResolver, (String)"skip_first_use_hints", (int)0) != 0;
        }
        return false;
    }

    public static void setTaskDescription(Activity activity, String title, Bitmap icon, int color2) {
        if (Build.VERSION.SDK_INT >= 21) {
            ActivityManager.TaskDescription description = new ActivityManager.TaskDescription(title, icon, color2);
            activity.setTaskDescription(description);
        }
    }

    public static void setStatusBarColor(Activity activity, int statusBarColor) {
        if (Build.VERSION.SDK_INT >= 21) {
            Window window = activity.getWindow();
            if (statusBarColor == -16777216 && window.getNavigationBarColor() == -16777216) {
                window.clearFlags(Integer.MIN_VALUE);
            } else {
                window.addFlags(Integer.MIN_VALUE);
            }
            window.setStatusBarColor(statusBarColor);
        }
    }

    public static void setStatusBarColor(Window window, int statusBarColor) {
        if (Build.VERSION.SDK_INT >= 21) {
            if (statusBarColor == -16777216 && window.getNavigationBarColor() == -16777216) {
                window.clearFlags(Integer.MIN_VALUE);
            } else {
                window.addFlags(Integer.MIN_VALUE);
            }
            window.setStatusBarColor(statusBarColor);
        }
    }

    public static Drawable getDrawable(Resources res, int id2) throws Resources.NotFoundException {
        if (Build.VERSION.SDK_INT >= 21) {
            return res.getDrawable(id2, null);
        }
        return res.getDrawable(id2);
    }

    public static Drawable getDrawableForDensity(Resources res, int id2, int density) {
        if (Build.VERSION.SDK_INT >= 21) {
            return res.getDrawableForDensity(id2, density, null);
        }
        return res.getDrawableForDensity(id2, density);
    }

    public static void finishAfterTransition(Activity activity) {
        if (Build.VERSION.SDK_INT >= 21) {
            activity.finishAfterTransition();
        } else {
            activity.finish();
        }
    }

    public static void announceForAccessibility(View view, CharSequence text) {
        if (Build.VERSION.SDK_INT >= 16) {
            view.announceForAccessibility(text);
        }
    }

    public static Drawable getUserBadgedIcon(Context context, int id2) {
        Drawable drawable2 = ApiCompatibilityUtils.getDrawable(context.getResources(), id2);
        if (Build.VERSION.SDK_INT >= 21) {
            PackageManager packageManager = context.getPackageManager();
            drawable2 = packageManager.getUserBadgedIcon(drawable2, Process.myUserHandle());
        }
        return drawable2;
    }

    private static class FinishAndRemoveTaskWithRetry
    implements Runnable {
        private static final long RETRY_DELAY_MS = 500L;
        private static final long MAX_TRY_COUNT = 3L;
        private final Activity mActivity;
        private int mTryCount;

        FinishAndRemoveTaskWithRetry(Activity activity) {
            this.mActivity = activity;
        }

        @Override
        public void run() {
            this.mActivity.finishAndRemoveTask();
            ++this.mTryCount;
            if (!this.mActivity.isFinishing()) {
                if ((long)this.mTryCount < 3L) {
                    ThreadUtils.postOnUiThreadDelayed(this, 500L);
                } else {
                    this.mActivity.finish();
                }
            }
        }
    }
}

