/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.Window;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.chromium.base.ApplicationStatus;
import org.chromium.base.ObserverList;

public class ApplicationStatusManager {
    private static ObserverList<WindowFocusChangedListener> sWindowFocusListeners = new ObserverList();

    public static void init(Application app) {
        ApplicationStatus.initialize(app);
        app.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

            public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
                ApplicationStatusManager.setWindowFocusChangedCallback(activity);
            }

            public void onActivityDestroyed(Activity activity) {
                assert (Proxy.isProxyClass(activity.getWindow().getCallback().getClass()));
            }

            public void onActivityPaused(Activity activity) {
                assert (Proxy.isProxyClass(activity.getWindow().getCallback().getClass()));
            }

            public void onActivityResumed(Activity activity) {
                assert (Proxy.isProxyClass(activity.getWindow().getCallback().getClass()));
            }

            public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
                assert (Proxy.isProxyClass(activity.getWindow().getCallback().getClass()));
            }

            public void onActivityStarted(Activity activity) {
                assert (Proxy.isProxyClass(activity.getWindow().getCallback().getClass()));
            }

            public void onActivityStopped(Activity activity) {
                assert (Proxy.isProxyClass(activity.getWindow().getCallback().getClass()));
            }
        });
    }

    public static void registerWindowFocusChangedListener(WindowFocusChangedListener listener) {
        sWindowFocusListeners.addObserver(listener);
    }

    public static void unregisterWindowFocusChangedListener(WindowFocusChangedListener listener) {
        sWindowFocusListeners.removeObserver(listener);
    }

    public static void informActivityStarted(Activity activity) {
        ApplicationStatusManager.setWindowFocusChangedCallback(activity);
        ApplicationStatus.informActivityStarted(activity);
    }

    private static void setWindowFocusChangedCallback(Activity activity) {
        Window.Callback callback = activity.getWindow().getCallback();
        activity.getWindow().setCallback((Window.Callback)Proxy.newProxyInstance(Window.Callback.class.getClassLoader(), new Class[]{Window.Callback.class}, (InvocationHandler)new WindowCallbackProxy(activity, callback)));
    }

    private static class WindowCallbackProxy
    implements InvocationHandler {
        private final Window.Callback mCallback;
        private final Activity mActivity;

        public WindowCallbackProxy(Activity activity, Window.Callback callback) {
            this.mCallback = callback;
            this.mActivity = activity;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("onWindowFocusChanged") && args.length == 1 && args[0] instanceof Boolean) {
                this.onWindowFocusChanged((Boolean)args[0]);
                return null;
            }
            if (method.getName().equals("dispatchKeyEvent") && args.length == 1 && args[0] instanceof KeyEvent) {
                return this.dispatchKeyEvent((KeyEvent)args[0]);
            }
            return method.invoke((Object)this.mCallback, args);
        }

        public void onWindowFocusChanged(boolean hasFocus) {
            this.mCallback.onWindowFocusChanged(hasFocus);
            for (WindowFocusChangedListener listener : sWindowFocusListeners) {
                listener.onWindowFocusChanged(this.mActivity, hasFocus);
            }
        }

        public boolean dispatchKeyEvent(KeyEvent event) {
            if (event.getKeyCode() == 82 && this.mActivity.dispatchKeyEvent(event)) {
                return true;
            }
            return this.mCallback.dispatchKeyEvent(event);
        }
    }

    public static interface WindowFocusChangedListener {
        public void onWindowFocusChanged(Activity var1, boolean var2);
    }
}

