/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import org.chromium.base.CalledByNative;
import org.chromium.base.PackageUtils;

public class BuildInfo {
    private static final String TAG = "BuildInfo";
    private static final int MAX_FINGERPRINT_LENGTH = 128;

    private BuildInfo() {
    }

    @CalledByNative
    public static String getDevice() {
        return Build.DEVICE;
    }

    @CalledByNative
    public static String getBrand() {
        return Build.BRAND;
    }

    @CalledByNative
    public static String getAndroidBuildId() {
        return Build.ID;
    }

    @CalledByNative
    public static String getAndroidBuildFingerprint() {
        return Build.FINGERPRINT.substring(0, Math.min(Build.FINGERPRINT.length(), 128));
    }

    @CalledByNative
    public static String getDeviceManufacturer() {
        return Build.MANUFACTURER;
    }

    @CalledByNative
    public static String getDeviceModel() {
        return Build.MODEL;
    }

    @CalledByNative
    public static String getPackageVersionCode(Context context) {
        String msg = "versionCode not available.";
        try {
            PackageManager pm = context.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(context.getPackageName(), 0);
            msg = "";
            if (pi.versionCode > 0) {
                msg = Integer.toString(pi.versionCode);
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.d((String)TAG, (String)msg);
        }
        return msg;
    }

    @CalledByNative
    public static String getPackageVersionName(Context context) {
        String msg = "versionName not available";
        try {
            PackageManager pm = context.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(context.getPackageName(), 0);
            msg = pi.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.d((String)TAG, (String)msg);
        }
        return msg;
    }

    @CalledByNative
    public static String getPackageLabel(Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            ApplicationInfo appInfo = packageManager.getApplicationInfo(context.getPackageName(), 128);
            CharSequence label = packageManager.getApplicationLabel(appInfo);
            return label != null ? label.toString() : "";
        }
        catch (PackageManager.NameNotFoundException e) {
            return "";
        }
    }

    @CalledByNative
    public static String getPackageName(Context context) {
        String packageName = context != null ? context.getPackageName() : null;
        return packageName != null ? packageName : "";
    }

    @CalledByNative
    public static String getBuildType() {
        return Build.TYPE;
    }

    @CalledByNative
    public static int getSdkInt() {
        return Build.VERSION.SDK_INT;
    }

    public static boolean isMncOrLater() {
        return Build.VERSION.SDK_INT > 22 || TextUtils.equals((CharSequence)"MNC", (CharSequence)Build.VERSION.CODENAME);
    }

    private static boolean isLanguageSplit(String splitName) {
        return splitName.length() == 9 && splitName.startsWith("config.");
    }

    @TargetApi(value=21)
    @CalledByNative
    public static boolean hasLanguageApkSplits(Context context) {
        if (Build.VERSION.SDK_INT < 21) {
            return false;
        }
        PackageInfo packageInfo = PackageUtils.getOwnPackageInfo(context);
        if (packageInfo.splitNames != null) {
            for (int i = 0; i < packageInfo.splitNames.length; ++i) {
                if (!BuildInfo.isLanguageSplit(packageInfo.splitNames[i])) continue;
                return true;
            }
        }
        return false;
    }
}

