/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.util.Log;
import java.io.File;
import java.io.FileNotFoundException;
import org.chromium.base.CalledByNative;
import org.chromium.base.ThreadUtils;

public abstract class ContentUriUtils {
    private static final String TAG = "ContentUriUtils";
    private static FileProviderUtil sFileProviderUtil;

    private ContentUriUtils() {
    }

    public static void setFileProviderUtil(FileProviderUtil util) {
        sFileProviderUtil = util;
    }

    public static Uri getContentUriFromFile(Context context, File file) {
        ThreadUtils.assertOnUiThread();
        if (sFileProviderUtil != null) {
            return sFileProviderUtil.getContentUriFromFile(context, file);
        }
        return null;
    }

    @CalledByNative
    public static int openContentUriForRead(Context context, String uriString) {
        ParcelFileDescriptor pfd = ContentUriUtils.getParcelFileDescriptor(context, uriString);
        if (pfd != null) {
            return pfd.detachFd();
        }
        return -1;
    }

    @CalledByNative
    public static boolean contentUriExists(Context context, String uriString) {
        return ContentUriUtils.getParcelFileDescriptor(context, uriString) != null;
    }

    @CalledByNative
    public static String getMimeType(Context context, String uriString) {
        ContentResolver resolver = context.getContentResolver();
        if (resolver == null) {
            return null;
        }
        Uri uri = Uri.parse((String)uriString);
        return resolver.getType(uri);
    }

    private static ParcelFileDescriptor getParcelFileDescriptor(Context context, String uriString) {
        ContentResolver resolver = context.getContentResolver();
        Uri uri = Uri.parse((String)uriString);
        ParcelFileDescriptor pfd = null;
        try {
            pfd = resolver.openFileDescriptor(uri, "r");
        }
        catch (FileNotFoundException e) {
            Log.w((String)TAG, (String)("Cannot find content uri: " + uriString), (Throwable)e);
        }
        catch (SecurityException e) {
            Log.w((String)TAG, (String)("Cannot open content uri: " + uriString), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            Log.w((String)TAG, (String)("Unknown content uri: " + uriString), (Throwable)e);
        }
        catch (IllegalStateException e) {
            Log.w((String)TAG, (String)("Unknown content uri: " + uriString), (Throwable)e);
        }
        return pfd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDisplayName(Uri uri, ContentResolver contentResolver, String columnField) {
        if (contentResolver == null || uri == null) {
            return "";
        }
        try (Cursor cursor = null;){
            cursor = contentResolver.query(uri, null, null, null, null);
            if (cursor != null && cursor.getCount() >= 1) {
                cursor.moveToFirst();
                int index = cursor.getColumnIndex(columnField);
                if (index > -1) {
                    String string2 = cursor.getString(index);
                    return string2;
                }
            }
        }
        return "";
    }

    public static interface FileProviderUtil {
        public Uri getContentUriFromFile(Context var1, File var2);
    }
}

