/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.annotation.TargetApi;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;

@JNINamespace(value="base::android")
class JavaHandlerThread {
    final HandlerThread mThread;

    private JavaHandlerThread(String name) {
        this.mThread = new HandlerThread(name);
    }

    @CalledByNative
    private static JavaHandlerThread create(String name) {
        return new JavaHandlerThread(name);
    }

    @CalledByNative
    private void start(final long nativeThread, final long nativeEvent) {
        this.mThread.start();
        new Handler(this.mThread.getLooper()).post(new Runnable(){

            @Override
            public void run() {
                JavaHandlerThread.this.nativeInitializeThread(nativeThread, nativeEvent);
            }
        });
    }

    @TargetApi(value=18)
    @CalledByNative
    private void stop(final long nativeThread, final long nativeEvent) {
        final boolean quitSafely = Build.VERSION.SDK_INT >= 18;
        new Handler(this.mThread.getLooper()).post(new Runnable(){

            @Override
            public void run() {
                JavaHandlerThread.this.nativeStopThread(nativeThread, nativeEvent);
                if (!quitSafely) {
                    JavaHandlerThread.this.mThread.quit();
                }
            }
        });
        if (quitSafely) {
            this.mThread.quitSafely();
        }
    }

    private native void nativeInitializeThread(long var1, long var3);

    private native void nativeStopThread(long var1, long var3);
}

