/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.app.Activity;
import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.res.Configuration;
import org.chromium.base.CalledByNative;

public class MemoryPressureListener {
    private static final String ACTION_LOW_MEMORY = "org.chromium.base.ACTION_LOW_MEMORY";
    private static final String ACTION_TRIM_MEMORY = "org.chromium.base.ACTION_TRIM_MEMORY";
    private static final String ACTION_TRIM_MEMORY_RUNNING_CRITICAL = "org.chromium.base.ACTION_TRIM_MEMORY_RUNNING_CRITICAL";
    private static final String ACTION_TRIM_MEMORY_MODERATE = "org.chromium.base.ACTION_TRIM_MEMORY_MODERATE";

    @CalledByNative
    private static void registerSystemCallback(Context context) {
        context.registerComponentCallbacks((ComponentCallbacks)new ComponentCallbacks2(){

            public void onTrimMemory(int level) {
                MemoryPressureListener.maybeNotifyMemoryPresure(level);
            }

            public void onLowMemory() {
                MemoryPressureListener.nativeOnMemoryPressure(2);
            }

            public void onConfigurationChanged(Configuration configuration) {
            }
        });
    }

    public static boolean handleDebugIntent(Activity activity, String action) {
        if (ACTION_LOW_MEMORY.equals(action)) {
            MemoryPressureListener.simulateLowMemoryPressureSignal(activity);
        } else if (ACTION_TRIM_MEMORY.equals(action)) {
            MemoryPressureListener.simulateTrimMemoryPressureSignal(activity, 80);
        } else if (ACTION_TRIM_MEMORY_RUNNING_CRITICAL.equals(action)) {
            MemoryPressureListener.simulateTrimMemoryPressureSignal(activity, 15);
        } else if (ACTION_TRIM_MEMORY_MODERATE.equals(action)) {
            MemoryPressureListener.simulateTrimMemoryPressureSignal(activity, 60);
        } else {
            return false;
        }
        return true;
    }

    public static void maybeNotifyMemoryPresure(int level) {
        if (level >= 80) {
            MemoryPressureListener.nativeOnMemoryPressure(2);
        } else if (level >= 40 || level == 15) {
            MemoryPressureListener.nativeOnMemoryPressure(0);
        }
    }

    private static void simulateLowMemoryPressureSignal(Activity activity) {
        activity.getApplication().onLowMemory();
        activity.onLowMemory();
    }

    private static void simulateTrimMemoryPressureSignal(Activity activity, int level) {
        activity.getApplication().onTrimMemory(level);
        activity.onTrimMemory(level);
    }

    private static native void nativeOnMemoryPressure(int var0);
}

