/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.AsyncTask;
import android.os.Environment;
import java.io.File;
import java.util.concurrent.ExecutionException;
import org.chromium.base.CalledByNative;

public abstract class PathUtils {
    private static final String THUMBNAIL_DIRECTORY = "textures";
    private static final int DATA_DIRECTORY = 0;
    private static final int DATABASE_DIRECTORY = 1;
    private static final int CACHE_DIRECTORY = 2;
    private static final int NUM_DIRECTORIES = 3;
    private static AsyncTask<String, Void, String[]> sDirPathFetchTask;
    private static File sThumbnailDirectory;

    private PathUtils() {
    }

    public static void setPrivateDataDirectorySuffix(String suffix, Context context) {
        final Context appContext = context.getApplicationContext();
        sDirPathFetchTask = new AsyncTask<String, Void, String[]>(){

            protected String[] doInBackground(String ... dataDirectorySuffix) {
                String[] paths = new String[3];
                paths[0] = appContext.getDir(dataDirectorySuffix[0], 0).getPath();
                paths[1] = appContext.getDatabasePath("foo").getParent();
                if (appContext.getCacheDir() != null) {
                    paths[2] = appContext.getCacheDir().getPath();
                }
                return paths;
            }
        }.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, (Object[])new String[]{suffix});
    }

    private static String getDirectoryPath(int index) {
        try {
            return ((String[])sDirPathFetchTask.get())[index];
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        return null;
    }

    @CalledByNative
    public static String getDataDirectory(Context appContext) {
        assert (sDirPathFetchTask != null) : "setDataDirectorySuffix must be called first.";
        return PathUtils.getDirectoryPath(0);
    }

    @CalledByNative
    public static String getDatabaseDirectory(Context appContext) {
        assert (sDirPathFetchTask != null) : "setDataDirectorySuffix must be called first.";
        return PathUtils.getDirectoryPath(1);
    }

    @CalledByNative
    public static String getCacheDirectory(Context appContext) {
        assert (sDirPathFetchTask != null) : "setDataDirectorySuffix must be called first.";
        return PathUtils.getDirectoryPath(2);
    }

    public static File getThumbnailCacheDirectory(Context appContext) {
        if (sThumbnailDirectory == null) {
            sThumbnailDirectory = appContext.getDir(THUMBNAIL_DIRECTORY, 0);
        }
        return sThumbnailDirectory;
    }

    @CalledByNative
    public static String getThumbnailCacheDirectoryPath(Context appContext) {
        return PathUtils.getThumbnailCacheDirectory(appContext).getAbsolutePath();
    }

    @CalledByNative
    private static String getDownloadsDirectory(Context appContext) {
        return Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS).getPath();
    }

    @CalledByNative
    private static String getNativeLibraryDirectory(Context appContext) {
        ApplicationInfo ai = appContext.getApplicationInfo();
        if ((ai.flags & 0x80) != 0 || (ai.flags & 1) == 0) {
            return ai.nativeLibraryDir;
        }
        return "/system/lib/";
    }

    @CalledByNative
    public static String getExternalStorageDirectory() {
        return Environment.getExternalStorageDirectory().getAbsolutePath();
    }
}

