/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.os.Debug;
import android.util.Log;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.LinkedList;
import java.util.List;
import org.chromium.base.TraceEvent;
import org.chromium.base.VisibleForTesting;
import org.chromium.base.annotations.SuppressFBWarnings;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@SuppressFBWarnings(value={"CHROMIUM_SYNCHRONIZED_METHOD"})
public class PerfTraceEvent {
    private static final int MAX_NAME_LENGTH = 40;
    private static final String MEMORY_TRACE_NAME_SUFFIX = "_BZR_PSS";
    private static File sOutputFile = null;
    private static boolean sEnabled = false;
    private static boolean sTrackTiming = true;
    private static boolean sTrackMemory = false;
    private static JSONArray sPerfTraceStrings;
    private static List<String> sFilter;
    private static long sBeginNanoTime;

    @VisibleForTesting
    public static synchronized void setFilter(List<String> strings) {
        sFilter = new LinkedList<String>(strings);
    }

    @VisibleForTesting
    public static synchronized void setEnabled(boolean enabled) {
        if (sEnabled == enabled) {
            return;
        }
        if (enabled) {
            sBeginNanoTime = System.nanoTime();
            sPerfTraceStrings = new JSONArray();
        } else {
            PerfTraceEvent.dumpPerf();
            sPerfTraceStrings = null;
            sFilter = null;
        }
        sEnabled = enabled;
    }

    @VisibleForTesting
    public static synchronized void setMemoryTrackingEnabled(boolean enabled) {
        sTrackMemory = enabled;
    }

    @VisibleForTesting
    public static synchronized void setTimingTrackingEnabled(boolean enabled) {
        sTrackTiming = enabled;
    }

    @VisibleForTesting
    public static synchronized boolean enabled() {
        return sEnabled;
    }

    public static synchronized void instant(String name) {
        long eventId = name.hashCode();
        TraceEvent.instant(name);
        if (sEnabled && PerfTraceEvent.matchesFilter(name)) {
            PerfTraceEvent.savePerfString(name, eventId, EventType.INSTANT, false);
        }
    }

    @VisibleForTesting
    public static synchronized void begin(String name) {
        long eventId = name.hashCode();
        TraceEvent.startAsync(name, eventId);
        if (sEnabled && PerfTraceEvent.matchesFilter(name)) {
            if (sTrackMemory) {
                PerfTraceEvent.savePerfString(PerfTraceEvent.makeMemoryTraceNameFromTimingName(name), eventId, EventType.START, true);
            }
            if (sTrackTiming) {
                PerfTraceEvent.savePerfString(name, eventId, EventType.START, false);
            }
        }
    }

    @VisibleForTesting
    public static synchronized void end(String name) {
        long eventId = name.hashCode();
        TraceEvent.finishAsync(name, eventId);
        if (sEnabled && PerfTraceEvent.matchesFilter(name)) {
            if (sTrackTiming) {
                PerfTraceEvent.savePerfString(name, eventId, EventType.FINISH, false);
            }
            if (sTrackMemory) {
                PerfTraceEvent.savePerfString(PerfTraceEvent.makeMemoryTraceNameFromTimingName(name), eventId, EventType.FINISH, true);
            }
        }
    }

    @VisibleForTesting
    public static synchronized void begin(String name, Debug.MemoryInfo memoryInfo) {
        long eventId = name.hashCode();
        TraceEvent.startAsync(name, eventId);
        if (sEnabled && PerfTraceEvent.matchesFilter(name)) {
            long timestampUs = (System.nanoTime() - sBeginNanoTime) / 1000L;
            PerfTraceEvent.savePerfString(PerfTraceEvent.makeMemoryTraceNameFromTimingName(name), eventId, EventType.START, timestampUs, memoryInfo);
            if (sTrackTiming) {
                PerfTraceEvent.savePerfString(name, eventId, EventType.START, false);
            }
        }
    }

    @VisibleForTesting
    public static synchronized void end(String name, Debug.MemoryInfo memoryInfo) {
        long eventId = name.hashCode();
        TraceEvent.finishAsync(name, eventId);
        if (sEnabled && PerfTraceEvent.matchesFilter(name)) {
            if (sTrackTiming) {
                PerfTraceEvent.savePerfString(name, eventId, EventType.FINISH, false);
            }
            long timestampUs = (System.nanoTime() - sBeginNanoTime) / 1000L;
            PerfTraceEvent.savePerfString(PerfTraceEvent.makeMemoryTraceNameFromTimingName(name), eventId, EventType.FINISH, timestampUs, memoryInfo);
        }
    }

    private static boolean matchesFilter(String name) {
        return sFilter != null ? sFilter.contains(name) : false;
    }

    private static void savePerfString(String name, long id2, EventType type, boolean includeMemory) {
        long timestampUs = (System.nanoTime() - sBeginNanoTime) / 1000L;
        Debug.MemoryInfo memInfo = null;
        if (includeMemory) {
            memInfo = new Debug.MemoryInfo();
            Debug.getMemoryInfo((Debug.MemoryInfo)memInfo);
        }
        PerfTraceEvent.savePerfString(name, id2, type, timestampUs, memInfo);
    }

    private static void savePerfString(String name, long id2, EventType type, long timestampUs, Debug.MemoryInfo memoryInfo) {
        try {
            JSONObject traceObj = new JSONObject();
            traceObj.put("cat", (Object)"Java");
            traceObj.put("ts", timestampUs);
            traceObj.put("ph", (Object)type);
            traceObj.put("name", (Object)name);
            traceObj.put("id", id2);
            if (memoryInfo != null) {
                int pss = memoryInfo.nativePss + memoryInfo.dalvikPss + memoryInfo.otherPss;
                traceObj.put("mem", pss);
            }
            sPerfTraceStrings.put((Object)traceObj);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public static String makeMemoryTraceNameFromTimingName(String name) {
        return PerfTraceEvent.makeSafeTraceName(name, MEMORY_TRACE_NAME_SUFFIX);
    }

    public static String makeSafeTraceName(String baseName, String suffix) {
        int suffixLength = suffix.length();
        if (baseName.length() + suffixLength > 40) {
            baseName = baseName.substring(0, 40 - suffixLength);
        }
        return baseName + suffix;
    }

    @VisibleForTesting
    public static synchronized void setOutputFile(File file) {
        sOutputFile = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dumpPerf() {
        String json = sPerfTraceStrings.toString();
        if (sOutputFile == null) {
            System.out.println(json);
        } else {
            try {
                PrintStream stream = new PrintStream(new FileOutputStream(sOutputFile, true));
                try {
                    stream.print(json);
                }
                finally {
                    try {
                        stream.close();
                    }
                    catch (Exception ex) {
                        Log.e((String)"PerfTraceEvent", (String)"Unable to close perf trace output file.");
                    }
                }
            }
            catch (FileNotFoundException ex) {
                Log.e((String)"PerfTraceEvent", (String)"Unable to dump perf trace data to output file.");
            }
        }
    }

    private static enum EventType {
        START("S"),
        FINISH("F"),
        INSTANT("I");

        private final String mTypeStr;

        private EventType(String typeStr) {
            this.mTypeStr = typeStr;
        }

        public String toString() {
            return this.mTypeStr;
        }
    }
}

