/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.annotation.TargetApi;
import android.app.ActivityManager;
import android.content.Context;
import android.os.Build;
import android.os.StrictMode;
import android.util.Log;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.chromium.base.ApplicationStatus;
import org.chromium.base.CalledByNative;
import org.chromium.base.CommandLine;

public class SysUtils {
    private static final int ANDROID_LOW_MEMORY_DEVICE_THRESHOLD_MB = 512;
    private static final int KBS_IN_MB = 1024;
    private static final String TAG = "SysUtils";
    private static Boolean sLowEndDevice;

    private SysUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int amountOfPhysicalMemoryMB() {
        block15: {
            Pattern pattern = Pattern.compile("^MemTotal:\\s+([0-9]+) kB$");
            StrictMode.ThreadPolicy oldPolicy = StrictMode.allowThreadDiskReads();
            try (FileReader fileReader = new FileReader("/proc/meminfo");
                 BufferedReader reader = new BufferedReader(fileReader);){
                String line;
                Matcher m;
                do {
                    if ((line = reader.readLine()) != null) continue;
                    Log.w((String)TAG, (String)"/proc/meminfo lacks a MemTotal entry?");
                    break block15;
                } while (!(m = pattern.matcher(line)).find());
                int totalMemoryKB = Integer.parseInt(m.group(1));
                if (totalMemoryKB <= 1024) {
                    Log.w((String)TAG, (String)("Invalid /proc/meminfo total size in kB: " + m.group(1)));
                    break block15;
                }
                int n = totalMemoryKB / 1024;
                return n;
            }
            catch (Exception e) {
                Log.w((String)TAG, (String)"Cannot get total physical size from /proc/meminfo", (Throwable)e);
            }
            finally {
                StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)oldPolicy);
            }
        }
        return 0;
    }

    @CalledByNative
    public static boolean isLowEndDevice() {
        if (sLowEndDevice == null) {
            sLowEndDevice = SysUtils.detectLowEndDevice();
        }
        return sLowEndDevice;
    }

    @TargetApi(value=19)
    private static boolean detectLowEndDevice() {
        assert (CommandLine.isInitialized());
        if (CommandLine.getInstance().hasSwitch("enable-low-end-device-mode")) {
            return true;
        }
        if (CommandLine.getInstance().hasSwitch("disable-low-end-device-mode")) {
            return false;
        }
        if (Build.VERSION.SDK_INT < 19) {
            return false;
        }
        Context context = ApplicationStatus.getApplicationContext();
        if (context != null) {
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            if (activityManager.isLowRamDevice()) {
                return true;
            }
        } else {
            Log.e((String)TAG, (String)"ApplicationContext is null in ApplicationStatus");
        }
        int ramSizeMB = SysUtils.amountOfPhysicalMemoryMB();
        if (ramSizeMB <= 0) {
            return false;
        }
        return ramSizeMB < 512;
    }
}

