/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.os.Handler;
import android.os.Message;
import android.util.Log;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.chromium.base.CalledByNative;

class SystemMessageHandler
extends Handler {
    private static final String TAG = "SystemMessageHandler";
    private static final int SCHEDULED_WORK = 1;
    private static final int DELAYED_SCHEDULED_WORK = 2;
    private long mMessagePumpDelegateNative = 0L;
    private long mDelayedScheduledTimeTicks = 0L;
    private Method mMessageMethodSetAsynchronous;

    private SystemMessageHandler(long messagePumpDelegateNative) {
        this.mMessagePumpDelegateNative = messagePumpDelegateNative;
        try {
            Class<?> messageClass = Class.forName("android.os.Message");
            this.mMessageMethodSetAsynchronous = messageClass.getMethod("setAsynchronous", Boolean.TYPE);
        }
        catch (ClassNotFoundException e) {
            Log.e((String)TAG, (String)("Failed to find android.os.Message class:" + e));
        }
        catch (NoSuchMethodException e) {
            Log.e((String)TAG, (String)("Failed to load Message.setAsynchronous method:" + e));
        }
        catch (RuntimeException e) {
            Log.e((String)TAG, (String)("Exception while loading Message.setAsynchronous method: " + e));
        }
    }

    public void handleMessage(Message msg) {
        if (msg.what == 2) {
            this.mDelayedScheduledTimeTicks = 0L;
        }
        this.nativeDoRunLoopOnce(this.mMessagePumpDelegateNative, this.mDelayedScheduledTimeTicks);
    }

    @CalledByNative
    private void scheduleWork() {
        this.sendMessage(this.obtainAsyncMessage(1));
    }

    @CalledByNative
    private void scheduleDelayedWork(long delayedTimeTicks, long millis) {
        if (this.mDelayedScheduledTimeTicks != 0L) {
            this.removeMessages(2);
        }
        this.mDelayedScheduledTimeTicks = delayedTimeTicks;
        this.sendMessageDelayed(this.obtainAsyncMessage(2), millis);
    }

    @CalledByNative
    private void removeAllPendingMessages() {
        this.removeMessages(1);
        this.removeMessages(2);
    }

    private Message obtainAsyncMessage(int what) {
        Message msg = Message.obtain();
        msg.what = what;
        if (this.mMessageMethodSetAsynchronous != null) {
            try {
                this.mMessageMethodSetAsynchronous.invoke((Object)msg, true);
            }
            catch (IllegalAccessException e) {
                Log.e((String)TAG, (String)"Illegal access to asynchronous message creation, disabling.");
                this.mMessageMethodSetAsynchronous = null;
            }
            catch (IllegalArgumentException e) {
                Log.e((String)TAG, (String)"Illegal argument for asynchronous message creation, disabling.");
                this.mMessageMethodSetAsynchronous = null;
            }
            catch (InvocationTargetException e) {
                Log.e((String)TAG, (String)"Invocation exception during asynchronous message creation, disabling.");
                this.mMessageMethodSetAsynchronous = null;
            }
            catch (RuntimeException e) {
                Log.e((String)TAG, (String)"Runtime exception during asynchronous message creation, disabling.");
                this.mMessageMethodSetAsynchronous = null;
            }
        }
        return msg;
    }

    @CalledByNative
    private static SystemMessageHandler create(long messagePumpDelegateNative) {
        return new SystemMessageHandler(messagePumpDelegateNative);
    }

    private native void nativeDoRunLoopOnce(long var1, long var3);
}

