/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base.library_loader;

import android.os.Bundle;
import android.os.Parcel;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import org.chromium.base.CalledByNative;
import org.chromium.base.Log;
import org.chromium.base.SysUtils;
import org.chromium.base.ThreadUtils;
import org.chromium.base.library_loader.Linker;
import org.chromium.base.library_loader.NativeLibraries;

class LegacyLinker
extends Linker {
    private static final String TAG = "cr.library_loader";
    private static final String LINKER_JNI_LIBRARY = "chromium_android_linker";
    private boolean mInitialized = false;
    private boolean mRelroSharingSupported = false;
    private boolean mInBrowserProcess = true;
    private boolean mWaitForSharedRelros = false;
    private boolean mBrowserUsesSharedRelro = false;
    private Bundle mSharedRelros = null;
    private long mBaseLoadAddress = 0L;
    private long mCurrentLoadAddress = 0L;
    private boolean mPrepareLibraryLoadCalled = false;
    protected HashMap<String, Linker.LibInfo> mLoadedLibraries = null;

    LegacyLinker() {
    }

    private void ensureInitializedLocked() {
        assert (Thread.holdsLock(this.mLock));
        if (this.mInitialized) {
            return;
        }
        this.mRelroSharingSupported = false;
        if (NativeLibraries.sUseLinker) {
            try {
                System.loadLibrary(LINKER_JNI_LIBRARY);
            }
            catch (UnsatisfiedLinkError e) {
                Log.w(TAG, "Couldn't load libchromium_android_linker.so, trying libchromium_android_linker.cr.so", new Object[0]);
                System.loadLibrary("chromium_android_linker.cr");
            }
            this.mRelroSharingSupported = LegacyLinker.nativeCanUseSharedRelro();
            if (!this.mRelroSharingSupported) {
                Log.w(TAG, "This system cannot safely share RELRO sections", new Object[0]);
            }
            if (this.mMemoryDeviceConfig == 0) {
                this.mMemoryDeviceConfig = SysUtils.isLowEndDevice() ? 1 : 2;
            }
            switch (1) {
                case 0: {
                    this.mBrowserUsesSharedRelro = false;
                    break;
                }
                case 1: {
                    if (this.mMemoryDeviceConfig == 1) {
                        this.mBrowserUsesSharedRelro = true;
                        Log.w(TAG, "Low-memory device: shared RELROs used in all processes", new Object[0]);
                        break;
                    }
                    this.mBrowserUsesSharedRelro = false;
                    break;
                }
                case 2: {
                    Log.w(TAG, "Beware: shared RELROs used in all processes!", new Object[0]);
                    this.mBrowserUsesSharedRelro = true;
                    break;
                }
                default: {
                    assert (false) : "Unreached";
                    break;
                }
            }
        }
        if (!this.mRelroSharingSupported) {
            this.mBrowserUsesSharedRelro = false;
            this.mWaitForSharedRelros = false;
        }
        this.mInitialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUsed() {
        if (!NativeLibraries.sUseLinker) {
            return false;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.ensureInitializedLocked();
            return this.mRelroSharingSupported;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUsingBrowserSharedRelros() {
        Object object = this.mLock;
        synchronized (object) {
            this.ensureInitializedLocked();
            return this.mBrowserUsesSharedRelro;
        }
    }

    @Override
    public boolean isInZipFile() {
        return NativeLibraries.sUseLibraryInZipFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepareLibraryLoad() {
        Object object = this.mLock;
        synchronized (object) {
            this.mPrepareLibraryLoadCalled = true;
            if (this.mInBrowserProcess) {
                this.setupBaseLoadAddressLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishLibraryLoad() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mLoadedLibraries != null) {
                if (this.mInBrowserProcess) {
                    this.mSharedRelros = this.createBundleFromLibInfoMap(this.mLoadedLibraries);
                    if (this.mBrowserUsesSharedRelro) {
                        this.useSharedRelrosLocked(this.mSharedRelros);
                    }
                }
                if (this.mWaitForSharedRelros) {
                    assert (!this.mInBrowserProcess);
                    while (this.mSharedRelros == null) {
                        try {
                            this.mLock.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    this.useSharedRelrosLocked(this.mSharedRelros);
                    this.mSharedRelros.clear();
                    this.mSharedRelros = null;
                }
            }
            if (NativeLibraries.sEnableLinkerTests && this.mTestRunnerClassName != null) {
                Linker.TestRunner testRunner = null;
                try {
                    testRunner = (Linker.TestRunner)Class.forName(this.mTestRunnerClassName).newInstance();
                }
                catch (Exception e) {
                    Log.e(TAG, "Could not extract test runner class name", e);
                    testRunner = null;
                }
                if (testRunner != null) {
                    if (!testRunner.runChecks(this.mMemoryDeviceConfig, this.mInBrowserProcess)) {
                        Log.wtf(TAG, "Linker runtime tests failed in this process!!", new Object[0]);
                        assert (false);
                    } else {
                        Log.i(TAG, "All linker tests passed!", new Object[0]);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void useSharedRelros(Bundle bundle) {
        Bundle clonedBundle = null;
        if (bundle != null) {
            bundle.setClassLoader(Linker.LibInfo.class.getClassLoader());
            clonedBundle = new Bundle(Linker.LibInfo.class.getClassLoader());
            Parcel parcel = Parcel.obtain();
            bundle.writeToParcel(parcel, 0);
            parcel.setDataPosition(0);
            clonedBundle.readFromParcel(parcel);
            parcel.recycle();
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mSharedRelros = clonedBundle;
            this.mLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bundle getSharedRelros() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mInBrowserProcess) {
                return null;
            }
            return this.mSharedRelros;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disableSharedRelros() {
        Object object = this.mLock;
        synchronized (object) {
            this.mInBrowserProcess = false;
            this.mWaitForSharedRelros = false;
            this.mBrowserUsesSharedRelro = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initServiceProcess(long baseLoadAddress) {
        Object object = this.mLock;
        synchronized (object) {
            this.ensureInitializedLocked();
            this.mInBrowserProcess = false;
            this.mBrowserUsesSharedRelro = false;
            if (this.mRelroSharingSupported) {
                this.mWaitForSharedRelros = true;
                this.mBaseLoadAddress = baseLoadAddress;
                this.mCurrentLoadAddress = baseLoadAddress;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getBaseLoadAddress() {
        Object object = this.mLock;
        synchronized (object) {
            this.ensureInitializedLocked();
            if (!this.mInBrowserProcess) {
                Log.w(TAG, "Shared RELRO sections are disabled in this process!", new Object[0]);
                return 0L;
            }
            this.setupBaseLoadAddressLocked();
            return this.mBaseLoadAddress;
        }
    }

    private void setupBaseLoadAddressLocked() {
        assert (Thread.holdsLock(this.mLock));
        if (this.mBaseLoadAddress == 0L) {
            long address;
            this.mBaseLoadAddress = address = this.computeRandomBaseLoadAddress();
            this.mCurrentLoadAddress = address;
            if (address == 0L) {
                Log.w(TAG, "Disabling shared RELROs due address space pressure", new Object[0]);
                this.mBrowserUsesSharedRelro = false;
                this.mWaitForSharedRelros = false;
            }
        }
    }

    private long computeRandomBaseLoadAddress() {
        long maxExpectedBytes = 0xC000000L;
        long address = LegacyLinker.nativeGetRandomBaseLoadAddress(0xC000000L);
        return address;
    }

    private void dumpBundle(Bundle bundle) {
    }

    private void useSharedRelrosLocked(Bundle bundle) {
        assert (Thread.holdsLock(this.mLock));
        if (bundle == null) {
            return;
        }
        if (!this.mRelroSharingSupported) {
            return;
        }
        if (this.mLoadedLibraries == null) {
            return;
        }
        HashMap<String, Linker.LibInfo> relroMap = this.createLibInfoMapFromBundle(bundle);
        for (Map.Entry<String, Linker.LibInfo> entry : relroMap.entrySet()) {
            Linker.LibInfo libInfo;
            String libName = entry.getKey();
            if (LegacyLinker.nativeUseSharedRelro(libName, libInfo = entry.getValue())) continue;
            Log.w(TAG, "Could not use shared RELRO section for " + libName, new Object[0]);
        }
        if (!this.mInBrowserProcess) {
            this.closeLibInfoMap(relroMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadLibrary(@Nullable String zipFilePath, String libFilePath) {
        Object object = this.mLock;
        synchronized (object) {
            this.ensureInitializedLocked();
            assert (this.mPrepareLibraryLoadCalled);
            if (this.mLoadedLibraries == null) {
                this.mLoadedLibraries = new HashMap();
            }
            if (this.mLoadedLibraries.containsKey(libFilePath)) {
                return;
            }
            Linker.LibInfo libInfo = new Linker.LibInfo();
            long loadAddress = 0L;
            if (this.mInBrowserProcess && this.mBrowserUsesSharedRelro || this.mWaitForSharedRelros) {
                loadAddress = this.mCurrentLoadAddress;
            }
            String sharedRelRoName = libFilePath;
            if (zipFilePath != null) {
                if (!LegacyLinker.nativeLoadLibraryInZipFile(zipFilePath, libFilePath, loadAddress, libInfo)) {
                    String errorMessage = "Unable to load library: " + libFilePath + ", in: " + zipFilePath;
                    Log.e(TAG, errorMessage, new Object[0]);
                    throw new UnsatisfiedLinkError(errorMessage);
                }
                sharedRelRoName = zipFilePath;
            } else if (!LegacyLinker.nativeLoadLibrary(libFilePath, loadAddress, libInfo)) {
                String errorMessage = "Unable to load library: " + libFilePath;
                Log.e(TAG, errorMessage, new Object[0]);
                throw new UnsatisfiedLinkError(errorMessage);
            }
            if (NativeLibraries.sEnableLinkerTests) {
                Log.i(TAG, String.format(Locale.US, "%s_LIBRARY_ADDRESS: %s %x", this.mInBrowserProcess ? "BROWSER" : "RENDERER", libFilePath, libInfo.mLoadAddress), new Object[0]);
            }
            if (this.mInBrowserProcess && !LegacyLinker.nativeCreateSharedRelro(sharedRelRoName, this.mCurrentLoadAddress, libInfo)) {
                Log.w(TAG, String.format(Locale.US, "Could not create shared RELRO for %s at %x", libFilePath, this.mCurrentLoadAddress), new Object[0]);
            }
            if (this.mCurrentLoadAddress != 0L) {
                this.mCurrentLoadAddress = libInfo.mLoadAddress + libInfo.mLoadSize;
            }
            this.mLoadedLibraries.put(sharedRelRoName, libInfo);
        }
    }

    @Override
    public boolean isChromiumLinkerLibrary(String library) {
        return library.equals(LINKER_JNI_LIBRARY) || library.equals("chromium_android_linker.cr");
    }

    @CalledByNative
    public static void postCallbackOnMainThread(final long opaque) {
        ThreadUtils.postOnUiThread(new Runnable(){

            @Override
            public void run() {
                LegacyLinker.nativeRunCallbackOnUiThread(opaque);
            }
        });
    }

    private static native void nativeRunCallbackOnUiThread(long var0);

    private static native boolean nativeLoadLibrary(String var0, long var1, Linker.LibInfo var3);

    private static native boolean nativeLoadLibraryInZipFile(String var0, String var1, long var2, Linker.LibInfo var4);

    private static native boolean nativeCreateSharedRelro(String var0, long var1, Linker.LibInfo var3);

    private static native boolean nativeUseSharedRelro(String var0, Linker.LibInfo var1);

    private static native boolean nativeCanUseSharedRelro();

    private static native long nativeGetRandomBaseLoadAddress(long var0);
}

