/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base.library_loader;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.os.AsyncTask;
import android.os.Build;
import android.os.SystemClock;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.chromium.base.CalledByNative;
import org.chromium.base.CommandLine;
import org.chromium.base.JNINamespace;
import org.chromium.base.Log;
import org.chromium.base.PackageUtils;
import org.chromium.base.TraceEvent;
import org.chromium.base.library_loader.Linker;
import org.chromium.base.library_loader.NativeLibraries;
import org.chromium.base.library_loader.ProcessInitException;
import org.chromium.base.metrics.RecordHistogram;

@JNINamespace(value="base::android")
public class LibraryLoader {
    private static final String TAG = "cr.library_loader";
    private static final boolean DEBUG = false;
    private static final Object sLock = new Object();
    private static volatile LibraryLoader sInstance;
    private boolean mLoaded;
    private boolean mCommandLineSwitched;
    private volatile boolean mInitialized;
    private boolean mIsUsingBrowserSharedRelros;
    private boolean mLoadAtFixedAddressFailed;
    private boolean mLibraryWasLoadedFromApk;
    private final int mLibraryProcessType;
    private final AtomicBoolean mPrefetchLibraryHasBeenCalled;
    private long mLibraryLoadTimeMs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LibraryLoader get(int libraryProcessType) throws ProcessInitException {
        Object object = sLock;
        synchronized (object) {
            if (sInstance != null) {
                if (LibraryLoader.sInstance.mLibraryProcessType == libraryProcessType) {
                    return sInstance;
                }
                throw new ProcessInitException(2);
            }
            sInstance = new LibraryLoader(libraryProcessType);
            return sInstance;
        }
    }

    private LibraryLoader(int libraryProcessType) {
        this.mLibraryProcessType = libraryProcessType;
        this.mPrefetchLibraryHasBeenCalled = new AtomicBoolean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureInitialized(Context context) throws ProcessInitException {
        Object object = sLock;
        synchronized (object) {
            if (this.mInitialized) {
                return;
            }
            this.loadAlreadyLocked(context);
            this.initializeAlreadyLocked();
        }
    }

    public static boolean isInitialized() {
        return sInstance != null && LibraryLoader.sInstance.mInitialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadNow(Context context) throws ProcessInitException {
        Object object = sLock;
        synchronized (object) {
            this.loadAlreadyLocked(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws ProcessInitException {
        Object object = sLock;
        synchronized (object) {
            this.initializeAlreadyLocked();
        }
    }

    public void asyncPrefetchLibrariesToMemory() {
        if (!this.mPrefetchLibraryHasBeenCalled.compareAndSet(false, true)) {
            return;
        }
        new AsyncTask<Void, Void, Void>(){

            protected Void doInBackground(Void ... params) {
                TraceEvent.begin("LibraryLoader.asyncPrefetchLibrariesToMemory");
                boolean success = LibraryLoader.nativeForkAndPrefetchNativeLibrary();
                if (!success) {
                    Log.w(LibraryLoader.TAG, "Forking a process to prefetch the native library failed.", new Object[0]);
                }
                RecordHistogram.recordBooleanHistogram("LibraryLoader.PrefetchStatus", success);
                TraceEvent.end("LibraryLoader.asyncPrefetchLibrariesToMemory");
                return null;
            }
        }.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, (Object[])new Void[0]);
    }

    private void loadAlreadyLocked(Context context) throws ProcessInitException {
        block13: {
            try {
                if (this.mLoaded) break block13;
                assert (!this.mInitialized);
                long startTime = SystemClock.uptimeMillis();
                Linker linker = Linker.getInstance();
                boolean useChromiumLinker = linker.isUsed();
                if (useChromiumLinker) {
                    String apkFilePath = LibraryLoader.getLibraryApkPath(context);
                    linker.prepareLibraryLoad();
                    for (String library : NativeLibraries.LIBRARIES) {
                        if (linker.isChromiumLinkerLibrary(library)) continue;
                        String zipFilePath = null;
                        String libFilePath = System.mapLibraryName(library);
                        if (linker.isInZipFile()) {
                            zipFilePath = apkFilePath;
                            Log.i(TAG, "Loading " + library + " directly from within " + apkFilePath, new Object[0]);
                        } else {
                            Log.i(TAG, "Loading " + library, new Object[0]);
                        }
                        boolean isLoaded = false;
                        if (linker.isUsingBrowserSharedRelros()) {
                            this.mIsUsingBrowserSharedRelros = true;
                            try {
                                this.loadLibrary(zipFilePath, libFilePath);
                                isLoaded = true;
                            }
                            catch (UnsatisfiedLinkError e) {
                                Log.w(TAG, "Failed to load native library with shared RELRO, retrying without", new Object[0]);
                                linker.disableSharedRelros();
                                this.mLoadAtFixedAddressFailed = true;
                            }
                        }
                        if (isLoaded) continue;
                        this.loadLibrary(zipFilePath, libFilePath);
                    }
                    linker.finishLibraryLoad();
                } else {
                    for (String library : NativeLibraries.LIBRARIES) {
                        System.loadLibrary(library);
                    }
                }
                long stopTime = SystemClock.uptimeMillis();
                this.mLibraryLoadTimeMs = stopTime - startTime;
                Log.i(TAG, String.format("Time to load native libraries: %d ms (timestamps %d-%d)", this.mLibraryLoadTimeMs, startTime % 10000L, stopTime % 10000L), new Object[0]);
                this.mLoaded = true;
            }
            catch (UnsatisfiedLinkError e) {
                throw new ProcessInitException(2, (Throwable)e);
            }
        }
        Log.i(TAG, String.format("Expected native library version number \"%s\", actual native library version number \"%s\"", NativeLibraries.sVersionNumber, this.nativeGetVersionNumber()), new Object[0]);
        if (!NativeLibraries.sVersionNumber.equals(this.nativeGetVersionNumber())) {
            throw new ProcessInitException(3);
        }
    }

    private static boolean isAbiSplit(String splitName) {
        return splitName.startsWith("abi_");
    }

    @TargetApi(value=21)
    private static String getLibraryApkPath(Context context) {
        ApplicationInfo appInfo = context.getApplicationInfo();
        if (Build.VERSION.SDK_INT < 21) {
            return appInfo.sourceDir;
        }
        PackageInfo packageInfo = PackageUtils.getOwnPackageInfo(context);
        if (packageInfo.splitNames != null) {
            for (int i = 0; i < packageInfo.splitNames.length; ++i) {
                if (!LibraryLoader.isAbiSplit(packageInfo.splitNames[i])) continue;
                return appInfo.splitSourceDirs[i];
            }
        }
        return appInfo.sourceDir;
    }

    private void loadLibrary(@Nullable String zipFilePath, String libFilePath) {
        Linker.getInstance().loadLibrary(zipFilePath, libFilePath);
        if (zipFilePath != null) {
            this.mLibraryWasLoadedFromApk = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchCommandLineForWebView() {
        Object object = sLock;
        synchronized (object) {
            this.ensureCommandLineSwitchedAlreadyLocked();
        }
    }

    private void ensureCommandLineSwitchedAlreadyLocked() {
        assert (this.mLoaded);
        if (this.mCommandLineSwitched) {
            return;
        }
        this.nativeInitCommandLine(CommandLine.getJavaSwitchesOrNull());
        CommandLine.enableNativeProxy();
        this.mCommandLineSwitched = true;
    }

    private void initializeAlreadyLocked() throws ProcessInitException {
        if (this.mInitialized) {
            return;
        }
        if (!this.mCommandLineSwitched) {
            this.nativeInitCommandLine(CommandLine.getJavaSwitchesOrNull());
        }
        if (!this.nativeLibraryLoaded()) {
            Log.e(TAG, "error calling nativeLibraryLoaded", new Object[0]);
            throw new ProcessInitException(1);
        }
        if (!this.mCommandLineSwitched) {
            CommandLine.enableNativeProxy();
            this.mCommandLineSwitched = true;
        }
        TraceEvent.registerNativeEnabledObserver();
        this.mInitialized = true;
    }

    public void onNativeInitializationComplete(Context context) {
        this.recordBrowserProcessHistogram(context);
    }

    private void recordBrowserProcessHistogram(Context context) {
        if (Linker.getInstance().isUsed()) {
            this.nativeRecordChromiumAndroidLinkerBrowserHistogram(this.mIsUsingBrowserSharedRelros, this.mLoadAtFixedAddressFailed, this.getLibraryLoadFromApkStatus(context), this.mLibraryLoadTimeMs);
        }
    }

    private int getLibraryLoadFromApkStatus(Context context) {
        assert (Linker.getInstance().isUsed());
        if (this.mLibraryWasLoadedFromApk) {
            return 3;
        }
        return 0;
    }

    public void registerRendererProcessHistogram(boolean requestedSharedRelro, boolean loadAtFixedAddressFailed) {
        if (Linker.getInstance().isUsed()) {
            this.nativeRegisterChromiumAndroidLinkerRendererHistogram(requestedSharedRelro, loadAtFixedAddressFailed, this.mLibraryLoadTimeMs);
        }
    }

    @CalledByNative
    public static int getLibraryProcessType() {
        if (sInstance == null) {
            return 0;
        }
        return LibraryLoader.sInstance.mLibraryProcessType;
    }

    private native void nativeInitCommandLine(String[] var1);

    private native boolean nativeLibraryLoaded();

    private native void nativeRecordChromiumAndroidLinkerBrowserHistogram(boolean var1, boolean var2, int var3, long var4);

    private native void nativeRegisterChromiumAndroidLinkerRendererHistogram(boolean var1, boolean var2, long var3);

    private native String nativeGetVersionNumber();

    private static native boolean nativeForkAndPrefetchNativeLibrary();
}

