/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base.library_loader;

import android.os.Bundle;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import org.chromium.base.Log;
import org.chromium.base.annotations.AccessedByNative;
import org.chromium.base.library_loader.LegacyLinker;
import org.chromium.base.library_loader.NativeLibraries;

public abstract class Linker {
    private static final String TAG = "cr.library_loader";
    protected static final boolean DEBUG = false;
    public static final String EXTRA_LINKER_SHARED_RELROS = "org.chromium.base.android.linker.shared_relros";
    protected final Object mLock = new Object();
    public static final int BROWSER_SHARED_RELRO_CONFIG_NEVER = 0;
    public static final int BROWSER_SHARED_RELRO_CONFIG_LOW_RAM_ONLY = 1;
    public static final int BROWSER_SHARED_RELRO_CONFIG_ALWAYS = 2;
    public static final int BROWSER_SHARED_RELRO_CONFIG = 1;
    public static final int MEMORY_DEVICE_CONFIG_INIT = 0;
    public static final int MEMORY_DEVICE_CONFIG_LOW = 1;
    public static final int MEMORY_DEVICE_CONFIG_NORMAL = 2;
    protected int mMemoryDeviceConfig = 0;
    private static Linker sSingleton = null;
    private static Object sSingletonLock = new Object();
    String mTestRunnerClassName = null;

    protected Linker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Linker getInstance() {
        Object object = sSingletonLock;
        synchronized (object) {
            if (sSingleton == null) {
                sSingleton = new LegacyLinker();
            }
            return sSingleton;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTestRunnerClassName(String testRunnerClassName) {
        if (!NativeLibraries.sEnableLinkerTests) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            assert (this.mTestRunnerClassName == null);
            this.mTestRunnerClassName = testRunnerClassName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTestRunnerClassName() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mTestRunnerClassName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMemoryDeviceConfig(int memoryDeviceConfig) {
        assert (NativeLibraries.sEnableLinkerTests);
        Object object = this.mLock;
        synchronized (object) {
            assert (this.mMemoryDeviceConfig == 0);
            assert (memoryDeviceConfig == 1 || memoryDeviceConfig == 2);
            this.mMemoryDeviceConfig = memoryDeviceConfig;
        }
    }

    public abstract boolean isUsed();

    public abstract boolean isUsingBrowserSharedRelros();

    public abstract boolean isInZipFile();

    public abstract void prepareLibraryLoad();

    public abstract void finishLibraryLoad();

    public abstract void useSharedRelros(Bundle var1);

    public abstract Bundle getSharedRelros();

    public abstract void disableSharedRelros();

    public abstract void initServiceProcess(long var1);

    public abstract long getBaseLoadAddress();

    public abstract void loadLibrary(@Nullable String var1, String var2);

    public abstract boolean isChromiumLinkerLibrary(String var1);

    protected Bundle createBundleFromLibInfoMap(HashMap<String, LibInfo> map) {
        Bundle bundle = new Bundle(map.size());
        for (Map.Entry<String, LibInfo> entry : map.entrySet()) {
            bundle.putParcelable(entry.getKey(), (Parcelable)entry.getValue());
        }
        return bundle;
    }

    protected HashMap<String, LibInfo> createLibInfoMapFromBundle(Bundle bundle) {
        HashMap<String, LibInfo> map = new HashMap<String, LibInfo>();
        for (String library : bundle.keySet()) {
            LibInfo libInfo = (LibInfo)bundle.getParcelable(library);
            map.put(library, libInfo);
        }
        return map;
    }

    protected void closeLibInfoMap(HashMap<String, LibInfo> map) {
        for (Map.Entry<String, LibInfo> entry : map.entrySet()) {
            entry.getValue().close();
        }
    }

    public static class LibInfo
    implements Parcelable {
        public static final Parcelable.Creator<LibInfo> CREATOR = new Parcelable.Creator<LibInfo>(){

            public LibInfo createFromParcel(Parcel in) {
                return new LibInfo(in);
            }

            public LibInfo[] newArray(int size) {
                return new LibInfo[size];
            }
        };
        @AccessedByNative
        public long mLoadAddress;
        @AccessedByNative
        public long mLoadSize;
        @AccessedByNative
        public long mRelroStart;
        @AccessedByNative
        public long mRelroSize;
        @AccessedByNative
        public int mRelroFd;

        public LibInfo() {
            this.mLoadAddress = 0L;
            this.mLoadSize = 0L;
            this.mRelroStart = 0L;
            this.mRelroSize = 0L;
            this.mRelroFd = -1;
        }

        public void close() {
            if (this.mRelroFd >= 0) {
                try {
                    ParcelFileDescriptor.adoptFd((int)this.mRelroFd).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.mRelroFd = -1;
            }
        }

        public LibInfo(Parcel in) {
            this.mLoadAddress = in.readLong();
            this.mLoadSize = in.readLong();
            this.mRelroStart = in.readLong();
            this.mRelroSize = in.readLong();
            ParcelFileDescriptor fd = (ParcelFileDescriptor)ParcelFileDescriptor.CREATOR.createFromParcel(in);
            this.mRelroFd = fd == null ? -1 : fd.detachFd();
        }

        public void writeToParcel(Parcel out, int flags) {
            if (this.mRelroFd >= 0) {
                out.writeLong(this.mLoadAddress);
                out.writeLong(this.mLoadSize);
                out.writeLong(this.mRelroStart);
                out.writeLong(this.mRelroSize);
                try {
                    ParcelFileDescriptor fd = ParcelFileDescriptor.fromFd((int)this.mRelroFd);
                    fd.writeToParcel(out, 0);
                    fd.close();
                }
                catch (IOException e) {
                    Log.e(Linker.TAG, "Cant' write LibInfo file descriptor to parcel", e);
                }
            }
        }

        public int describeContents() {
            return 1;
        }

        public String toString() {
            return String.format(Locale.US, "[load=0x%x-0x%x relro=0x%x-0x%x fd=%d]", this.mLoadAddress, this.mLoadAddress + this.mLoadSize, this.mRelroStart, this.mRelroStart + this.mRelroSize, this.mRelroFd);
        }
    }

    public static interface TestRunner {
        public boolean runChecks(int var1, boolean var2);
    }
}

