/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base.metrics;

import java.util.concurrent.TimeUnit;
import org.chromium.base.JNINamespace;
import org.chromium.base.VisibleForTesting;

@JNINamespace(value="base::android")
public class RecordHistogram {
    public static void recordBooleanHistogram(String name, boolean sample) {
        RecordHistogram.nativeRecordBooleanHistogram(name, System.identityHashCode(name), sample);
    }

    public static void recordEnumeratedHistogram(String name, int sample, int boundary) {
        RecordHistogram.nativeRecordEnumeratedHistogram(name, System.identityHashCode(name), sample, boundary);
    }

    public static void recordCountHistogram(String name, int sample) {
        RecordHistogram.recordCustomCountHistogram(name, sample, 1, 1000000, 50);
    }

    public static void recordCount100Histogram(String name, int sample) {
        RecordHistogram.recordCustomCountHistogram(name, sample, 1, 100, 50);
    }

    public static void recordCustomCountHistogram(String name, int sample, int min, int max, int numBuckets) {
        RecordHistogram.nativeRecordCustomCountHistogram(name, System.identityHashCode(name), sample, min, max, numBuckets);
    }

    public static void recordSparseSlowlyHistogram(String name, int sample) {
        RecordHistogram.nativeRecordSparseHistogram(name, System.identityHashCode(name), sample);
    }

    public static void recordTimesHistogram(String name, long duration, TimeUnit timeUnit) {
        RecordHistogram.recordCustomTimesHistogramMilliseconds(name, timeUnit.toMillis(duration), 1L, TimeUnit.SECONDS.toMillis(10L), 50);
    }

    public static void recordMediumTimesHistogram(String name, long duration, TimeUnit timeUnit) {
        RecordHistogram.recordCustomTimesHistogramMilliseconds(name, timeUnit.toMillis(duration), 10L, TimeUnit.MINUTES.toMillis(3L), 50);
    }

    public static void recordLongTimesHistogram(String name, long duration, TimeUnit timeUnit) {
        RecordHistogram.recordCustomTimesHistogramMilliseconds(name, timeUnit.toMillis(duration), 1L, TimeUnit.HOURS.toMillis(1L), 50);
    }

    public static void recordCustomTimesHistogram(String name, long duration, long min, long max, TimeUnit timeUnit, int numBuckets) {
        RecordHistogram.recordCustomTimesHistogramMilliseconds(name, timeUnit.toMillis(duration), timeUnit.toMillis(min), timeUnit.toMillis(max), numBuckets);
    }

    private static void recordCustomTimesHistogramMilliseconds(String name, long duration, long min, long max, int numBuckets) {
        RecordHistogram.nativeRecordCustomTimesHistogramMilliseconds(name, System.identityHashCode(name), duration, min, max, numBuckets);
    }

    @VisibleForTesting
    public static int getHistogramValueCountForTesting(String name, int sample) {
        return RecordHistogram.nativeGetHistogramValueCountForTesting(name, sample);
    }

    public static void initialize() {
        RecordHistogram.nativeInitialize();
    }

    private static native void nativeRecordCustomTimesHistogramMilliseconds(String var0, int var1, long var2, long var4, long var6, int var8);

    private static native void nativeRecordBooleanHistogram(String var0, int var1, boolean var2);

    private static native void nativeRecordEnumeratedHistogram(String var0, int var1, int var2, int var3);

    private static native void nativeRecordCustomCountHistogram(String var0, int var1, int var2, int var3, int var4, int var5);

    private static native void nativeRecordSparseHistogram(String var0, int var1, int var2);

    private static native int nativeGetHistogramValueCountForTesting(String var0, int var1);

    private static native void nativeInitialize();
}

