/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.app;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.graphics.SurfaceTexture;
import android.os.Bundle;
import android.os.Debug;
import android.os.IBinder;
import android.os.Parcelable;
import android.os.Process;
import android.os.RemoteException;
import android.view.Surface;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import org.chromium.base.CalledByNative;
import org.chromium.base.CommandLine;
import org.chromium.base.JNINamespace;
import org.chromium.base.Log;
import org.chromium.base.annotations.SuppressFBWarnings;
import org.chromium.base.library_loader.LibraryLoader;
import org.chromium.base.library_loader.Linker;
import org.chromium.base.library_loader.ProcessInitException;
import org.chromium.content.app.ChromiumLinkerParams;
import org.chromium.content.app.ContentMain;
import org.chromium.content.browser.FileDescriptorInfo;
import org.chromium.content.common.IChildProcessCallback;
import org.chromium.content.common.IChildProcessService;

@JNINamespace(value="content")
public class ChildProcessService
extends Service {
    private static final String MAIN_THREAD_NAME = "ChildProcessMain";
    private static final String TAG = "cr.ChildProcessService";
    private IChildProcessCallback mCallback;
    private Thread mMainThread;
    private String[] mCommandLineParams;
    private int mCpuCount;
    private long mCpuFeatures;
    private FileDescriptorInfo[] mFdInfos;
    private ChromiumLinkerParams mLinkerParams;
    private static AtomicReference<Context> sContext = new AtomicReference<Object>(null);
    private boolean mLibraryInitialized = false;
    private boolean mIsBound = false;
    private final Semaphore mActivitySemaphore = new Semaphore(1);
    private final IChildProcessService.Stub mBinder = new IChildProcessService.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int setupConnection(Bundle args, IChildProcessCallback callback) {
            ChildProcessService.this.mCallback = callback;
            args.setClassLoader(ChildProcessService.this.getClassLoader());
            Thread thread = ChildProcessService.this.mMainThread;
            synchronized (thread) {
                if (ChildProcessService.this.mCommandLineParams == null) {
                    ChildProcessService.access$202(ChildProcessService.this, args.getStringArray("com.google.android.apps.chrome.extra.command_line"));
                }
                assert (ChildProcessService.this.mCommandLineParams != null);
                ChildProcessService.this.mCpuCount = args.getInt("com.google.android.apps.chrome.extra.cpu_count");
                ChildProcessService.this.mCpuFeatures = args.getLong("com.google.android.apps.chrome.extra.cpu_features");
                assert (ChildProcessService.this.mCpuCount > 0);
                Parcelable[] fdInfosAsParcelable = args.getParcelableArray("com.google.android.apps.chrome.extra.extraFiles");
                ChildProcessService.access$502(ChildProcessService.this, new FileDescriptorInfo[fdInfosAsParcelable.length]);
                System.arraycopy(fdInfosAsParcelable, 0, ChildProcessService.this.mFdInfos, 0, fdInfosAsParcelable.length);
                Bundle sharedRelros = args.getBundle("org.chromium.base.android.linker.shared_relros");
                if (sharedRelros != null) {
                    Linker.getInstance().useSharedRelros(sharedRelros);
                    sharedRelros = null;
                }
                ChildProcessService.this.mMainThread.notifyAll();
            }
            return Process.myPid();
        }

        @Override
        public void crashIntentionallyForTesting() {
            Process.killProcess((int)Process.myPid());
        }
    };

    static Context getContext() {
        return sContext.get();
    }

    public void onCreate() {
        Log.i(TAG, "Creating new ChildProcessService pid=%d", Process.myPid());
        if (sContext.get() != null) {
            throw new RuntimeException("Illegal child process reuse.");
        }
        sContext.set((Context)this);
        super.onCreate();
        this.mMainThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @SuppressFBWarnings(value={"DM_EXIT"})
            public void run() {
                try {
                    Thread thread = ChildProcessService.this.mMainThread;
                    synchronized (thread) {
                        while (ChildProcessService.this.mCommandLineParams == null) {
                            ChildProcessService.this.mMainThread.wait();
                        }
                    }
                    CommandLine.init(ChildProcessService.this.mCommandLineParams);
                    Linker linker = Linker.getInstance();
                    boolean useLinker = linker.isUsed();
                    boolean requestedSharedRelro = false;
                    if (useLinker) {
                        Thread thread2 = ChildProcessService.this.mMainThread;
                        synchronized (thread2) {
                            while (!ChildProcessService.this.mIsBound) {
                                ChildProcessService.this.mMainThread.wait();
                            }
                        }
                        assert (ChildProcessService.this.mLinkerParams != null);
                        if (((ChildProcessService)ChildProcessService.this).mLinkerParams.mWaitForSharedRelro) {
                            requestedSharedRelro = true;
                            linker.initServiceProcess(((ChildProcessService)ChildProcessService.this).mLinkerParams.mBaseLoadAddress);
                        } else {
                            linker.disableSharedRelros();
                        }
                        linker.setTestRunnerClassName(((ChildProcessService)ChildProcessService.this).mLinkerParams.mTestRunnerClassName);
                    }
                    boolean isLoaded = false;
                    if (CommandLine.getInstance().hasSwitch("renderer-wait-for-java-debugger")) {
                        Debug.waitForDebugger();
                    }
                    boolean loadAtFixedAddressFailed = false;
                    try {
                        LibraryLoader.get(2).loadNow(ChildProcessService.this.getApplicationContext());
                        isLoaded = true;
                    }
                    catch (ProcessInitException e) {
                        if (requestedSharedRelro) {
                            Log.w(ChildProcessService.TAG, "Failed to load native library with shared RELRO, retrying without", new Object[0]);
                            loadAtFixedAddressFailed = true;
                        }
                        Log.e(ChildProcessService.TAG, "Failed to load native library", e);
                    }
                    if (!isLoaded && requestedSharedRelro) {
                        linker.disableSharedRelros();
                        try {
                            LibraryLoader.get(2).loadNow(ChildProcessService.this.getApplicationContext());
                            isLoaded = true;
                        }
                        catch (ProcessInitException e) {
                            Log.e(ChildProcessService.TAG, "Failed to load native library on retry", e);
                        }
                    }
                    if (!isLoaded) {
                        System.exit(-1);
                    }
                    LibraryLoader.get(2).registerRendererProcessHistogram(requestedSharedRelro, loadAtFixedAddressFailed);
                    LibraryLoader.get(2).initialize();
                    Thread e = ChildProcessService.this.mMainThread;
                    synchronized (e) {
                        ChildProcessService.this.mLibraryInitialized = true;
                        ChildProcessService.this.mMainThread.notifyAll();
                        while (ChildProcessService.this.mFdInfos == null) {
                            ChildProcessService.this.mMainThread.wait();
                        }
                    }
                    ContentMain.initApplicationContext(((Context)sContext.get()).getApplicationContext());
                    for (FileDescriptorInfo fdInfo : ChildProcessService.this.mFdInfos) {
                        ChildProcessService.nativeRegisterGlobalFileDescriptor(fdInfo.mId, fdInfo.mFd.detachFd(), fdInfo.mOffset, fdInfo.mSize);
                    }
                    ChildProcessService.nativeInitChildProcess(((Context)sContext.get()).getApplicationContext(), ChildProcessService.this, ChildProcessService.this.mCpuCount, ChildProcessService.this.mCpuFeatures);
                    if (ChildProcessService.this.mActivitySemaphore.tryAcquire()) {
                        ContentMain.start();
                        ChildProcessService.nativeExitChildProcess();
                    }
                }
                catch (InterruptedException e) {
                    Log.w(ChildProcessService.TAG, "%s startup failed: %s", ChildProcessService.MAIN_THREAD_NAME, e);
                }
                catch (ProcessInitException e) {
                    Log.w(ChildProcessService.TAG, "%s startup failed: %s", ChildProcessService.MAIN_THREAD_NAME, e);
                }
            }
        }, MAIN_THREAD_NAME);
        this.mMainThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"DM_EXIT"})
    public void onDestroy() {
        Log.i(TAG, "Destroying ChildProcessService pid=%d", Process.myPid());
        super.onDestroy();
        if (this.mActivitySemaphore.tryAcquire()) {
            System.exit(0);
            return;
        }
        Thread thread = this.mMainThread;
        synchronized (thread) {
            try {
                while (!this.mLibraryInitialized) {
                    this.mMainThread.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.nativeShutdownMainThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IBinder onBind(Intent intent) {
        this.stopSelf();
        Thread thread = this.mMainThread;
        synchronized (thread) {
            this.mCommandLineParams = intent.getStringArrayExtra("com.google.android.apps.chrome.extra.command_line");
            this.mLinkerParams = new ChromiumLinkerParams(intent);
            this.mIsBound = true;
            this.mMainThread.notifyAll();
        }
        return this.mBinder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    private void establishSurfaceTexturePeer(int pid, Object surfaceObject, int primaryID, int secondaryID) {
        if (this.mCallback == null) {
            Log.e(TAG, "No callback interface has been provided.", new Object[0]);
            return;
        }
        Surface surface = null;
        boolean needRelease = false;
        if (surfaceObject instanceof Surface) {
            surface = (Surface)surfaceObject;
        } else if (surfaceObject instanceof SurfaceTexture) {
            surface = new Surface((SurfaceTexture)surfaceObject);
            needRelease = true;
        } else {
            Log.e(TAG, "Not a valid surfaceObject: %s", surfaceObject);
            return;
        }
        try {
            this.mCallback.establishSurfacePeer(pid, surface, primaryID, secondaryID);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Unable to call establishSurfaceTexturePeer: %s", new Object[]{e});
            return;
        }
        finally {
            if (needRelease) {
                surface.release();
            }
        }
    }

    @CalledByNative
    private Surface getViewSurface(int surfaceId) {
        if (this.mCallback == null) {
            Log.e(TAG, "No callback interface has been provided.", new Object[0]);
            return null;
        }
        try {
            return this.mCallback.getViewSurface(surfaceId).getSurface();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Unable to call establishSurfaceTexturePeer: %s", new Object[]{e});
            return null;
        }
    }

    @CalledByNative
    private void createSurfaceTextureSurface(int surfaceTextureId, int clientId, SurfaceTexture surfaceTexture) {
        if (this.mCallback == null) {
            Log.e(TAG, "No callback interface has been provided.", new Object[0]);
            return;
        }
        Surface surface = new Surface(surfaceTexture);
        try {
            this.mCallback.registerSurfaceTextureSurface(surfaceTextureId, clientId, surface);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Unable to call registerSurfaceTextureSurface: %s", new Object[]{e});
        }
        surface.release();
    }

    @CalledByNative
    private void destroySurfaceTextureSurface(int surfaceTextureId, int clientId) {
        if (this.mCallback == null) {
            Log.e(TAG, "No callback interface has been provided.", new Object[0]);
            return;
        }
        try {
            this.mCallback.unregisterSurfaceTextureSurface(surfaceTextureId, clientId);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Unable to call unregisterSurfaceTextureSurface: %s", new Object[]{e});
        }
    }

    @CalledByNative
    private Surface getSurfaceTextureSurface(int surfaceTextureId) {
        if (this.mCallback == null) {
            Log.e(TAG, "No callback interface has been provided.", new Object[0]);
            return null;
        }
        try {
            return this.mCallback.getSurfaceTextureSurface(surfaceTextureId).getSurface();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Unable to call getSurfaceTextureSurface: %s", new Object[]{e});
            return null;
        }
    }

    private static native void nativeRegisterGlobalFileDescriptor(int var0, int var1, long var2, long var4);

    private static native void nativeInitChildProcess(Context var0, ChildProcessService var1, int var2, long var3);

    private static native void nativeExitChildProcess();

    private native void nativeShutdownMainThread();

    static /* synthetic */ String[] access$202(ChildProcessService x0, String[] x1) {
        x0.mCommandLineParams = x1;
        return x1;
    }

    static /* synthetic */ FileDescriptorInfo[] access$502(ChildProcessService x0, FileDescriptorInfo[] x1) {
        x0.mFdInfos = x1;
        return x1;
    }
}

