/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.app;

import android.content.Context;
import android.os.Looper;
import android.os.MessageQueue;
import org.chromium.base.BaseChromiumApplication;
import org.chromium.base.VisibleForTesting;
import org.chromium.base.library_loader.LibraryLoader;
import org.chromium.content.browser.TracingControllerAndroid;

public abstract class ContentApplication
extends BaseChromiumApplication {
    private TracingControllerAndroid mTracingController;
    private boolean mLibraryDependenciesInitialized;

    TracingControllerAndroid getTracingController() {
        if (this.mTracingController == null) {
            this.mTracingController = new TracingControllerAndroid((Context)this);
        }
        return this.mTracingController;
    }

    @Override
    public void onCreate() {
        super.onCreate();
        Looper.myQueue().addIdleHandler(new MessageQueue.IdleHandler(){

            public boolean queueIdle() {
                if (!LibraryLoader.isInitialized()) {
                    return true;
                }
                try {
                    ContentApplication.this.getTracingController().registerReceiver((Context)ContentApplication.this);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return false;
            }
        });
        this.initializeLibraryDependencies();
        this.mLibraryDependenciesInitialized = true;
    }

    protected void initializeLibraryDependencies() {
    }

    @VisibleForTesting
    public boolean areLibraryDependenciesInitialized() {
        return this.mLibraryDependenciesInitialized;
    }

    public void onTerminate() {
        try {
            this.getTracingController().unregisterReceiver((Context)this);
            this.getTracingController().destroy();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        super.onTerminate();
    }
}

