/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import org.chromium.content.browser.ContentVideoViewClient;

public class ActivityContentVideoViewClient
implements ContentVideoViewClient {
    private final Activity mActivity;
    private View mView;

    public ActivityContentVideoViewClient(Activity activity) {
        this.mActivity = activity;
    }

    @Override
    public void enterFullscreenVideo(View view) {
        FrameLayout decor = (FrameLayout)this.mActivity.getWindow().getDecorView();
        decor.addView(view, 0, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1, 17));
        this.setSystemUiVisibility(true);
        this.mView = view;
    }

    @Override
    public void exitFullscreenVideo() {
        FrameLayout decor = (FrameLayout)this.mActivity.getWindow().getDecorView();
        decor.removeView(this.mView);
        this.setSystemUiVisibility(false);
        this.mView = null;
    }

    @Override
    public View getVideoLoadingProgressView() {
        return null;
    }

    @Override
    @SuppressLint(value={"InlinedApi"})
    public void setSystemUiVisibility(boolean enterFullscreen) {
        View decor = this.mActivity.getWindow().getDecorView();
        if (enterFullscreen) {
            this.mActivity.getWindow().setFlags(1024, 1024);
        } else {
            this.mActivity.getWindow().clearFlags(1024);
        }
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        int systemUiVisibility = decor.getSystemUiVisibility();
        int flags = 5638;
        systemUiVisibility = enterFullscreen ? (systemUiVisibility |= flags) : (systemUiVisibility &= ~flags);
        decor.setSystemUiVisibility(systemUiVisibility);
    }
}

