/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.AsyncTask;
import android.preference.PreferenceManager;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;
import org.chromium.base.VisibleForTesting;

@JNINamespace(value="content")
public class BackgroundSyncLauncher {
    static final String PREF_BACKGROUND_SYNC_LAUNCH_NEXT_ONLINE = "bgsync_launch_next_online";
    private static BackgroundSyncLauncher sInstance;

    @VisibleForTesting
    @CalledByNative
    protected static BackgroundSyncLauncher create(Context context) {
        if (sInstance != null) {
            throw new IllegalStateException("Already instantiated");
        }
        sInstance = new BackgroundSyncLauncher(context);
        return sInstance;
    }

    @VisibleForTesting
    @CalledByNative
    protected void destroy() {
        assert (sInstance == this);
        sInstance = null;
    }

    protected static void shouldLaunchWhenNextOnline(final Context context, final ShouldLaunchCallback callback) {
        new AsyncTask<Void, Void, Boolean>(){

            protected Boolean doInBackground(Void ... params) {
                SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)context);
                return prefs.getBoolean(BackgroundSyncLauncher.PREF_BACKGROUND_SYNC_LAUNCH_NEXT_ONLINE, false);
            }

            protected void onPostExecute(Boolean shouldLaunch) {
                callback.run(shouldLaunch);
            }
        }.execute((Object[])new Void[0]);
    }

    @VisibleForTesting
    @CalledByNative
    protected void setLaunchWhenNextOnline(final Context context, final boolean shouldLaunch) {
        new AsyncTask<Void, Void, Void>(){

            protected Void doInBackground(Void ... params) {
                SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)context);
                prefs.edit().putBoolean(BackgroundSyncLauncher.PREF_BACKGROUND_SYNC_LAUNCH_NEXT_ONLINE, shouldLaunch).apply();
                return null;
            }
        }.execute((Object[])new Void[0]);
    }

    protected static boolean hasInstance() {
        return sInstance != null;
    }

    private BackgroundSyncLauncher(Context context) {
        this.setLaunchWhenNextOnline(context, false);
    }

    public static interface ShouldLaunchCallback {
        public void run(Boolean var1);
    }
}

