/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.support.v4.content.WakefulBroadcastReceiver;
import org.chromium.base.Log;
import org.chromium.base.ThreadUtils;
import org.chromium.base.VisibleForTesting;
import org.chromium.base.annotations.SuppressFBWarnings;
import org.chromium.base.library_loader.ProcessInitException;
import org.chromium.content.app.ContentApplication;
import org.chromium.content.browser.BackgroundSyncLauncher;
import org.chromium.content.browser.BrowserStartupController;

public class BackgroundSyncLauncherService
extends IntentService {
    private static final String TAG = "cr.BgSyncLauncher";

    public BackgroundSyncLauncherService() {
        super("BackgroundSyncLauncherService");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onHandleIntent(Intent intent) {
        try {
            ThreadUtils.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    BackgroundSyncLauncherService.this.onOnline(BackgroundSyncLauncherService.this.getApplicationContext());
                }
            });
        }
        finally {
            WakefulBroadcastReceiver.completeWakefulIntent((Intent)intent);
        }
    }

    private void onOnline(final Context context) {
        ThreadUtils.assertOnUiThread();
        BackgroundSyncLauncher.ShouldLaunchCallback callback = new BackgroundSyncLauncher.ShouldLaunchCallback(){

            @Override
            public void run(Boolean shouldLaunch) {
                if (!shouldLaunch.booleanValue()) {
                    return;
                }
                Log.v(BackgroundSyncLauncherService.TAG, "Starting Browser after coming online");
                BackgroundSyncLauncherService.this.launchBrowser(context);
            }
        };
        BackgroundSyncLauncher.shouldLaunchWhenNextOnline(context, callback);
    }

    @SuppressFBWarnings(value={"DM_EXIT"})
    private void launchBrowser(Context context) {
        ContentApplication.initCommandLine(context);
        try {
            BrowserStartupController.get(context, 1).startBrowserProcessesSync(false);
        }
        catch (ProcessInitException e) {
            Log.e(TAG, "ProcessInitException while starting the browser process", new Object[0]);
            System.exit(-1);
        }
    }

    public static class Receiver
    extends WakefulBroadcastReceiver {
        public void onReceive(Context context, Intent intent) {
            if ("android.net.conn.CONNECTIVITY_CHANGE".equals(intent.getAction()) && this.isOnline(context) && !BackgroundSyncLauncher.hasInstance()) {
                this.startService(context);
            }
        }

        @VisibleForTesting
        protected void startService(Context context) {
            Intent serviceIntent = new Intent(context, BackgroundSyncLauncherService.class);
            Receiver.startWakefulService((Context)context, (Intent)serviceIntent);
        }

        @VisibleForTesting
        protected boolean isOnline(Context context) {
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            return networkInfo != null && networkInfo.isConnected();
        }
    }
}

