/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.graphics.SurfaceTexture;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Pair;
import android.view.Surface;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import org.chromium.base.CalledByNative;
import org.chromium.base.CommandLine;
import org.chromium.base.JNINamespace;
import org.chromium.base.Log;
import org.chromium.base.ThreadUtils;
import org.chromium.base.TraceEvent;
import org.chromium.base.VisibleForTesting;
import org.chromium.base.library_loader.Linker;
import org.chromium.content.app.ChildProcessService;
import org.chromium.content.app.ChromiumLinkerParams;
import org.chromium.content.app.PrivilegedProcessService;
import org.chromium.content.app.SandboxedProcessService;
import org.chromium.content.browser.BindingManager;
import org.chromium.content.browser.BindingManagerImpl;
import org.chromium.content.browser.ChildProcessConnection;
import org.chromium.content.browser.ChildProcessConnectionImpl;
import org.chromium.content.browser.FileDescriptorInfo;
import org.chromium.content.common.IChildProcessCallback;
import org.chromium.content.common.SurfaceWrapper;

@JNINamespace(value="content")
public class ChildProcessLauncher {
    private static final String TAG = "cr.ChildProcessLaunch";
    static final int CALLBACK_FOR_UNKNOWN_PROCESS = 0;
    static final int CALLBACK_FOR_GPU_PROCESS = 1;
    static final int CALLBACK_FOR_RENDERER_PROCESS = 2;
    static final int CALLBACK_FOR_UTILITY_PROCESS = 3;
    private static final String SWITCH_PROCESS_TYPE = "type";
    private static final String SWITCH_RENDERER_PROCESS = "renderer";
    private static final String SWITCH_UTILITY_PROCESS = "utility";
    private static final String SWITCH_GPU_PROCESS = "gpu-process";
    private static final PendingSpawnQueue sPendingSpawnQueue = new PendingSpawnQueue();
    private static ChildConnectionAllocator sSandboxedChildConnectionAllocator;
    private static ChildConnectionAllocator sPrivilegedChildConnectionAllocator;
    private static final String NUM_SANDBOXED_SERVICES_KEY = "org.chromium.content.browser.NUM_SANDBOXED_SERVICES";
    private static final String NUM_PRIVILEGED_SERVICES_KEY = "org.chromium.content.browser.NUM_PRIVILEGED_SERVICES";
    @VisibleForTesting
    public static final String SWITCH_NUM_SANDBOXED_SERVICES_FOR_TESTING = "num-sandboxed-services";
    private static boolean sLinkerInitialized;
    private static long sLinkerLoadAddress;
    private static final long FREE_CONNECTION_DELAY_MILLIS = 1L;
    private static final int NULL_PROCESS_HANDLE = 0;
    private static Map<Integer, ChildProcessConnection> sServiceMap;
    private static ChildProcessConnection sSpareSandboxedConnection;
    private static BindingManager sBindingManager;
    private static Map<Integer, Surface> sViewSurfaceMap;
    private static Map<Pair<Integer, Integer>, Surface> sSurfaceTextureSurfaceMap;
    private static boolean sApplicationInForeground;

    private static int getNumberOfServices(Context context, boolean inSandbox) {
        try {
            String value;
            PackageManager packageManager = context.getPackageManager();
            ApplicationInfo appInfo = packageManager.getApplicationInfo(context.getPackageName(), 128);
            int numServices = appInfo.metaData.getInt(inSandbox ? NUM_SANDBOXED_SERVICES_KEY : NUM_PRIVILEGED_SERVICES_KEY);
            if (inSandbox && CommandLine.getInstance().hasSwitch(SWITCH_NUM_SANDBOXED_SERVICES_FOR_TESTING) && !TextUtils.isEmpty((CharSequence)(value = CommandLine.getInstance().getSwitchValue(SWITCH_NUM_SANDBOXED_SERVICES_FOR_TESTING)))) {
                try {
                    numServices = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    Log.w(TAG, "The value of --num-sandboxed-services is formatted wrongly: " + value, new Object[0]);
                }
            }
            if (numServices <= 0) {
                throw new RuntimeException("Illegal meta data value for number of child services");
            }
            return numServices;
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException("Could not get application info");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initConnectionAllocatorsIfNecessary(Context context) {
        Class<ChildProcessLauncher> clazz = ChildProcessLauncher.class;
        synchronized (ChildProcessLauncher.class) {
            if (sSandboxedChildConnectionAllocator == null) {
                sSandboxedChildConnectionAllocator = new ChildConnectionAllocator(true, ChildProcessLauncher.getNumberOfServices(context, true));
            }
            if (sPrivilegedChildConnectionAllocator == null) {
                sPrivilegedChildConnectionAllocator = new ChildConnectionAllocator(false, ChildProcessLauncher.getNumberOfServices(context, false));
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static ChildConnectionAllocator getConnectionAllocator(boolean inSandbox) {
        return inSandbox ? sSandboxedChildConnectionAllocator : sPrivilegedChildConnectionAllocator;
    }

    private static ChildProcessConnection allocateConnection(Context context, boolean inSandbox, ChromiumLinkerParams chromiumLinkerParams, boolean alwaysInForeground) {
        ChildProcessConnection.DeathCallback deathCallback = new ChildProcessConnection.DeathCallback(){

            @Override
            public void onChildProcessDied(ChildProcessConnection connection) {
                if (connection.getPid() != 0) {
                    ChildProcessLauncher.stop(connection.getPid());
                } else {
                    ChildProcessLauncher.freeConnection(connection);
                }
            }
        };
        ChildProcessLauncher.initConnectionAllocatorsIfNecessary(context);
        return ChildProcessLauncher.getConnectionAllocator(inSandbox).allocate(context, deathCallback, chromiumLinkerParams, alwaysInForeground);
    }

    private static ChromiumLinkerParams getLinkerParamsForNewConnection() {
        Linker linker = Linker.getInstance();
        if (!sLinkerInitialized) {
            if (linker.isUsed() && (sLinkerLoadAddress = linker.getBaseLoadAddress()) == 0L) {
                Log.i(TAG, "Shared RELRO support disabled!", new Object[0]);
            }
            sLinkerInitialized = true;
        }
        if (sLinkerLoadAddress == 0L) {
            return null;
        }
        boolean waitForSharedRelros = true;
        return new ChromiumLinkerParams(sLinkerLoadAddress, true, linker.getTestRunnerClassName());
    }

    private static ChildProcessConnection allocateBoundConnection(Context context, String[] commandLine, boolean inSandbox, boolean alwaysInForeground) {
        ChromiumLinkerParams chromiumLinkerParams = ChildProcessLauncher.getLinkerParamsForNewConnection();
        ChildProcessConnection connection = ChildProcessLauncher.allocateConnection(context, inSandbox, chromiumLinkerParams, alwaysInForeground);
        if (connection != null) {
            connection.start(commandLine);
            if (inSandbox && !sSandboxedChildConnectionAllocator.isFreeConnectionAvailable()) {
                sBindingManager.releaseAllModerateBindings();
            }
        }
        return connection;
    }

    private static void freeConnection(ChildProcessConnection connection) {
        if (connection.equals(sSpareSandboxedConnection)) {
            sSpareSandboxedConnection = null;
        }
        final ChildProcessConnection conn = connection;
        ThreadUtils.postOnUiThreadDelayed(new Runnable(){

            @Override
            public void run() {
                ChildProcessLauncher.getConnectionAllocator(conn.isInSandbox()).free(conn);
                final PendingSpawnData pendingSpawn = sPendingSpawnQueue.dequeue();
                if (pendingSpawn != null) {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            ChildProcessLauncher.startInternal(pendingSpawn.context(), pendingSpawn.commandLine(), pendingSpawn.childProcessId(), pendingSpawn.filesToBeMapped(), pendingSpawn.clientContext(), pendingSpawn.callbackType(), pendingSpawn.inSandbox());
                        }
                    }).start();
                }
            }
        }, 1L);
    }

    @VisibleForTesting
    public static void setBindingManagerForTesting(BindingManager manager) {
        sBindingManager = manager;
    }

    @CalledByNative
    private static boolean isOomProtected(int pid) {
        return sBindingManager.isOomProtected(pid);
    }

    @CalledByNative
    private static void registerViewSurface(int surfaceId, Surface surface) {
        sViewSurfaceMap.put(surfaceId, surface);
    }

    @CalledByNative
    private static void unregisterViewSurface(int surfaceId) {
        sViewSurfaceMap.remove(surfaceId);
    }

    private static void registerSurfaceTextureSurface(int surfaceTextureId, int clientId, Surface surface) {
        Pair key = new Pair((Object)surfaceTextureId, (Object)clientId);
        sSurfaceTextureSurfaceMap.put((Pair<Integer, Integer>)key, surface);
    }

    private static void unregisterSurfaceTextureSurface(int surfaceTextureId, int clientId) {
        Pair key = new Pair((Object)surfaceTextureId, (Object)clientId);
        Surface surface = sSurfaceTextureSurfaceMap.remove(key);
        if (surface == null) {
            return;
        }
        assert (surface.isValid());
        surface.release();
    }

    @CalledByNative
    private static void createSurfaceTextureSurface(int surfaceTextureId, int clientId, SurfaceTexture surfaceTexture) {
        ChildProcessLauncher.registerSurfaceTextureSurface(surfaceTextureId, clientId, new Surface(surfaceTexture));
    }

    @CalledByNative
    private static void destroySurfaceTextureSurface(int surfaceTextureId, int clientId) {
        ChildProcessLauncher.unregisterSurfaceTextureSurface(surfaceTextureId, clientId);
    }

    @CalledByNative
    private static SurfaceWrapper getSurfaceTextureSurface(int surfaceTextureId, int clientId) {
        Pair key = new Pair((Object)surfaceTextureId, (Object)clientId);
        Surface surface = sSurfaceTextureSurfaceMap.get(key);
        if (surface == null) {
            Log.e(TAG, "Invalid Id for surface texture.", new Object[0]);
            return null;
        }
        assert (surface.isValid());
        return new SurfaceWrapper(surface);
    }

    @CalledByNative
    public static void setInForeground(int pid, boolean inForeground) {
        sBindingManager.setInForeground(pid, inForeground);
    }

    public static void determinedVisibility(int pid) {
        sBindingManager.determinedVisibility(pid);
    }

    public static void onSentToBackground() {
        sApplicationInForeground = false;
        sBindingManager.onSentToBackground();
    }

    public static void startModerateBindingManagement(Context context, float lowReduceRatio, float highReduceRatio) {
        sBindingManager.startModerateBindingManagement(context, ChildProcessLauncher.getNumberOfServices(context, true), lowReduceRatio, highReduceRatio);
    }

    public static void onBroughtToForeground() {
        sApplicationInForeground = true;
        sBindingManager.onBroughtToForeground();
    }

    static boolean isApplicationInForeground() {
        return sApplicationInForeground;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void warmUp(Context context) {
        Class<ChildProcessLauncher> clazz = ChildProcessLauncher.class;
        synchronized (ChildProcessLauncher.class) {
            assert (!ThreadUtils.runningOnUiThread());
            if (sSpareSandboxedConnection == null) {
                sSpareSandboxedConnection = ChildProcessLauncher.allocateBoundConnection(context, null, true, false);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static String getSwitchValue(String[] commandLine, String switchKey) {
        if (commandLine == null || switchKey == null) {
            return null;
        }
        String switchKeyPrefix = "--" + switchKey + "=";
        for (String command : commandLine) {
            if (command == null || !command.startsWith(switchKeyPrefix)) continue;
            return command.substring(switchKeyPrefix.length());
        }
        return null;
    }

    @CalledByNative
    private static FileDescriptorInfo makeFdInfo(int id2, int fd, boolean autoClose, long offset, long size) {
        ParcelFileDescriptor pFd;
        if (autoClose) {
            pFd = ParcelFileDescriptor.adoptFd((int)fd);
        } else {
            try {
                pFd = ParcelFileDescriptor.fromFd((int)fd);
            }
            catch (IOException e) {
                Log.e(TAG, "Invalid FD provided for process connection, aborting connection.", e);
                return null;
            }
        }
        return new FileDescriptorInfo(id2, pFd, offset, size);
    }

    @CalledByNative
    private static void start(Context context, String[] commandLine, int childProcessId, FileDescriptorInfo[] filesToBeMapped, long clientContext) {
        assert (clientContext != 0L);
        int callbackType = 0;
        boolean inSandbox = true;
        String processType = ChildProcessLauncher.getSwitchValue(commandLine, SWITCH_PROCESS_TYPE);
        if (SWITCH_RENDERER_PROCESS.equals(processType)) {
            callbackType = 2;
        } else if (SWITCH_GPU_PROCESS.equals(processType)) {
            callbackType = 1;
            inSandbox = false;
        } else if (SWITCH_UTILITY_PROCESS.equals(processType)) {
            callbackType = 3;
        } else assert (false);
        ChildProcessLauncher.startInternal(context, commandLine, childProcessId, filesToBeMapped, clientContext, callbackType, inSandbox);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startInternal(Context context, String[] commandLine, int childProcessId, FileDescriptorInfo[] filesToBeMapped, long clientContext, int callbackType, boolean inSandbox) {
        try {
            TraceEvent.begin("ChildProcessLauncher.startInternal");
            ChildProcessConnection allocatedConnection = null;
            Class<ChildProcessLauncher> clazz = ChildProcessLauncher.class;
            synchronized (ChildProcessLauncher.class) {
                if (inSandbox) {
                    allocatedConnection = sSpareSandboxedConnection;
                    sSpareSandboxedConnection = null;
                }
                // ** MonitorExit[var9_8] (shouldn't be in output)
                if (allocatedConnection == null) {
                    boolean alwaysInForeground = false;
                    if (callbackType == 1) {
                        alwaysInForeground = true;
                    }
                    if ((allocatedConnection = ChildProcessLauncher.allocateBoundConnection(context, commandLine, inSandbox, alwaysInForeground)) == null) {
                        Log.d(TAG, "Allocation of new service failed. Queuing up pending spawn.");
                        sPendingSpawnQueue.enqueue(new PendingSpawnData(context, commandLine, childProcessId, filesToBeMapped, clientContext, callbackType, inSandbox));
                        return;
                    }
                }
                Log.d(TAG, "Setting up connection to process: slot=%d", allocatedConnection.getServiceNumber());
                ChildProcessLauncher.triggerConnectionSetup(allocatedConnection, commandLine, childProcessId, filesToBeMapped, callbackType, clientContext);
            }
        }
        finally {
            TraceEvent.end("ChildProcessLauncher.startInternal");
        }
        {
            return;
        }
    }

    @VisibleForTesting
    static void triggerConnectionSetup(final ChildProcessConnection connection, String[] commandLine, int childProcessId, FileDescriptorInfo[] filesToBeMapped, final int callbackType, final long clientContext) {
        ChildProcessConnection.ConnectionCallback connectionCallback = new ChildProcessConnection.ConnectionCallback(){

            @Override
            public void onConnected(int pid) {
                Log.d(ChildProcessLauncher.TAG, "on connect callback, pid=%d context=%d callbackType=%d", pid, clientContext, callbackType);
                if (pid != 0) {
                    sBindingManager.addNewConnection(pid, connection);
                    sServiceMap.put(pid, connection);
                }
                if (clientContext != 0L) {
                    ChildProcessLauncher.nativeOnChildProcessStarted(clientContext, pid);
                }
            }
        };
        assert (callbackType != 0);
        connection.setupConnection(commandLine, filesToBeMapped, ChildProcessLauncher.createCallback(childProcessId, callbackType), connectionCallback, Linker.getInstance().getSharedRelros());
    }

    @CalledByNative
    static void stop(int pid) {
        Log.d(TAG, "stopping child connection: pid=%d", pid);
        ChildProcessConnection connection = sServiceMap.remove(pid);
        if (connection == null) {
            ChildProcessLauncher.logPidWarning(pid, "Tried to stop non-existent connection");
            return;
        }
        sBindingManager.clearConnection(pid);
        connection.stop();
        ChildProcessLauncher.freeConnection(connection);
    }

    private static IChildProcessCallback createCallback(final int childProcessId, final int callbackType) {
        return new IChildProcessCallback.Stub(){

            @Override
            public void establishSurfacePeer(int pid, Surface surface, int primaryID, int secondaryID) {
                if (callbackType != 1) {
                    Log.e(ChildProcessLauncher.TAG, "Illegal callback for non-GPU process.", new Object[0]);
                    return;
                }
                ChildProcessLauncher.nativeEstablishSurfacePeer(pid, surface, primaryID, secondaryID);
            }

            @Override
            public SurfaceWrapper getViewSurface(int surfaceId) {
                if (callbackType != 1) {
                    Log.e(ChildProcessLauncher.TAG, "Illegal callback for non-GPU process.", new Object[0]);
                    return null;
                }
                Surface surface = (Surface)sViewSurfaceMap.get(surfaceId);
                if (surface == null) {
                    Log.e(ChildProcessLauncher.TAG, "Invalid surfaceId.", new Object[0]);
                    return null;
                }
                assert (surface.isValid());
                return new SurfaceWrapper(surface);
            }

            @Override
            public void registerSurfaceTextureSurface(int surfaceTextureId, int clientId, Surface surface) {
                if (callbackType != 1) {
                    Log.e(ChildProcessLauncher.TAG, "Illegal callback for non-GPU process.", new Object[0]);
                    return;
                }
                ChildProcessLauncher.registerSurfaceTextureSurface(surfaceTextureId, clientId, surface);
            }

            @Override
            public void unregisterSurfaceTextureSurface(int surfaceTextureId, int clientId) {
                if (callbackType != 1) {
                    Log.e(ChildProcessLauncher.TAG, "Illegal callback for non-GPU process.", new Object[0]);
                    return;
                }
                ChildProcessLauncher.unregisterSurfaceTextureSurface(surfaceTextureId, clientId);
            }

            @Override
            public SurfaceWrapper getSurfaceTextureSurface(int surfaceTextureId) {
                if (callbackType != 2) {
                    Log.e(ChildProcessLauncher.TAG, "Illegal callback for non-renderer process.", new Object[0]);
                    return null;
                }
                return ChildProcessLauncher.getSurfaceTextureSurface(surfaceTextureId, childProcessId);
            }
        };
    }

    static void logPidWarning(int pid, String message) {
        if (pid > 0 && !ChildProcessLauncher.nativeIsSingleProcess()) {
            Log.w(TAG, "%s, pid=%d", message, pid);
        }
    }

    @VisibleForTesting
    static ChildProcessConnection allocateBoundConnectionForTesting(Context context) {
        return ChildProcessLauncher.allocateBoundConnection(context, null, true, false);
    }

    @VisibleForTesting
    static void enqueuePendingSpawnForTesting(Context context) {
        sPendingSpawnQueue.enqueue(new PendingSpawnData(context, new String[0], 1, new FileDescriptorInfo[0], 0L, 2, true));
    }

    @VisibleForTesting
    static int allocatedConnectionsCountForTesting(Context context) {
        ChildProcessLauncher.initConnectionAllocatorsIfNecessary(context);
        return sSandboxedChildConnectionAllocator.allocatedConnectionsCountForTesting();
    }

    @VisibleForTesting
    static int connectedServicesCountForTesting() {
        return sServiceMap.size();
    }

    @VisibleForTesting
    static int pendingSpawnsCountForTesting() {
        return sPendingSpawnQueue.size();
    }

    @VisibleForTesting
    public static boolean crashProcessForTesting(int pid) {
        if (sServiceMap.get(pid) == null) {
            return false;
        }
        try {
            ((ChildProcessConnectionImpl)sServiceMap.get(pid)).crashServiceForTesting();
        }
        catch (RemoteException ex) {
            return false;
        }
        return true;
    }

    private static native void nativeOnChildProcessStarted(long var0, int var2);

    private static native void nativeEstablishSurfacePeer(int var0, Surface var1, int var2, int var3);

    private static native boolean nativeIsSingleProcess();

    static {
        sLinkerInitialized = false;
        sLinkerLoadAddress = 0L;
        sServiceMap = new ConcurrentHashMap<Integer, ChildProcessConnection>();
        sSpareSandboxedConnection = null;
        sBindingManager = BindingManagerImpl.createBindingManager();
        sViewSurfaceMap = new ConcurrentHashMap<Integer, Surface>();
        sSurfaceTextureSurfaceMap = new ConcurrentHashMap<Pair<Integer, Integer>, Surface>();
        sApplicationInForeground = true;
    }

    private static class PendingSpawnQueue {
        private static Queue<PendingSpawnData> sPendingSpawns = new LinkedList<PendingSpawnData>();
        static final Object sPendingSpawnsLock = new Object();

        private PendingSpawnQueue() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void enqueue(PendingSpawnData pendingSpawn) {
            Object object = sPendingSpawnsLock;
            synchronized (object) {
                sPendingSpawns.add(pendingSpawn);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PendingSpawnData dequeue() {
            Object object = sPendingSpawnsLock;
            synchronized (object) {
                return sPendingSpawns.poll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size() {
            Object object = sPendingSpawnsLock;
            synchronized (object) {
                return sPendingSpawns.size();
            }
        }
    }

    private static class PendingSpawnData {
        private final Context mContext;
        private final String[] mCommandLine;
        private final int mChildProcessId;
        private final FileDescriptorInfo[] mFilesToBeMapped;
        private final long mClientContext;
        private final int mCallbackType;
        private final boolean mInSandbox;

        private PendingSpawnData(Context context, String[] commandLine, int childProcessId, FileDescriptorInfo[] filesToBeMapped, long clientContext, int callbackType, boolean inSandbox) {
            this.mContext = context;
            this.mCommandLine = commandLine;
            this.mChildProcessId = childProcessId;
            this.mFilesToBeMapped = filesToBeMapped;
            this.mClientContext = clientContext;
            this.mCallbackType = callbackType;
            this.mInSandbox = inSandbox;
        }

        private Context context() {
            return this.mContext;
        }

        private String[] commandLine() {
            return this.mCommandLine;
        }

        private int childProcessId() {
            return this.mChildProcessId;
        }

        private FileDescriptorInfo[] filesToBeMapped() {
            return this.mFilesToBeMapped;
        }

        private long clientContext() {
            return this.mClientContext;
        }

        private int callbackType() {
            return this.mCallbackType;
        }

        private boolean inSandbox() {
            return this.mInSandbox;
        }
    }

    private static class ChildConnectionAllocator {
        private final ChildProcessConnection[] mChildProcessConnections;
        private final ArrayList<Integer> mFreeConnectionIndices;
        private final Object mConnectionLock = new Object();
        private Class<? extends ChildProcessService> mChildClass;
        private final boolean mInSandbox;

        public ChildConnectionAllocator(boolean inSandbox, int numChildServices) {
            this.mChildProcessConnections = new ChildProcessConnectionImpl[numChildServices];
            this.mFreeConnectionIndices = new ArrayList(numChildServices);
            for (int i = 0; i < numChildServices; ++i) {
                this.mFreeConnectionIndices.add(i);
            }
            this.mChildClass = inSandbox ? SandboxedProcessService.class : PrivilegedProcessService.class;
            this.mInSandbox = inSandbox;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ChildProcessConnection allocate(Context context, ChildProcessConnection.DeathCallback deathCallback, ChromiumLinkerParams chromiumLinkerParams, boolean alwaysInForeground) {
            Object object = this.mConnectionLock;
            synchronized (object) {
                if (this.mFreeConnectionIndices.isEmpty()) {
                    Log.d(ChildProcessLauncher.TAG, "Ran out of services to allocate.");
                    return null;
                }
                int slot = this.mFreeConnectionIndices.remove(0);
                assert (this.mChildProcessConnections[slot] == null);
                this.mChildProcessConnections[slot] = new ChildProcessConnectionImpl(context, slot, this.mInSandbox, deathCallback, this.mChildClass, chromiumLinkerParams, alwaysInForeground);
                Log.d(ChildProcessLauncher.TAG, "Allocator allocated a connection, sandbox: %b, slot: %d", this.mInSandbox, slot);
                return this.mChildProcessConnections[slot];
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void free(ChildProcessConnection connection) {
            Object object = this.mConnectionLock;
            synchronized (object) {
                int slot = connection.getServiceNumber();
                if (this.mChildProcessConnections[slot] != connection) {
                    int occupier = this.mChildProcessConnections[slot] == null ? -1 : this.mChildProcessConnections[slot].getServiceNumber();
                    Log.e(ChildProcessLauncher.TAG, "Unable to find connection to free in slot: %d already occupied by service: %d", slot, occupier);
                    assert (false);
                } else {
                    this.mChildProcessConnections[slot] = null;
                    assert (!this.mFreeConnectionIndices.contains(slot));
                    this.mFreeConnectionIndices.add(slot);
                    Log.d(ChildProcessLauncher.TAG, "Allocator freed a connection, sandbox: %b, slot: %d", this.mInSandbox, slot);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isFreeConnectionAvailable() {
            Object object = this.mConnectionLock;
            synchronized (object) {
                return !this.mFreeConnectionIndices.isEmpty();
            }
        }

        @VisibleForTesting
        int allocatedConnectionsCountForTesting() {
            return this.mChildProcessConnections.length - this.mFreeConnectionIndices.size();
        }
    }
}

