/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import android.graphics.Bitmap;
import android.graphics.Rect;
import android.util.SparseArray;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;
import org.chromium.base.ThreadUtils;
import org.chromium.content.browser.ContentViewCore;
import org.chromium.ui.base.WindowAndroid;

@JNINamespace(value="content")
public abstract class ContentReadbackHandler {
    private int mNextReadbackId = 1;
    private SparseArray<GetBitmapCallback> mGetBitmapRequests = new SparseArray();
    private long mNativeContentReadbackHandler;

    public void initNativeContentReadbackHandler() {
        this.mNativeContentReadbackHandler = this.nativeInit();
    }

    public void destroy() {
        if (this.mNativeContentReadbackHandler != 0L) {
            this.nativeDestroy(this.mNativeContentReadbackHandler);
        }
        this.mNativeContentReadbackHandler = 0L;
    }

    @CalledByNative
    private void notifyGetBitmapFinished(int readbackId, Bitmap bitmap, int response) {
        GetBitmapCallback callback = (GetBitmapCallback)this.mGetBitmapRequests.get(readbackId);
        if (callback != null) {
            this.mGetBitmapRequests.delete(readbackId);
            callback.onFinishGetBitmap(bitmap, response);
        } else assert (false) : "Readback finished for unregistered Id: " + readbackId;
    }

    public void getContentBitmapAsync(float scale, Rect srcRect, ContentViewCore view, Bitmap.Config config, GetBitmapCallback callback) {
        if (!this.readyForReadback()) {
            callback.onFinishGetBitmap(null, 2);
            return;
        }
        ThreadUtils.assertOnUiThread();
        int readbackId = this.mNextReadbackId++;
        this.mGetBitmapRequests.put(readbackId, (Object)callback);
        this.nativeGetContentBitmap(this.mNativeContentReadbackHandler, readbackId, scale, config, srcRect.top, srcRect.left, srcRect.width(), srcRect.height(), view);
    }

    public void getCompositorBitmapAsync(WindowAndroid windowAndroid, final GetBitmapCallback callback) {
        if (!this.readyForReadback()) {
            ThreadUtils.postOnUiThread(new Runnable(){

                @Override
                public void run() {
                    callback.onFinishGetBitmap(null, 2);
                }
            });
            return;
        }
        ThreadUtils.assertOnUiThread();
        int readbackId = this.mNextReadbackId++;
        this.mGetBitmapRequests.put(readbackId, (Object)callback);
        this.nativeGetCompositorBitmap(this.mNativeContentReadbackHandler, readbackId, windowAndroid.getNativePointer());
    }

    protected abstract boolean readyForReadback();

    private native long nativeInit();

    private native void nativeDestroy(long var1);

    private native void nativeGetContentBitmap(long var1, int var3, float var4, Bitmap.Config var5, float var6, float var7, float var8, float var9, Object var10);

    private native void nativeGetCompositorBitmap(long var1, int var3, long var4);

    public static interface GetBitmapCallback {
        public void onFinishGetBitmap(Bitmap var1, int var2);
    }
}

