/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import android.app.AlertDialog;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Point;
import android.provider.Settings;
import android.view.Display;
import android.view.KeyEvent;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;
import org.chromium.base.Log;
import org.chromium.base.ThreadUtils;
import org.chromium.content.R;
import org.chromium.content.browser.ContentVideoViewClient;
import org.chromium.content.browser.ContentViewCore;

@JNINamespace(value="content")
public class ContentVideoView
extends FrameLayout
implements SurfaceHolder.Callback {
    private static final String TAG = "cr.ContentVideoView";
    private static final int MEDIA_NOP = 0;
    private static final int MEDIA_PREPARED = 1;
    private static final int MEDIA_PLAYBACK_COMPLETE = 2;
    private static final int MEDIA_BUFFERING_UPDATE = 3;
    private static final int MEDIA_SEEK_COMPLETE = 4;
    private static final int MEDIA_SET_VIDEO_SIZE = 5;
    private static final int MEDIA_ERROR = 100;
    private static final int MEDIA_INFO = 200;
    public static final int MEDIA_ERROR_NOT_VALID_FOR_PROGRESSIVE_PLAYBACK = 2;
    public static final int MEDIA_ERROR_INVALID_CODE = 3;
    private static final int STATE_ERROR = -1;
    private static final int STATE_IDLE = 0;
    private static final int STATE_PLAYING = 1;
    private static final int STATE_PAUSED = 2;
    private static final int STATE_PLAYBACK_COMPLETED = 3;
    private SurfaceHolder mSurfaceHolder;
    private int mVideoWidth;
    private int mVideoHeight;
    private long mNativeContentVideoView;
    private int mCurrentState = 0;
    private String mPlaybackErrorText;
    private String mUnknownErrorText;
    private String mErrorButton;
    private String mErrorTitle;
    private String mVideoLoadingText;
    private VideoSurfaceView mVideoSurfaceView;
    private View mProgressView;
    private final ContentVideoViewClient mClient;
    private final ContentViewCore mContentViewCore;
    private boolean mInitialOrientation;
    private boolean mPossibleAccidentalChange;
    private boolean mUmaRecorded;
    private long mOrientationChangedTime;
    private long mPlaybackStartTime;
    private final Runnable mExitFullscreenRunnable = new Runnable(){

        @Override
        public void run() {
            ContentVideoView.this.exitFullscreen(true);
        }
    };

    private ContentVideoView(Context context, ContentViewCore contentViewCore, long nativeContentVideoView) {
        super(context);
        this.mNativeContentVideoView = nativeContentVideoView;
        this.mContentViewCore = contentViewCore;
        this.mClient = this.mContentViewCore.getContentVideoViewClient();
        this.mUmaRecorded = false;
        this.mPossibleAccidentalChange = false;
        this.initResources(context);
        this.mVideoSurfaceView = new VideoSurfaceView(context);
        this.showContentVideoView();
        this.setVisibility(0);
    }

    private ContentVideoViewClient getContentVideoViewClient() {
        return this.mClient;
    }

    private void initResources(Context context) {
        if (this.mPlaybackErrorText != null) {
            return;
        }
        this.mPlaybackErrorText = context.getString(R.string.media_player_error_text_invalid_progressive_playback);
        this.mUnknownErrorText = context.getString(R.string.media_player_error_text_unknown);
        this.mErrorButton = context.getString(R.string.media_player_error_button);
        this.mErrorTitle = context.getString(R.string.media_player_error_title);
        this.mVideoLoadingText = context.getString(R.string.media_player_loading_video);
    }

    private void showContentVideoView() {
        this.mVideoSurfaceView.getHolder().addCallback((SurfaceHolder.Callback)this);
        this.addView((View)this.mVideoSurfaceView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2, 17));
        this.mProgressView = this.mClient.getVideoLoadingProgressView();
        if (this.mProgressView == null) {
            this.mProgressView = new ProgressView(this.getContext(), this.mVideoLoadingText);
        }
        this.addView(this.mProgressView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2, 17));
    }

    private SurfaceView getSurfaceView() {
        return this.mVideoSurfaceView;
    }

    @CalledByNative
    public void onMediaPlayerError(int errorType) {
        Log.d(TAG, "OnMediaPlayerError: %d", errorType);
        if (this.mCurrentState == -1 || this.mCurrentState == 3) {
            return;
        }
        if (errorType == 3) {
            return;
        }
        this.mCurrentState = -1;
        if (ContentViewCore.activityFromContext(this.getContext()) == null) {
            Log.w(TAG, "Unable to show alert dialog because it requires an activity context", new Object[0]);
            return;
        }
        if (this.getWindowToken() != null) {
            String message = errorType == 2 ? this.mPlaybackErrorText : this.mUnknownErrorText;
            try {
                new AlertDialog.Builder(this.getContext()).setTitle((CharSequence)this.mErrorTitle).setMessage((CharSequence)message).setPositiveButton((CharSequence)this.mErrorButton, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int whichButton) {
                        ContentVideoView.this.onCompletion();
                    }
                }).setCancelable(false).show();
            }
            catch (RuntimeException e) {
                Log.e(TAG, "Cannot show the alert dialog, error message: %s", message, e);
            }
        }
    }

    @CalledByNative
    private void onVideoSizeChanged(int width, int height) {
        this.mVideoWidth = width;
        this.mVideoHeight = height;
        this.mVideoSurfaceView.getHolder().setFixedSize(this.mVideoWidth, this.mVideoHeight);
    }

    @CalledByNative
    private void onBufferingUpdate(int percent) {
    }

    @CalledByNative
    private void onPlaybackComplete() {
        this.onCompletion();
    }

    @CalledByNative
    private void onUpdateMediaMetadata(int videoWidth, int videoHeight, int duration, boolean canPause, boolean canSeekBack, boolean canSeekForward) {
        this.mProgressView.setVisibility(8);
        this.mCurrentState = this.isPlaying() ? 1 : 2;
        this.onVideoSizeChanged(videoWidth, videoHeight);
        if (this.mUmaRecorded) {
            return;
        }
        try {
            if (Settings.System.getInt((ContentResolver)this.getContext().getContentResolver(), (String)"accelerometer_rotation") == 0) {
                return;
            }
        }
        catch (Settings.SettingNotFoundException e) {
            return;
        }
        this.mInitialOrientation = this.isOrientationPortrait();
        this.mUmaRecorded = true;
        this.mOrientationChangedTime = this.mPlaybackStartTime = System.currentTimeMillis();
        this.nativeRecordFullscreenPlayback(this.mNativeContentVideoView, videoHeight > videoWidth, this.mInitialOrientation);
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
    }

    public void surfaceCreated(SurfaceHolder holder) {
        this.mSurfaceHolder = holder;
        this.openVideo();
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        if (this.mNativeContentVideoView != 0L) {
            this.nativeSetSurface(this.mNativeContentVideoView, null);
        }
        this.mSurfaceHolder = null;
        this.post(this.mExitFullscreenRunnable);
    }

    @CalledByNative
    private void openVideo() {
        if (this.mSurfaceHolder != null) {
            this.mCurrentState = 0;
            if (this.mNativeContentVideoView != 0L) {
                this.nativeRequestMediaMetadata(this.mNativeContentVideoView);
                this.nativeSetSurface(this.mNativeContentVideoView, this.mSurfaceHolder.getSurface());
            }
        }
    }

    private void onCompletion() {
        this.mCurrentState = 3;
    }

    public boolean isPlaying() {
        return this.mNativeContentVideoView != 0L && this.nativeIsPlaying(this.mNativeContentVideoView);
    }

    @CalledByNative
    private static ContentVideoView createContentVideoView(ContentViewCore contentViewCore, long nativeContentVideoView) {
        ThreadUtils.assertOnUiThread();
        Context context = contentViewCore.getContext();
        ContentVideoViewClient client = contentViewCore.getContentVideoViewClient();
        ContentVideoView videoView = new ContentVideoView(context, contentViewCore, nativeContentVideoView);
        client.enterFullscreenVideo((View)videoView);
        contentViewCore.updateDoubleTapSupport(false);
        contentViewCore.updateMultiTouchZoomSupport(false);
        return videoView;
    }

    public void removeSurfaceView() {
        this.removeView((View)this.mVideoSurfaceView);
        this.removeView(this.mProgressView);
        this.mVideoSurfaceView = null;
        this.mProgressView = null;
    }

    public void exitFullscreen(boolean relaseMediaPlayer) {
        if (this.mNativeContentVideoView != 0L) {
            this.destroyContentVideoView(false);
            if (this.mUmaRecorded && !this.mPossibleAccidentalChange) {
                long currentTime = System.currentTimeMillis();
                long timeBeforeOrientationChange = this.mOrientationChangedTime - this.mPlaybackStartTime;
                long timeAfterOrientationChange = currentTime - this.mOrientationChangedTime;
                if (timeBeforeOrientationChange == 0L) {
                    timeBeforeOrientationChange = timeAfterOrientationChange;
                    timeAfterOrientationChange = 0L;
                }
                this.nativeRecordExitFullscreenPlayback(this.mNativeContentVideoView, this.mInitialOrientation, timeBeforeOrientationChange, timeAfterOrientationChange);
            }
            this.nativeExitFullscreen(this.mNativeContentVideoView, relaseMediaPlayer);
            this.mNativeContentVideoView = 0L;
            this.mContentViewCore.updateDoubleTapSupport(true);
            this.mContentViewCore.updateMultiTouchZoomSupport(true);
        }
    }

    public void onFullscreenWindowFocused() {
        this.mClient.setSystemUiVisibility(true);
    }

    @CalledByNative
    private void onExitFullscreen() {
        this.exitFullscreen(false);
    }

    @CalledByNative
    private void destroyContentVideoView(boolean nativeViewDestroyed) {
        if (this.mVideoSurfaceView != null) {
            this.removeSurfaceView();
            this.setVisibility(8);
            this.mClient.exitFullscreenVideo();
        }
        if (nativeViewDestroyed) {
            this.mNativeContentVideoView = 0L;
        }
    }

    public static ContentVideoView getContentVideoView() {
        return ContentVideoView.nativeGetSingletonJavaContentVideoView();
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (keyCode == 4) {
            this.exitFullscreen(false);
            return true;
        }
        return super.onKeyUp(keyCode, event);
    }

    private boolean isOrientationPortrait() {
        Context context = this.getContext();
        WindowManager manager = (WindowManager)context.getSystemService("window");
        Display display = manager.getDefaultDisplay();
        Point outputSize = new Point(0, 0);
        display.getSize(outputSize);
        return outputSize.x <= outputSize.y;
    }

    private static native ContentVideoView nativeGetSingletonJavaContentVideoView();

    private native void nativeExitFullscreen(long var1, boolean var3);

    private native void nativeRequestMediaMetadata(long var1);

    private native boolean nativeIsPlaying(long var1);

    private native void nativeSetSurface(long var1, Surface var3);

    private native void nativeRecordFullscreenPlayback(long var1, boolean var3, boolean var4);

    private native void nativeRecordExitFullscreenPlayback(long var1, boolean var3, long var4, long var6);

    private static class ProgressView
    extends LinearLayout {
        private final ProgressBar mProgressBar;
        private final TextView mTextView;

        public ProgressView(Context context, String videoLoadingText) {
            super(context);
            this.setOrientation(1);
            this.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
            this.mProgressBar = new ProgressBar(context, null, 16842874);
            this.mTextView = new TextView(context);
            this.mTextView.setText((CharSequence)videoLoadingText);
            this.addView((View)this.mProgressBar);
            this.addView((View)this.mTextView);
        }
    }

    private class VideoSurfaceView
    extends SurfaceView {
        public VideoSurfaceView(Context context) {
            super(context);
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            int width = 1;
            int height = 1;
            if (ContentVideoView.this.mVideoWidth > 0 && ContentVideoView.this.mVideoHeight > 0) {
                width = VideoSurfaceView.getDefaultSize((int)ContentVideoView.this.mVideoWidth, (int)widthMeasureSpec);
                height = VideoSurfaceView.getDefaultSize((int)ContentVideoView.this.mVideoHeight, (int)heightMeasureSpec);
                if (ContentVideoView.this.mVideoWidth * height > width * ContentVideoView.this.mVideoHeight) {
                    height = width * ContentVideoView.this.mVideoHeight / ContentVideoView.this.mVideoWidth;
                } else if (ContentVideoView.this.mVideoWidth * height < width * ContentVideoView.this.mVideoHeight) {
                    width = height * ContentVideoView.this.mVideoWidth / ContentVideoView.this.mVideoHeight;
                }
            }
            if (ContentVideoView.this.mUmaRecorded) {
                if (ContentVideoView.this.mPlaybackStartTime == ContentVideoView.this.mOrientationChangedTime) {
                    if (ContentVideoView.this.isOrientationPortrait() != ContentVideoView.this.mInitialOrientation) {
                        ContentVideoView.this.mOrientationChangedTime = System.currentTimeMillis();
                    }
                } else if (!ContentVideoView.this.mPossibleAccidentalChange && ContentVideoView.this.isOrientationPortrait() == ContentVideoView.this.mInitialOrientation && System.currentTimeMillis() - ContentVideoView.this.mOrientationChangedTime < 5000L) {
                    ContentVideoView.this.mPossibleAccidentalChange = true;
                }
            }
            this.setMeasuredDimension(width, height);
        }
    }
}

