/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.view.ActionMode;
import android.view.KeyEvent;
import android.view.View;
import org.chromium.base.Log;
import org.chromium.content.browser.ContentVideoViewClient;
import org.chromium.content.browser.SelectActionMode;
import org.chromium.content.browser.SelectActionModeCallback;

public class ContentViewClient {
    private static final String TAG = "cr.ContentViewClient";

    public void onUpdateTitle(String title) {
    }

    public void onBackgroundColorChanged(int color2) {
    }

    public void onOffsetsForFullscreenChanged(float topControlsOffsetYPix, float contentOffsetYPix, float overdrawBottomHeightPix) {
    }

    public boolean shouldOverrideKeyEvent(KeyEvent event) {
        int keyCode = event.getKeyCode();
        if (!ContentViewClient.shouldPropagateKey(keyCode)) {
            return true;
        }
        return event.isCtrlPressed() && (keyCode == 61 || keyCode == 51 || keyCode == 134);
    }

    public void onImeEvent() {
    }

    public void onFocusedNodeEditabilityChanged(boolean editable) {
    }

    public SelectActionMode startActionMode(View view, SelectActionModeCallback.ActionHandler actionHandler, boolean floating) {
        if (floating) {
            return null;
        }
        SelectActionModeCallback callback = new SelectActionModeCallback(view.getContext(), actionHandler);
        ActionMode actionMode = view.startActionMode((ActionMode.Callback)callback);
        return actionMode != null ? new SelectActionMode(actionMode) : null;
    }

    public boolean supportsFloatingActionMode() {
        return false;
    }

    public void onContextualActionBarShown() {
    }

    public void onContextualActionBarHidden() {
    }

    public void performWebSearch(String searchQuery) {
    }

    public boolean doesPerformWebSearch() {
        return false;
    }

    public void onStartContentIntent(Context context, String intentUrl) {
        Intent intent;
        try {
            intent = Intent.parseUri((String)intentUrl, (int)1);
        }
        catch (Exception ex) {
            Log.w(TAG, "Bad URI %s", intentUrl, ex);
            return;
        }
        try {
            context.startActivity(intent);
        }
        catch (ActivityNotFoundException ex) {
            Log.w(TAG, "No application can handle %s", intentUrl);
        }
    }

    public ContentVideoViewClient getContentVideoViewClient() {
        return null;
    }

    public boolean shouldBlockMediaRequest(String url) {
        return false;
    }

    public boolean isJavascriptEnabled() {
        return true;
    }

    public boolean isExternalScrollActive() {
        return false;
    }

    public static boolean shouldPropagateKey(int keyCode) {
        return keyCode != 82 && keyCode != 3 && keyCode != 4 && keyCode != 5 && keyCode != 6 && keyCode != 26 && keyCode != 79 && keyCode != 27 && keyCode != 80 && keyCode != 25 && keyCode != 164 && keyCode != 24;
    }
}

