/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.ClipboardManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.res.Configuration;
import android.database.ContentObserver;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.ResultReceiver;
import android.os.SystemClock;
import android.provider.Settings;
import android.text.Editable;
import android.text.Selection;
import android.text.Spannable;
import android.text.TextUtils;
import android.util.Pair;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStructure;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityNodeProvider;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.widget.AbsoluteLayout;
import android.widget.FrameLayout;
import java.lang.annotation.Annotation;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.chromium.base.ApiCompatibilityUtils;
import org.chromium.base.CalledByNative;
import org.chromium.base.CommandLine;
import org.chromium.base.JNINamespace;
import org.chromium.base.Log;
import org.chromium.base.ObserverList;
import org.chromium.base.TraceEvent;
import org.chromium.base.VisibleForTesting;
import org.chromium.content.R;
import org.chromium.content.browser.ChildProcessLauncher;
import org.chromium.content.browser.ContainerViewObserver;
import org.chromium.content.browser.ContentVideoViewClient;
import org.chromium.content.browser.ContentViewClient;
import org.chromium.content.browser.ContentViewDownloadDelegate;
import org.chromium.content.browser.ContextualSearchClient;
import org.chromium.content.browser.JavascriptInterface;
import org.chromium.content.browser.MotionEventSynthesizer;
import org.chromium.content.browser.OverscrollRefreshHandler;
import org.chromium.content.browser.PopupZoomer;
import org.chromium.content.browser.PositionObserver;
import org.chromium.content.browser.RenderCoordinates;
import org.chromium.content.browser.SPenSupport;
import org.chromium.content.browser.ScreenOrientationListener;
import org.chromium.content.browser.SelectActionMode;
import org.chromium.content.browser.SelectActionModeCallback;
import org.chromium.content.browser.ViewPositionObserver;
import org.chromium.content.browser.accessibility.AccessibilityInjector;
import org.chromium.content.browser.accessibility.BrowserAccessibilityManager;
import org.chromium.content.browser.accessibility.captioning.CaptioningBridgeFactory;
import org.chromium.content.browser.accessibility.captioning.SystemCaptioningBridge;
import org.chromium.content.browser.accessibility.captioning.TextTrackSettings;
import org.chromium.content.browser.input.AdapterInputConnection;
import org.chromium.content.browser.input.GamepadList;
import org.chromium.content.browser.input.ImeAdapter;
import org.chromium.content.browser.input.InputMethodManagerWrapper;
import org.chromium.content.browser.input.PastePopupMenu;
import org.chromium.content.browser.input.PopupTouchHandleDrawable;
import org.chromium.content.browser.input.SelectPopup;
import org.chromium.content.browser.input.SelectPopupDialog;
import org.chromium.content.browser.input.SelectPopupDropdown;
import org.chromium.content.browser.input.SelectPopupItem;
import org.chromium.content_public.browser.AccessibilitySnapshotCallback;
import org.chromium.content_public.browser.AccessibilitySnapshotNode;
import org.chromium.content_public.browser.GestureStateListener;
import org.chromium.content_public.browser.WebContents;
import org.chromium.content_public.browser.WebContentsObserver;
import org.chromium.ui.base.DeviceFormFactor;
import org.chromium.ui.base.ViewAndroidDelegate;
import org.chromium.ui.base.WindowAndroid;
import org.chromium.ui.gfx.DeviceDisplayInfo;

@JNINamespace(value="content")
public class ContentViewCore
implements AccessibilityManager.AccessibilityStateChangeListener,
ScreenOrientationListener.ScreenOrientationObserver,
SystemCaptioningBridge.SystemCaptioningBridgeListener {
    private static final String TAG = "cr.ContentViewCore";
    private static final float ZOOM_CONTROLS_EPSILON = 0.007f;
    private static final int IS_LONG_PRESS = 1;
    private static final int IS_LONG_TAP = 2;
    private static final int TEXT_STYLE_BOLD = 1;
    private static final int TEXT_STYLE_ITALIC = 2;
    private static final int TEXT_STYLE_UNDERLINE = 4;
    private static final int TEXT_STYLE_STRIKE_THRU = 8;
    private static final ZoomControlsDelegate NO_OP_ZOOM_CONTROLS_DELEGATE = new ZoomControlsDelegate(){

        @Override
        public void invokeZoomPicker() {
        }

        @Override
        public void dismissZoomPicker() {
        }

        @Override
        public void updateZoomControls() {
        }
    };
    private final Map<String, Pair<Object, Class>> mJavaScriptInterfaces = new HashMap<String, Pair<Object, Class>>();
    private final HashSet<Object> mRetainedJavaScriptObjects = new HashSet();
    private final Context mContext;
    private ViewGroup mContainerView;
    private InternalAccessDelegate mContainerViewInternals;
    private WebContents mWebContents;
    private WebContentsObserver mWebContentsObserver;
    private ContentViewClient mContentViewClient;
    private long mNativeContentViewCore = 0L;
    private final ObserverList<GestureStateListener> mGestureStateListeners;
    private final ObserverList.RewindableIterator<GestureStateListener> mGestureStateListenersIterator;
    private ZoomControlsDelegate mZoomControlsDelegate;
    private PopupZoomer mPopupZoomer;
    private SelectPopup mSelectPopup;
    private long mNativeSelectPopupSourceFrame = 0L;
    private OverscrollRefreshHandler mOverscrollRefreshHandler;
    private Runnable mFakeMouseMoveRunnable = null;
    private ImeAdapter mImeAdapter;
    private ImeAdapter.AdapterInputConnectionFactory mAdapterInputConnectionFactory;
    private AdapterInputConnection mInputConnection;
    private InputMethodManagerWrapper mInputMethodManagerWrapper;
    private PastePopupMenu mPastePopupMenu;
    private boolean mWasPastePopupShowingOnInsertionDragStart;
    private PopupTouchHandleDrawable.PopupTouchHandleDrawableDelegate mTouchHandleDelegate;
    private PositionObserver mPositionObserver;
    private int mViewportWidthPix;
    private int mViewportHeightPix;
    private int mPhysicalBackingWidthPix;
    private int mPhysicalBackingHeightPix;
    private int mTopControlsHeightPix;
    private boolean mTopControlsShrinkBlinkSize;
    private final RenderCoordinates mRenderCoordinates;
    private boolean mIsMobileOptimizedHint;
    private boolean mHasSelection;
    private boolean mHasInsertion;
    private String mLastSelectedText;
    private boolean mFocusedNodeEditable;
    private SelectActionMode mActionMode;
    private boolean mFloatingActionModeCreationFailed;
    private boolean mUnselectAllOnActionModeDismiss;
    private boolean mPreserveSelectionOnNextLossOfFocus;
    private SelectActionModeCallback.ActionHandler mActionHandler;
    private final Rect mSelectionRect = new Rect();
    private ContentViewDownloadDelegate mDownloadDelegate;
    private AccessibilityInjector mAccessibilityInjector;
    private boolean mNativeAccessibilityAllowed;
    private boolean mNativeAccessibilityEnabled;
    private BrowserAccessibilityManager mBrowserAccessibilityManager;
    private final AccessibilityManager mAccessibilityManager;
    private final SystemCaptioningBridge mSystemCaptioningBridge;
    private boolean mTouchExplorationEnabled;
    private boolean mShouldSetAccessibilityFocusOnPageLoad;
    private ContentObserver mAccessibilityScriptInjectionObserver;
    private final Rect mFocusPreOSKViewportRect = new Rect();
    private int mLastTapX;
    private int mLastTapY;
    private boolean mTouchScrollInProgress;
    private int mPotentiallyActiveFlingCount;
    private SmartClipDataListener mSmartClipDataListener = null;
    private ObserverList<ContainerViewObserver> mContainerViewObservers;
    private final Editable mEditable;
    public static final int INVALID_RENDER_PROCESS_PID = 0;
    private float mCurrentTouchOffsetX;
    private float mCurrentTouchOffsetY;
    private int mSmartClipOffsetX;
    private int mSmartClipOffsetY;
    private boolean mFullscreenRequiredForOrientationLock = true;
    private ContentViewAndroidDelegate mViewAndroidDelegate;
    private Boolean mEnableTouchHover;
    private ContextualSearchClient mContextualSearchClient;

    public static Activity activityFromContext(Context context) {
        if (context instanceof Activity) {
            return (Activity)context;
        }
        if (context instanceof ContextWrapper) {
            context = ((ContextWrapper)context).getBaseContext();
            return ContentViewCore.activityFromContext(context);
        }
        return null;
    }

    public static ContentViewCore fromWebContents(WebContents webContents) {
        return ContentViewCore.nativeFromWebContentsAndroid(webContents);
    }

    public ContentViewCore(Context context) {
        this.mContext = context;
        this.mAdapterInputConnectionFactory = new ImeAdapter.AdapterInputConnectionFactory();
        this.mInputMethodManagerWrapper = new InputMethodManagerWrapper(this.mContext);
        this.mRenderCoordinates = new RenderCoordinates();
        float deviceScaleFactor = this.getContext().getResources().getDisplayMetrics().density;
        String forceScaleFactor = CommandLine.getInstance().getSwitchValue("force-device-scale-factor");
        if (forceScaleFactor != null) {
            deviceScaleFactor = Float.valueOf(forceScaleFactor).floatValue();
        }
        this.mRenderCoordinates.setDeviceScaleFactor(deviceScaleFactor);
        this.mAccessibilityManager = (AccessibilityManager)this.getContext().getSystemService("accessibility");
        this.mSystemCaptioningBridge = CaptioningBridgeFactory.getSystemCaptioningBridge(this.mContext);
        this.mGestureStateListeners = new ObserverList();
        this.mGestureStateListenersIterator = this.mGestureStateListeners.rewindableIterator();
        this.mEditable = Editable.Factory.getInstance().newEditable((CharSequence)"");
        Selection.setSelection((Spannable)this.mEditable, (int)0);
        this.mContainerViewObservers = new ObserverList();
    }

    @CalledByNative
    public Context getContext() {
        return this.mContext;
    }

    public ViewGroup getContainerView() {
        return this.mContainerView;
    }

    public WebContents getWebContents() {
        return this.mWebContents;
    }

    public WindowAndroid getWindowAndroid() {
        if (this.mNativeContentViewCore == 0L) {
            return null;
        }
        return this.nativeGetJavaWindowAndroid(this.mNativeContentViewCore);
    }

    public void setTopControlsHeight(int topControlsHeightPix, boolean topControlsShrinkBlinkSize) {
        if (topControlsHeightPix == this.mTopControlsHeightPix && topControlsShrinkBlinkSize == this.mTopControlsShrinkBlinkSize) {
            return;
        }
        this.mTopControlsHeightPix = topControlsHeightPix;
        this.mTopControlsShrinkBlinkSize = topControlsShrinkBlinkSize;
        if (this.mNativeContentViewCore != 0L) {
            this.nativeWasResized(this.mNativeContentViewCore);
        }
    }

    public ViewAndroidDelegate getViewAndroidDelegate() {
        return this.mViewAndroidDelegate;
    }

    @VisibleForTesting
    public void setImeAdapterForTest(ImeAdapter imeAdapter) {
        this.mImeAdapter = imeAdapter;
    }

    @VisibleForTesting
    public ImeAdapter getImeAdapterForTest() {
        return this.mImeAdapter;
    }

    @VisibleForTesting
    public void setAdapterInputConnectionFactory(ImeAdapter.AdapterInputConnectionFactory factory) {
        this.mAdapterInputConnectionFactory = factory;
    }

    @VisibleForTesting
    public void setInputMethodManagerWrapperForTest(InputMethodManagerWrapper immw) {
        this.mInputMethodManagerWrapper = immw;
    }

    @VisibleForTesting
    public AdapterInputConnection getInputConnectionForTest() {
        return this.mInputConnection;
    }

    private ImeAdapter createImeAdapter() {
        return new ImeAdapter(this.mInputMethodManagerWrapper, new ImeAdapter.ImeAdapterDelegate(){

            @Override
            public void onImeEvent() {
                ContentViewCore.this.mPopupZoomer.hide(true);
                ContentViewCore.this.getContentViewClient().onImeEvent();
                if (ContentViewCore.this.mFocusedNodeEditable) {
                    ContentViewCore.this.dismissTextHandles();
                }
            }

            @Override
            public void onKeyboardBoundsUnchanged() {
                assert (ContentViewCore.this.mWebContents != null);
                ContentViewCore.this.mWebContents.scrollFocusedEditableNodeIntoView();
            }

            @Override
            public boolean performContextMenuAction(int id2) {
                assert (ContentViewCore.this.mWebContents != null);
                switch (id2) {
                    case 16908319: {
                        ContentViewCore.this.mWebContents.selectAll();
                        return true;
                    }
                    case 0x1020020: {
                        ContentViewCore.this.mWebContents.cut();
                        return true;
                    }
                    case 0x1020021: {
                        ContentViewCore.this.mWebContents.copy();
                        return true;
                    }
                    case 0x1020022: {
                        ContentViewCore.this.mWebContents.paste();
                        return true;
                    }
                }
                return false;
            }

            @Override
            public View getAttachedView() {
                return ContentViewCore.this.mContainerView;
            }

            @Override
            public ResultReceiver getNewShowKeyboardReceiver() {
                return new ResultReceiver(new Handler()){

                    public void onReceiveResult(int resultCode, Bundle resultData) {
                        if (resultCode == 2) {
                            ContentViewCore.this.getContainerView().getWindowVisibleDisplayFrame(ContentViewCore.this.mFocusPreOSKViewportRect);
                        } else if (ContentViewCore.this.hasFocus() && resultCode == 0) {
                            assert (ContentViewCore.this.mWebContents != null);
                            ContentViewCore.this.mWebContents.scrollFocusedEditableNodeIntoView();
                        }
                    }
                };
            }
        });
    }

    public void initialize(ViewGroup containerView, InternalAccessDelegate internalDispatcher, WebContents webContents, WindowAndroid windowAndroid) {
        this.createContentViewAndroidDelegate();
        this.setContainerView(containerView);
        long windowNativePointer = windowAndroid.getNativePointer();
        assert (windowNativePointer != 0L);
        this.mZoomControlsDelegate = NO_OP_ZOOM_CONTROLS_DELEGATE;
        this.mNativeContentViewCore = this.nativeInit(webContents, this.mViewAndroidDelegate, windowNativePointer, this.mRetainedJavaScriptObjects);
        this.mWebContents = this.nativeGetWebContentsAndroid(this.mNativeContentViewCore);
        this.setContainerViewInternals(internalDispatcher);
        this.mRenderCoordinates.reset();
        this.initPopupZoomer(this.mContext);
        this.mImeAdapter = this.createImeAdapter();
        this.attachImeAdapter();
        this.mAccessibilityInjector = AccessibilityInjector.newInstance(this);
        this.mWebContentsObserver = new ContentViewWebContentsObserver(this);
    }

    @VisibleForTesting
    void createContentViewAndroidDelegate() {
        this.mViewAndroidDelegate = new ContentViewAndroidDelegate(this.mContainerView, this.mRenderCoordinates);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContainerView(ViewGroup containerView) {
        try {
            TraceEvent.begin("ContentViewCore.setContainerView");
            if (this.mContainerView != null) {
                assert (this.mOverscrollRefreshHandler == null);
                this.mPastePopupMenu = null;
                this.mInputConnection = null;
                this.hidePopupsAndClearSelection();
            }
            this.mContainerView = containerView;
            this.mPositionObserver = new ViewPositionObserver((View)this.mContainerView);
            this.mContainerView.setClickable(true);
            this.mViewAndroidDelegate.updateCurrentContainerView(this.mContainerView);
            for (ContainerViewObserver observer : this.mContainerViewObservers) {
                observer.onContainerViewChanged(this.mContainerView);
            }
        }
        finally {
            TraceEvent.end("ContentViewCore.setContainerView");
        }
    }

    public void addContainerViewObserver(ContainerViewObserver observer) {
        this.mContainerViewObservers.addObserver(observer);
    }

    public void removeContainerViewObserver(ContainerViewObserver observer) {
        this.mContainerViewObservers.removeObserver(observer);
    }

    @CalledByNative
    void onNativeContentViewCoreDestroyed(long nativeContentViewCore) {
        assert (nativeContentViewCore == this.mNativeContentViewCore);
        this.mNativeContentViewCore = 0L;
    }

    public void setContainerViewInternals(InternalAccessDelegate internalDispatcher) {
        this.mContainerViewInternals = internalDispatcher;
    }

    @VisibleForTesting
    void initPopupZoomer(Context context) {
        this.mPopupZoomer = new PopupZoomer(context);
        this.mPopupZoomer.setOnVisibilityChangedListener(new PopupZoomer.OnVisibilityChangedListener(){
            private final ViewGroup mContainerViewAtCreation;
            {
                this.mContainerViewAtCreation = ContentViewCore.this.mContainerView;
            }

            @Override
            public void onPopupZoomerShown(final PopupZoomer zoomer) {
                this.mContainerViewAtCreation.post(new Runnable(){

                    @Override
                    public void run() {
                        if (mContainerViewAtCreation.indexOfChild((View)zoomer) == -1) {
                            mContainerViewAtCreation.addView((View)zoomer);
                        }
                    }
                });
            }

            @Override
            public void onPopupZoomerHidden(final PopupZoomer zoomer) {
                this.mContainerViewAtCreation.post(new Runnable(){

                    @Override
                    public void run() {
                        if (mContainerViewAtCreation.indexOfChild((View)zoomer) != -1) {
                            mContainerViewAtCreation.removeView((View)zoomer);
                            mContainerViewAtCreation.invalidate();
                        }
                    }
                });
            }
        });
        PopupZoomer.OnTapListener listener = new PopupZoomer.OnTapListener(){
            private final ViewGroup mContainerViewAtCreation;
            {
                this.mContainerViewAtCreation = ContentViewCore.this.mContainerView;
            }

            @Override
            public boolean onSingleTap(View v, MotionEvent e) {
                this.mContainerViewAtCreation.requestFocus();
                if (ContentViewCore.this.mNativeContentViewCore != 0L) {
                    ContentViewCore.this.nativeSingleTap(ContentViewCore.this.mNativeContentViewCore, e.getEventTime(), e.getX(), e.getY());
                }
                return true;
            }

            @Override
            public boolean onLongPress(View v, MotionEvent e) {
                if (ContentViewCore.this.mNativeContentViewCore != 0L) {
                    ContentViewCore.this.nativeLongPress(ContentViewCore.this.mNativeContentViewCore, e.getEventTime(), e.getX(), e.getY());
                }
                return true;
            }
        };
        this.mPopupZoomer.setOnTapListener(listener);
    }

    @VisibleForTesting
    public void setPopupZoomerForTest(PopupZoomer popupZoomer) {
        this.mPopupZoomer = popupZoomer;
    }

    public void destroy() {
        if (this.mNativeContentViewCore != 0L) {
            this.nativeOnJavaContentViewCoreDestroyed(this.mNativeContentViewCore);
        }
        this.mWebContentsObserver.destroy();
        this.mWebContentsObserver = null;
        this.setSmartClipDataListener(null);
        this.setZoomControlsDelegate(null);
        this.mContentViewClient = new ContentViewClient();
        this.mWebContents = null;
        this.mOverscrollRefreshHandler = null;
        this.mNativeContentViewCore = 0L;
        this.mJavaScriptInterfaces.clear();
        this.mRetainedJavaScriptObjects.clear();
        this.unregisterAccessibilityContentObserver();
        this.mGestureStateListeners.clear();
        ScreenOrientationListener.getInstance().removeObserver(this);
        this.mPositionObserver.clearListener();
        this.mContainerViewObservers.clear();
    }

    private void unregisterAccessibilityContentObserver() {
        if (this.mAccessibilityScriptInjectionObserver == null) {
            return;
        }
        this.getContext().getContentResolver().unregisterContentObserver(this.mAccessibilityScriptInjectionObserver);
        this.mAccessibilityScriptInjectionObserver = null;
    }

    public boolean isAlive() {
        return this.mNativeContentViewCore != 0L;
    }

    @CalledByNative
    public long getNativeContentViewCore() {
        return this.mNativeContentViewCore;
    }

    public void setContentViewClient(ContentViewClient client) {
        if (client == null) {
            throw new IllegalArgumentException("The client can't be null.");
        }
        this.mContentViewClient = client;
    }

    @VisibleForTesting
    public ContentViewClient getContentViewClient() {
        if (this.mContentViewClient == null) {
            this.mContentViewClient = new ContentViewClient();
        }
        return this.mContentViewClient;
    }

    @CalledByNative
    private void onBackgroundColorChanged(int color2) {
        this.getContentViewClient().onBackgroundColorChanged(color2);
    }

    @CalledByNative
    public int getViewportWidthPix() {
        return this.mViewportWidthPix;
    }

    @CalledByNative
    public int getViewportHeightPix() {
        return this.mViewportHeightPix;
    }

    @CalledByNative
    public int getPhysicalBackingWidthPix() {
        return this.mPhysicalBackingWidthPix;
    }

    @CalledByNative
    public int getPhysicalBackingHeightPix() {
        return this.mPhysicalBackingHeightPix;
    }

    @VisibleForTesting
    public int getViewportSizeOffsetWidthPix() {
        return 0;
    }

    @VisibleForTesting
    public int getViewportSizeOffsetHeightPix() {
        return this.mTopControlsShrinkBlinkSize ? this.mTopControlsHeightPix : 0;
    }

    @CalledByNative
    public boolean doTopControlsShrinkBlinkSize() {
        return this.mTopControlsShrinkBlinkSize;
    }

    @CalledByNative
    public int getTopControlsHeightPix() {
        return this.mTopControlsHeightPix;
    }

    public float getContentHeightCss() {
        return this.mRenderCoordinates.getContentHeightCss();
    }

    public float getContentWidthCss() {
        return this.mRenderCoordinates.getContentWidthCss();
    }

    public String getSelectedText() {
        return this.mHasSelection ? this.mLastSelectedText : "";
    }

    public boolean isSelectionEditable() {
        return this.mHasSelection ? this.mFocusedNodeEditable : false;
    }

    public boolean isFocusedNodeEditable() {
        return this.mFocusedNodeEditable;
    }

    public boolean onTouchEvent(MotionEvent event) {
        boolean isTouchHandleEvent = false;
        return this.onTouchEventImpl(event, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean onTouchEventImpl(MotionEvent event, boolean isTouchHandleEvent) {
        TraceEvent.begin("onTouchEvent");
        try {
            int eventAction = event.getActionMasked();
            if (eventAction == 0) {
                this.cancelRequestToScrollFocusedEditableNodeIntoView();
            }
            if (SPenSupport.isSPenSupported(this.mContext)) {
                eventAction = SPenSupport.convertSPenEventAction(eventAction);
            }
            if (!ContentViewCore.isValidTouchEventActionForNative(eventAction)) {
                boolean bl = false;
                return bl;
            }
            if (this.mNativeContentViewCore == 0L) {
                boolean bl = false;
                return bl;
            }
            MotionEvent offset = null;
            if (this.mCurrentTouchOffsetX != 0.0f || this.mCurrentTouchOffsetY != 0.0f) {
                event = offset = this.createOffsetMotionEvent(event);
            }
            int pointerCount = event.getPointerCount();
            boolean consumed = this.nativeOnTouchEvent(this.mNativeContentViewCore, event, event.getEventTime(), eventAction, pointerCount, event.getHistorySize(), event.getActionIndex(), event.getX(), event.getY(), pointerCount > 1 ? event.getX(1) : 0.0f, pointerCount > 1 ? event.getY(1) : 0.0f, event.getPointerId(0), pointerCount > 1 ? event.getPointerId(1) : -1, event.getTouchMajor(), pointerCount > 1 ? event.getTouchMajor(1) : 0.0f, event.getTouchMinor(), pointerCount > 1 ? event.getTouchMinor(1) : 0.0f, event.getOrientation(), pointerCount > 1 ? event.getOrientation(1) : 0.0f, event.getRawX(), event.getRawY(), event.getToolType(0), pointerCount > 1 ? event.getToolType(1) : 0, event.getButtonState(), event.getMetaState(), isTouchHandleEvent);
            if (offset != null) {
                offset.recycle();
            }
            boolean bl = consumed;
            return bl;
        }
        finally {
            TraceEvent.end("onTouchEvent");
        }
    }

    @CalledByNative
    private void requestDisallowInterceptTouchEvent() {
        this.mContainerView.requestDisallowInterceptTouchEvent(true);
    }

    private static boolean isValidTouchEventActionForNative(int eventAction) {
        return eventAction == 0 || eventAction == 1 || eventAction == 3 || eventAction == 2 || eventAction == 5 || eventAction == 6;
    }

    public boolean isScrollInProgress() {
        return this.mTouchScrollInProgress || this.mPotentiallyActiveFlingCount > 0 || this.getContentViewClient().isExternalScrollActive();
    }

    @CalledByNative
    private void onFlingStartEventConsumed(int vx, int vy) {
        this.mTouchScrollInProgress = false;
        ++this.mPotentiallyActiveFlingCount;
        this.mGestureStateListenersIterator.rewind();
        while (this.mGestureStateListenersIterator.hasNext()) {
            ((GestureStateListener)this.mGestureStateListenersIterator.next()).onFlingStartGesture(vx, vy, this.computeVerticalScrollOffset(), this.computeVerticalScrollExtent());
        }
    }

    @CalledByNative
    private void onFlingStartEventHadNoConsumer(int vx, int vy) {
        this.mTouchScrollInProgress = false;
    }

    @CalledByNative
    private void onFlingCancelEventAck() {
        this.updateGestureStateListener(10);
    }

    @CalledByNative
    private void onScrollBeginEventAck() {
        this.mTouchScrollInProgress = true;
        this.hidePastePopup();
        this.mZoomControlsDelegate.invokeZoomPicker();
        this.updateGestureStateListener(6);
    }

    @CalledByNative
    private void onScrollUpdateGestureConsumed() {
        this.mZoomControlsDelegate.invokeZoomPicker();
        this.mGestureStateListenersIterator.rewind();
        while (this.mGestureStateListenersIterator.hasNext()) {
            ((GestureStateListener)this.mGestureStateListenersIterator.next()).onScrollUpdateGestureConsumed();
        }
    }

    @CalledByNative
    private void onScrollEndEventAck() {
        if (!this.mTouchScrollInProgress) {
            return;
        }
        this.mTouchScrollInProgress = false;
        this.updateGestureStateListener(8);
    }

    @CalledByNative
    private void onPinchBeginEventAck() {
        this.updateGestureStateListener(12);
    }

    @CalledByNative
    private void onPinchEndEventAck() {
        this.updateGestureStateListener(14);
    }

    @CalledByNative
    private void onSingleTapEventAck(boolean consumed, int x, int y) {
        this.mGestureStateListenersIterator.rewind();
        while (this.mGestureStateListenersIterator.hasNext()) {
            ((GestureStateListener)this.mGestureStateListenersIterator.next()).onSingleTap(consumed, x, y);
        }
    }

    @CalledByNative
    private void onShowUnhandledTapUIIfNeeded(int x, int y) {
        if (this.mContextualSearchClient != null) {
            this.mContextualSearchClient.showUnhandledTapUIIfNeeded(x, y);
        }
    }

    @CalledByNative
    private boolean filterTapOrPressEvent(int type, int x, int y) {
        if (type == 5 && this.offerLongPressToEmbedder()) {
            return true;
        }
        this.updateForTapOrPress(type, x, y);
        return false;
    }

    @VisibleForTesting
    public void sendDoubleTapForTest(long timeMs, int x, int y) {
        if (this.mNativeContentViewCore == 0L) {
            return;
        }
        this.nativeDoubleTap(this.mNativeContentViewCore, timeMs, x, y);
    }

    public void flingViewport(long timeMs, int velocityX, int velocityY) {
        if (this.mNativeContentViewCore == 0L) {
            return;
        }
        this.nativeFlingCancel(this.mNativeContentViewCore, timeMs);
        this.nativeScrollBegin(this.mNativeContentViewCore, timeMs, 0.0f, 0.0f, velocityX, velocityY, true);
        this.nativeFlingStart(this.mNativeContentViewCore, timeMs, 0.0f, 0.0f, velocityX, velocityY, true);
    }

    public void cancelFling(long timeMs) {
        if (this.mNativeContentViewCore == 0L) {
            return;
        }
        this.nativeFlingCancel(this.mNativeContentViewCore, timeMs);
    }

    public void addGestureStateListener(GestureStateListener listener) {
        this.mGestureStateListeners.addObserver(listener);
    }

    public void removeGestureStateListener(GestureStateListener listener) {
        this.mGestureStateListeners.removeObserver(listener);
    }

    void updateGestureStateListener(int gestureType) {
        this.mGestureStateListenersIterator.rewind();
        while (this.mGestureStateListenersIterator.hasNext()) {
            GestureStateListener listener = (GestureStateListener)this.mGestureStateListenersIterator.next();
            switch (gestureType) {
                case 12: {
                    listener.onPinchStarted();
                    break;
                }
                case 14: {
                    listener.onPinchEnded();
                    break;
                }
                case 11: {
                    listener.onFlingEndGesture(this.computeVerticalScrollOffset(), this.computeVerticalScrollExtent());
                    break;
                }
                case 10: {
                    listener.onFlingCancelGesture();
                    break;
                }
                case 6: {
                    listener.onScrollStarted(this.computeVerticalScrollOffset(), this.computeVerticalScrollExtent());
                    break;
                }
                case 8: {
                    listener.onScrollEnded(this.computeVerticalScrollOffset(), this.computeVerticalScrollExtent());
                    break;
                }
            }
        }
    }

    public void setDrawsContent(boolean draws) {
        if (this.mNativeContentViewCore == 0L) {
            return;
        }
        this.nativeSetDrawsContent(this.mNativeContentViewCore, draws);
    }

    public void onShow() {
        assert (this.mWebContents != null);
        this.mWebContents.onShow();
        this.setAccessibilityState(this.mAccessibilityManager.isEnabled());
        this.restoreSelectionPopupsIfNecessary();
    }

    public int getCurrentRenderProcessId() {
        return this.nativeGetCurrentRenderProcessId(this.mNativeContentViewCore);
    }

    public void onHide() {
        assert (this.mWebContents != null);
        this.hidePopupsAndPreserveSelection();
        this.setInjectedAccessibility(false);
        this.mWebContents.onHide();
    }

    private void hidePopupsAndClearSelection() {
        this.mUnselectAllOnActionModeDismiss = true;
        this.hidePopups();
    }

    private void hidePopupsAndPreserveSelection() {
        this.mUnselectAllOnActionModeDismiss = false;
        this.hidePopups();
    }

    private void clearUserSelection() {
        if (this.mFocusedNodeEditable) {
            if (this.mInputConnection != null) {
                int selectionEnd = Selection.getSelectionEnd((CharSequence)this.mEditable);
                this.mInputConnection.setSelection(selectionEnd, selectionEnd);
            }
        } else if (this.mWebContents != null) {
            this.mWebContents.unselect();
        }
    }

    private void hidePopups() {
        this.hideSelectActionMode();
        this.hidePastePopup();
        this.hideSelectPopup();
        this.mPopupZoomer.hide(false);
        if (this.mUnselectAllOnActionModeDismiss) {
            this.dismissTextHandles();
        }
    }

    private void restoreSelectionPopupsIfNecessary() {
        if (this.mHasSelection && this.mActionMode == null) {
            this.showSelectActionMode(true);
        }
    }

    public void hideSelectActionMode() {
        if (this.mActionMode != null) {
            this.mActionMode.finish();
            this.mActionMode = null;
        }
    }

    public boolean isSelectActionBarShowing() {
        return this.mActionMode != null;
    }

    private void resetGestureDetection() {
        if (this.mNativeContentViewCore == 0L) {
            return;
        }
        this.nativeResetGestureDetection(this.mNativeContentViewCore);
    }

    public void onAttachedToWindow() {
        this.setAccessibilityState(this.mAccessibilityManager.isEnabled());
        this.setTextHandlesTemporarilyHidden(false);
        this.restoreSelectionPopupsIfNecessary();
        ScreenOrientationListener.getInstance().addObserver(this, this.mContext);
        GamepadList.onAttachedToWindow(this.mContext);
        this.mAccessibilityManager.addAccessibilityStateChangeListener((AccessibilityManager.AccessibilityStateChangeListener)this);
        this.mSystemCaptioningBridge.addListener(this);
    }

    @SuppressLint(value={"MissingSuperCall"})
    public void onDetachedFromWindow() {
        this.setInjectedAccessibility(false);
        this.mZoomControlsDelegate.dismissZoomPicker();
        this.unregisterAccessibilityContentObserver();
        ScreenOrientationListener.getInstance().removeObserver(this);
        GamepadList.onDetachedFromWindow();
        this.mAccessibilityManager.removeAccessibilityStateChangeListener((AccessibilityManager.AccessibilityStateChangeListener)this);
        this.setTextHandlesTemporarilyHidden(true);
        this.hidePopupsAndPreserveSelection();
        this.mSystemCaptioningBridge.removeListener(this);
    }

    public void onVisibilityChanged(View changedView, int visibility) {
        if (visibility != 0) {
            this.mZoomControlsDelegate.dismissZoomPicker();
        }
    }

    public InputConnection onCreateInputConnection(EditorInfo outAttrs) {
        if (!this.mImeAdapter.hasTextInputType()) {
            outAttrs.imeOptions = 0x2000000;
        }
        this.mInputConnection = this.mAdapterInputConnectionFactory.get((View)this.mContainerView, this.mImeAdapter, this.mEditable, outAttrs);
        return this.mInputConnection;
    }

    @VisibleForTesting
    public AdapterInputConnection getAdapterInputConnectionForTest() {
        return this.mInputConnection;
    }

    @VisibleForTesting
    public Editable getEditableForTest() {
        return this.mEditable;
    }

    public boolean onCheckIsTextEditor() {
        return this.mImeAdapter.hasTextInputType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConfigurationChanged(Configuration newConfig) {
        try {
            TraceEvent.begin("ContentViewCore.onConfigurationChanged");
            if (newConfig.keyboard != 1) {
                if (this.mNativeContentViewCore != 0L) {
                    this.mImeAdapter.attach(this.nativeGetNativeImeAdapter(this.mNativeContentViewCore));
                }
                this.mInputMethodManagerWrapper.restartInput((View)this.mContainerView);
            }
            this.mContainerViewInternals.super_onConfigurationChanged(newConfig);
            this.mContainerView.requestLayout();
        }
        finally {
            TraceEvent.end("ContentViewCore.onConfigurationChanged");
        }
    }

    public void onSizeChanged(int wPix, int hPix, int owPix, int ohPix) {
        if (this.getViewportWidthPix() == wPix && this.getViewportHeightPix() == hPix) {
            return;
        }
        this.mViewportWidthPix = wPix;
        this.mViewportHeightPix = hPix;
        if (this.mNativeContentViewCore != 0L) {
            this.nativeWasResized(this.mNativeContentViewCore);
        }
        this.updateAfterSizeChanged();
    }

    public void onPhysicalBackingSizeChanged(int wPix, int hPix) {
        if (this.mPhysicalBackingWidthPix == wPix && this.mPhysicalBackingHeightPix == hPix) {
            return;
        }
        this.mPhysicalBackingWidthPix = wPix;
        this.mPhysicalBackingHeightPix = hPix;
        if (this.mNativeContentViewCore != 0L) {
            this.nativeWasResized(this.mNativeContentViewCore);
        }
    }

    public void onOverdrawBottomHeightChanged(int overdrawHeightPix) {
    }

    private void updateAfterSizeChanged() {
        this.mPopupZoomer.hide(false);
        if (!this.mFocusPreOSKViewportRect.isEmpty()) {
            Rect rect = new Rect();
            this.getContainerView().getWindowVisibleDisplayFrame(rect);
            if (!rect.equals((Object)this.mFocusPreOSKViewportRect)) {
                if (rect.width() == this.mFocusPreOSKViewportRect.width()) {
                    assert (this.mWebContents != null);
                    this.mWebContents.scrollFocusedEditableNodeIntoView();
                }
                this.cancelRequestToScrollFocusedEditableNodeIntoView();
            }
        }
    }

    private void cancelRequestToScrollFocusedEditableNodeIntoView() {
        this.mFocusPreOSKViewportRect.setEmpty();
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        if (!hasWindowFocus) {
            this.resetGestureDetection();
        }
    }

    public void onFocusChanged(boolean gainFocus) {
        if (gainFocus) {
            this.restoreSelectionPopupsIfNecessary();
        } else {
            this.hideImeIfNeeded();
            this.cancelRequestToScrollFocusedEditableNodeIntoView();
            if (this.mPreserveSelectionOnNextLossOfFocus) {
                this.mPreserveSelectionOnNextLossOfFocus = false;
                this.hidePopupsAndPreserveSelection();
            } else {
                this.hidePopupsAndClearSelection();
                this.clearUserSelection();
            }
        }
        if (this.mNativeContentViewCore != 0L) {
            this.nativeSetFocus(this.mNativeContentViewCore, gainFocus);
        }
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (this.mPopupZoomer.isShowing() && keyCode == 4) {
            this.mPopupZoomer.hide(true);
            return true;
        }
        return this.mContainerViewInternals.super_onKeyUp(keyCode, event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchKeyEventPreIme(KeyEvent event) {
        try {
            TraceEvent.begin("ContentViewCore.dispatchKeyEventPreIme");
            boolean bl = this.mContainerViewInternals.super_dispatchKeyEventPreIme(event);
            return bl;
        }
        finally {
            TraceEvent.end("ContentViewCore.dispatchKeyEventPreIme");
        }
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        if (GamepadList.dispatchKeyEvent(event)) {
            return true;
        }
        if (this.getContentViewClient().shouldOverrideKeyEvent(event)) {
            return this.mContainerViewInternals.super_dispatchKeyEvent(event);
        }
        if (this.mImeAdapter.dispatchKeyEvent(event)) {
            return true;
        }
        return this.mContainerViewInternals.super_dispatchKeyEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onHoverEvent(MotionEvent event) {
        TraceEvent.begin("onHoverEvent");
        MotionEvent offset = this.createOffsetMotionEvent(event);
        try {
            if (this.mBrowserAccessibilityManager != null) {
                boolean bl = this.mBrowserAccessibilityManager.onHoverEvent(offset);
                return bl;
            }
            if (this.mTouchExplorationEnabled && offset.getAction() == 10) {
                boolean bl = true;
                return bl;
            }
            if (event.getToolType(0) == 1) {
                if (this.mEnableTouchHover == null) {
                    this.mEnableTouchHover = CommandLine.getInstance().hasSwitch("enable-touch-hover");
                }
                if (!this.mEnableTouchHover.booleanValue()) {
                    boolean bl = false;
                    return bl;
                }
            }
            this.mContainerView.removeCallbacks(this.mFakeMouseMoveRunnable);
            if (this.mNativeContentViewCore != 0L) {
                this.nativeSendMouseMoveEvent(this.mNativeContentViewCore, offset.getEventTime(), offset.getX(), offset.getY());
            }
            boolean bl = true;
            return bl;
        }
        finally {
            offset.recycle();
            TraceEvent.end("onHoverEvent");
        }
    }

    public boolean onGenericMotionEvent(MotionEvent event) {
        if (GamepadList.onGenericMotionEvent(event)) {
            return true;
        }
        if ((event.getSource() & 2) != 0) {
            switch (event.getAction()) {
                case 8: {
                    if (this.mNativeContentViewCore == 0L) {
                        return false;
                    }
                    this.nativeSendMouseWheelEvent(this.mNativeContentViewCore, event.getEventTime(), event.getX(), event.getY(), event.getAxisValue(9), event.getAxisValue(10));
                    this.mContainerView.removeCallbacks(this.mFakeMouseMoveRunnable);
                    final MotionEvent eventFakeMouseMove = MotionEvent.obtain((MotionEvent)event);
                    this.mFakeMouseMoveRunnable = new Runnable(){

                        @Override
                        public void run() {
                            ContentViewCore.this.onHoverEvent(eventFakeMouseMove);
                            eventFakeMouseMove.recycle();
                        }
                    };
                    this.mContainerView.postDelayed(this.mFakeMouseMoveRunnable, 250L);
                    return true;
                }
            }
        }
        return this.mContainerViewInternals.super_onGenericMotionEvent(event);
    }

    public void setCurrentMotionEventOffsets(float dx, float dy) {
        this.mCurrentTouchOffsetX = dx;
        this.mCurrentTouchOffsetY = dy;
    }

    private MotionEvent createOffsetMotionEvent(MotionEvent src) {
        MotionEvent dst = MotionEvent.obtain((MotionEvent)src);
        dst.offsetLocation(this.mCurrentTouchOffsetX, this.mCurrentTouchOffsetY);
        return dst;
    }

    public void scrollBy(float dxPix, float dyPix) {
        if (this.mNativeContentViewCore == 0L) {
            return;
        }
        if (dxPix == 0.0f && dyPix == 0.0f) {
            return;
        }
        long time = SystemClock.uptimeMillis();
        if (this.mPotentiallyActiveFlingCount > 0) {
            this.nativeFlingCancel(this.mNativeContentViewCore, time);
        }
        this.nativeScrollBegin(this.mNativeContentViewCore, time, 0.0f, 0.0f, -dxPix, -dyPix, false);
        this.nativeScrollBy(this.mNativeContentViewCore, time, 0.0f, 0.0f, dxPix, dyPix);
        this.nativeScrollEnd(this.mNativeContentViewCore, time);
    }

    public void scrollTo(float xPix, float yPix) {
        if (this.mNativeContentViewCore == 0L) {
            return;
        }
        float xCurrentPix = this.mRenderCoordinates.getScrollXPix();
        float yCurrentPix = this.mRenderCoordinates.getScrollYPix();
        float dxPix = xPix - xCurrentPix;
        float dyPix = yPix - yCurrentPix;
        this.scrollBy(dxPix, dyPix);
    }

    public int getNativeScrollXForTest() {
        return this.mRenderCoordinates.getScrollXPixInt();
    }

    public int getNativeScrollYForTest() {
        return this.mRenderCoordinates.getScrollYPixInt();
    }

    public int computeHorizontalScrollExtent() {
        return this.mRenderCoordinates.getLastFrameViewportWidthPixInt();
    }

    public int computeHorizontalScrollOffset() {
        return this.mRenderCoordinates.getScrollXPixInt();
    }

    public int computeHorizontalScrollRange() {
        return this.mRenderCoordinates.getContentWidthPixInt();
    }

    public int computeVerticalScrollExtent() {
        return this.mRenderCoordinates.getLastFrameViewportHeightPixInt();
    }

    public int computeVerticalScrollOffset() {
        return this.mRenderCoordinates.getScrollYPixInt();
    }

    public int computeVerticalScrollRange() {
        return this.mRenderCoordinates.getContentHeightPixInt();
    }

    public boolean awakenScrollBars(int startDelay, boolean invalidate) {
        if (this.mContainerView.getScrollBarStyle() == 0) {
            return false;
        }
        return this.mContainerViewInternals.super_awakenScrollBars(startDelay, invalidate);
    }

    private void updateForTapOrPress(int type, float xPix, float yPix) {
        if (type != 3 && type != 2 && type != 5 && type != 16) {
            return;
        }
        if (this.mContainerView.isFocusable() && this.mContainerView.isFocusableInTouchMode() && !this.mContainerView.isFocused()) {
            this.mContainerView.requestFocus();
        }
        if (!this.mPopupZoomer.isShowing()) {
            this.mPopupZoomer.setLastTouch(xPix, yPix);
        }
        this.mLastTapX = (int)xPix;
        this.mLastTapY = (int)yPix;
    }

    public int getLastTapX() {
        return this.mLastTapX;
    }

    public int getLastTapY() {
        return this.mLastTapY;
    }

    public void setZoomControlsDelegate(ZoomControlsDelegate zoomControlsDelegate) {
        if (zoomControlsDelegate == null) {
            this.mZoomControlsDelegate = NO_OP_ZOOM_CONTROLS_DELEGATE;
            return;
        }
        this.mZoomControlsDelegate = zoomControlsDelegate;
    }

    public void updateMultiTouchZoomSupport(boolean supportsMultiTouchZoom) {
        if (this.mNativeContentViewCore == 0L) {
            return;
        }
        this.nativeSetMultiTouchZoomSupportEnabled(this.mNativeContentViewCore, supportsMultiTouchZoom);
    }

    public void updateDoubleTapSupport(boolean supportsDoubleTap) {
        if (this.mNativeContentViewCore == 0L) {
            return;
        }
        this.nativeSetDoubleTapSupportEnabled(this.mNativeContentViewCore, supportsDoubleTap);
    }

    public void selectPopupMenuItems(int[] indices) {
        if (this.mNativeContentViewCore != 0L) {
            this.nativeSelectPopupMenuItems(this.mNativeContentViewCore, this.mNativeSelectPopupSourceFrame, indices);
        }
        this.mNativeSelectPopupSourceFrame = 0L;
        this.mSelectPopup = null;
    }

    @VisibleForTesting
    void sendOrientationChangeEvent(int orientation) {
        if (this.mNativeContentViewCore == 0L) {
            return;
        }
        this.nativeSendOrientationChangeEvent(this.mNativeContentViewCore, orientation);
    }

    public void setDownloadDelegate(ContentViewDownloadDelegate delegate) {
        this.mDownloadDelegate = delegate;
    }

    ContentViewDownloadDelegate getDownloadDelegate() {
        return this.mDownloadDelegate;
    }

    @VisibleForTesting
    public SelectActionModeCallback.ActionHandler getSelectActionHandler() {
        return this.mActionHandler;
    }

    private void showSelectActionMode(boolean allowFallbackIfFloatingActionModeCreationFails) {
        if (this.mActionMode != null) {
            this.mActionMode.invalidate();
            return;
        }
        if (this.mActionHandler == null) {
            this.mActionHandler = new SelectActionModeCallback.ActionHandler(){

                @Override
                public void selectAll() {
                    ContentViewCore.this.mWebContents.selectAll();
                }

                @Override
                public void cut() {
                    ContentViewCore.this.mWebContents.cut();
                }

                @Override
                public void copy() {
                    ContentViewCore.this.mWebContents.copy();
                }

                @Override
                public void paste() {
                    ContentViewCore.this.mWebContents.paste();
                }

                @Override
                public void share() {
                    String query = ContentViewCore.this.getSelectedText();
                    if (TextUtils.isEmpty((CharSequence)query)) {
                        return;
                    }
                    Intent send = new Intent("android.intent.action.SEND");
                    send.setType("text/plain");
                    send.putExtra("android.intent.extra.TEXT", query);
                    try {
                        Intent i = Intent.createChooser((Intent)send, (CharSequence)ContentViewCore.this.getContext().getString(R.string.actionbar_share));
                        i.setFlags(0x10000000);
                        ContentViewCore.this.getContext().startActivity(i);
                    }
                    catch (ActivityNotFoundException activityNotFoundException) {
                        // empty catch block
                    }
                }

                @Override
                public void search() {
                    String query = ContentViewCore.this.getSelectedText();
                    if (TextUtils.isEmpty((CharSequence)query)) {
                        return;
                    }
                    if (ContentViewCore.this.getContentViewClient().doesPerformWebSearch()) {
                        ContentViewCore.this.getContentViewClient().performWebSearch(query);
                        return;
                    }
                    Intent i = new Intent("android.intent.action.WEB_SEARCH");
                    i.putExtra("new_search", true);
                    i.putExtra("query", query);
                    i.putExtra("com.android.browser.application_id", ContentViewCore.this.getContext().getPackageName());
                    i.addFlags(0x10000000);
                    try {
                        ContentViewCore.this.getContext().startActivity(i);
                    }
                    catch (ActivityNotFoundException activityNotFoundException) {
                        // empty catch block
                    }
                }

                @Override
                public boolean isSelectionPassword() {
                    return ContentViewCore.this.mImeAdapter.isSelectionPassword();
                }

                @Override
                public boolean isSelectionEditable() {
                    return ContentViewCore.this.mFocusedNodeEditable;
                }

                @Override
                public boolean isInsertion() {
                    return ContentViewCore.this.mHasInsertion;
                }

                @Override
                public void onDestroyActionMode() {
                    ContentViewCore.this.mActionMode = null;
                    if (ContentViewCore.this.mUnselectAllOnActionModeDismiss) {
                        ContentViewCore.this.dismissTextHandles();
                        ContentViewCore.this.clearUserSelection();
                    }
                    ContentViewCore.this.getContentViewClient().onContextualActionBarHidden();
                }

                @Override
                public void onGetContentRect(Rect outRect) {
                    outRect.set(ContentViewCore.this.mSelectionRect);
                }

                @Override
                public boolean isShareAvailable() {
                    Intent intent = new Intent("android.intent.action.SEND");
                    intent.setType("text/plain");
                    return ContentViewCore.this.getContext().getPackageManager().queryIntentActivities(intent, 65536).size() > 0;
                }

                @Override
                public boolean isWebSearchAvailable() {
                    if (ContentViewCore.this.getContentViewClient().doesPerformWebSearch()) {
                        return true;
                    }
                    Intent intent = new Intent("android.intent.action.WEB_SEARCH");
                    intent.putExtra("new_search", true);
                    return ContentViewCore.this.getContext().getPackageManager().queryIntentActivities(intent, 65536).size() > 0;
                }

                @Override
                public boolean isIncognito() {
                    return ContentViewCore.this.mWebContents.isIncognito();
                }
            };
        }
        this.mActionMode = null;
        if (this.mContainerView.getParent() != null) {
            assert (this.mWebContents != null);
            boolean tryCreateFloatingActionMode = this.supportsFloatingActionMode();
            this.mActionMode = this.getContentViewClient().startActionMode((View)this.mContainerView, this.mActionHandler, tryCreateFloatingActionMode);
            if (tryCreateFloatingActionMode && this.mActionMode == null) {
                this.mFloatingActionModeCreationFailed = true;
                if (!allowFallbackIfFloatingActionModeCreationFails) {
                    return;
                }
                this.mActionMode = this.getContentViewClient().startActionMode((View)this.mContainerView, this.mActionHandler, false);
            }
        }
        this.mUnselectAllOnActionModeDismiss = true;
        if (this.mActionMode == null) {
            this.clearSelection();
        } else {
            this.getContentViewClient().onContextualActionBarShown();
        }
    }

    private boolean supportsFloatingActionMode() {
        return !this.mFloatingActionModeCreationFailed && this.getContentViewClient().supportsFloatingActionMode();
    }

    private void invalidateActionModeContentRect() {
        if (this.mActionMode != null) {
            this.mActionMode.invalidateContentRect();
        }
    }

    public void clearSelection() {
        if (this.mWebContents != null) {
            this.mWebContents.unselect();
        }
    }

    public void preserveSelectionOnNextLossOfFocus() {
        this.mPreserveSelectionOnNextLossOfFocus = true;
    }

    @VisibleForTesting
    public boolean hasSelection() {
        return this.mHasSelection;
    }

    @VisibleForTesting
    protected boolean hasInsertion() {
        return this.mHasInsertion;
    }

    @CalledByNative
    private void onSelectionEvent(int eventType, int xAnchor, int yAnchor, int left, int top, int right, int bottom) {
        if (left == right) {
            ++right;
        }
        if (top == bottom) {
            ++bottom;
        }
        switch (eventType) {
            case 0: {
                this.mSelectionRect.set(left, top, right, bottom);
                this.mHasSelection = true;
                this.mUnselectAllOnActionModeDismiss = true;
                this.mContainerView.performHapticFeedback(0);
                this.showSelectActionMode(true);
                break;
            }
            case 1: {
                this.mSelectionRect.set(left, top, right, bottom);
                this.invalidateActionModeContentRect();
                break;
            }
            case 2: {
                this.mHasSelection = false;
                this.mUnselectAllOnActionModeDismiss = false;
                this.hideSelectActionMode();
                this.mSelectionRect.setEmpty();
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                this.mSelectionRect.set(left, top, right, bottom);
                this.mHasInsertion = true;
                break;
            }
            case 6: {
                this.mSelectionRect.set(left, top, right, bottom);
                if (!this.isScrollInProgress() && this.isPastePopupShowing()) {
                    this.showPastePopup(xAnchor, yAnchor);
                    break;
                }
                this.hidePastePopup();
                break;
            }
            case 7: {
                if (this.mWasPastePopupShowingOnInsertionDragStart) {
                    this.hidePastePopup();
                    break;
                }
                this.showPastePopup(xAnchor, yAnchor);
                break;
            }
            case 8: {
                this.hidePastePopup();
                this.mHasInsertion = false;
                this.mSelectionRect.setEmpty();
                break;
            }
            case 9: {
                this.mWasPastePopupShowingOnInsertionDragStart = this.isPastePopupShowing();
                this.hidePastePopup();
                break;
            }
            case 10: {
                break;
            }
            default: {
                assert (false) : "Invalid selection event type.";
                break;
            }
        }
        if (this.mContextualSearchClient != null) {
            this.mContextualSearchClient.onSelectionEvent(eventType, xAnchor, yAnchor);
        }
    }

    private void dismissTextHandles() {
        this.mHasSelection = false;
        this.mHasInsertion = false;
        if (this.mNativeContentViewCore != 0L) {
            this.nativeDismissTextHandles(this.mNativeContentViewCore);
        }
    }

    private void setTextHandlesTemporarilyHidden(boolean hide) {
        if (this.mNativeContentViewCore == 0L) {
            return;
        }
        this.nativeSetTextHandlesTemporarilyHidden(this.mNativeContentViewCore, hide);
    }

    public void hideImeIfNeeded() {
        if (this.mInputMethodManagerWrapper.isActive((View)this.mContainerView)) {
            this.mInputMethodManagerWrapper.hideSoftInputFromWindow(this.mContainerView.getWindowToken(), 0, null);
        }
    }

    @CalledByNative
    private void updateFrameInfo(float scrollOffsetX, float scrollOffsetY, float pageScaleFactor, float minPageScaleFactor, float maxPageScaleFactor, float contentWidth, float contentHeight, float viewportWidth, float viewportHeight, float controlsOffsetYCss, float contentOffsetYCss, boolean isMobileOptimizedHint) {
        boolean needUpdateZoomControls;
        TraceEvent.begin("ContentViewCore:updateFrameInfo");
        this.mIsMobileOptimizedHint = isMobileOptimizedHint;
        float deviceScale = this.mRenderCoordinates.getDeviceScaleFactor();
        contentWidth = Math.max(contentWidth, (float)this.mViewportWidthPix / (deviceScale * pageScaleFactor));
        contentHeight = Math.max(contentHeight, (float)this.mViewportHeightPix / (deviceScale * pageScaleFactor));
        float contentOffsetYPix = this.mRenderCoordinates.fromDipToPix(contentOffsetYCss);
        boolean contentSizeChanged = contentWidth != this.mRenderCoordinates.getContentWidthCss() || contentHeight != this.mRenderCoordinates.getContentHeightCss();
        boolean scaleLimitsChanged = minPageScaleFactor != this.mRenderCoordinates.getMinPageScaleFactor() || maxPageScaleFactor != this.mRenderCoordinates.getMaxPageScaleFactor();
        boolean pageScaleChanged = pageScaleFactor != this.mRenderCoordinates.getPageScaleFactor();
        boolean scrollChanged = pageScaleChanged || scrollOffsetX != this.mRenderCoordinates.getScrollX() || scrollOffsetY != this.mRenderCoordinates.getScrollY();
        boolean contentOffsetChanged = contentOffsetYPix != this.mRenderCoordinates.getContentOffsetYPix();
        boolean needHidePopupZoomer = contentSizeChanged || scrollChanged;
        boolean bl = needUpdateZoomControls = scaleLimitsChanged || scrollChanged;
        if (needHidePopupZoomer) {
            this.mPopupZoomer.hide(true);
        }
        if (scrollChanged) {
            this.mContainerViewInternals.onScrollChanged((int)this.mRenderCoordinates.fromLocalCssToPix(scrollOffsetX), (int)this.mRenderCoordinates.fromLocalCssToPix(scrollOffsetY), (int)this.mRenderCoordinates.getScrollXPix(), (int)this.mRenderCoordinates.getScrollYPix());
        }
        this.mRenderCoordinates.updateFrameInfo(scrollOffsetX, scrollOffsetY, contentWidth, contentHeight, viewportWidth, viewportHeight, pageScaleFactor, minPageScaleFactor, maxPageScaleFactor, contentOffsetYPix);
        if (scrollChanged || contentOffsetChanged) {
            this.mGestureStateListenersIterator.rewind();
            while (this.mGestureStateListenersIterator.hasNext()) {
                ((GestureStateListener)this.mGestureStateListenersIterator.next()).onScrollOffsetOrExtentChanged(this.computeVerticalScrollOffset(), this.computeVerticalScrollExtent());
            }
        }
        if (needUpdateZoomControls) {
            this.mZoomControlsDelegate.updateZoomControls();
        }
        float controlsOffsetPix = controlsOffsetYCss * deviceScale;
        this.getContentViewClient().onOffsetsForFullscreenChanged(controlsOffsetPix, contentOffsetYPix, 0.0f);
        if (this.mBrowserAccessibilityManager != null) {
            this.mBrowserAccessibilityManager.notifyFrameInfoInitialized();
        }
        TraceEvent.end("ContentViewCore:updateFrameInfo");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    private void updateImeAdapter(long nativeImeAdapterAndroid, int textInputType, int textInputFlags, String text, int selectionStart, int selectionEnd, int compositionStart, int compositionEnd, boolean showImeIfNeeded, boolean isNonImeChange) {
        try {
            boolean focusedNodeEditable;
            TraceEvent.begin("ContentViewCore.updateImeAdapter");
            boolean bl = focusedNodeEditable = textInputType != 0;
            if (!focusedNodeEditable) {
                this.hidePastePopup();
            }
            this.mImeAdapter.updateKeyboardVisibility(nativeImeAdapterAndroid, textInputType, textInputFlags, showImeIfNeeded);
            if (this.mInputConnection != null) {
                this.mInputConnection.updateState(text, selectionStart, selectionEnd, compositionStart, compositionEnd, isNonImeChange);
            }
            if (this.mActionMode != null) {
                this.mActionMode.invalidate();
            }
            if (focusedNodeEditable != this.mFocusedNodeEditable) {
                this.mFocusedNodeEditable = focusedNodeEditable;
                this.getContentViewClient().onFocusedNodeEditabilityChanged(this.mFocusedNodeEditable);
            }
        }
        finally {
            TraceEvent.end("ContentViewCore.updateImeAdapter");
        }
    }

    @CalledByNative
    private void forceUpdateImeAdapter(long nativeImeAdapterAndroid) {
        this.mImeAdapter.attach(nativeImeAdapterAndroid);
    }

    @CalledByNative
    private void setTitle(String title) {
        this.getContentViewClient().onUpdateTitle(title);
    }

    @CalledByNative
    private void showSelectPopup(long nativeSelectPopupSourceFrame, Rect bounds, String[] items, int[] enabled, boolean multiple, int[] selectedIndices) {
        if (this.mContainerView.getParent() == null || this.mContainerView.getVisibility() != 0) {
            this.mNativeSelectPopupSourceFrame = nativeSelectPopupSourceFrame;
            this.selectPopupMenuItems(null);
            return;
        }
        this.hidePopupsAndClearSelection();
        assert (this.mNativeSelectPopupSourceFrame == 0L) : "Zombie popup did not clear the frame source";
        assert (items.length == enabled.length);
        ArrayList<SelectPopupItem> popupItems = new ArrayList<SelectPopupItem>();
        for (int i = 0; i < items.length; ++i) {
            popupItems.add(new SelectPopupItem(items[i], enabled[i]));
        }
        this.mSelectPopup = DeviceFormFactor.isTablet(this.mContext) && !multiple && !this.isTouchExplorationEnabled() ? new SelectPopupDropdown(this, popupItems, bounds, selectedIndices) : new SelectPopupDialog(this, popupItems, multiple, selectedIndices);
        this.mNativeSelectPopupSourceFrame = nativeSelectPopupSourceFrame;
        this.mSelectPopup.show();
    }

    @CalledByNative
    private void hideSelectPopup() {
        if (this.mSelectPopup != null) {
            this.mSelectPopup.hide();
        }
    }

    public SelectPopup getSelectPopupForTest() {
        return this.mSelectPopup;
    }

    @CalledByNative
    private void showDisambiguationPopup(Rect targetRect, Bitmap zoomedBitmap) {
        this.mPopupZoomer.setBitmap(zoomedBitmap);
        this.mPopupZoomer.show(targetRect);
    }

    @CalledByNative
    private MotionEventSynthesizer createMotionEventSynthesizer() {
        return new MotionEventSynthesizer(this);
    }

    @CalledByNative
    private PopupTouchHandleDrawable createPopupTouchHandleDrawable() {
        if (this.mTouchHandleDelegate == null) {
            this.mTouchHandleDelegate = new PopupTouchHandleDrawable.PopupTouchHandleDrawableDelegate(){

                @Override
                public View getParent() {
                    return ContentViewCore.this.getContainerView();
                }

                @Override
                public PositionObserver getParentPositionObserver() {
                    return ContentViewCore.this.mPositionObserver;
                }

                @Override
                public boolean onTouchHandleEvent(MotionEvent event) {
                    boolean isTouchHandleEvent = true;
                    return ContentViewCore.this.onTouchEventImpl(event, true);
                }

                @Override
                public boolean isScrollInProgress() {
                    return ContentViewCore.this.isScrollInProgress();
                }
            };
        }
        return new PopupTouchHandleDrawable(this.mTouchHandleDelegate);
    }

    public void setOverscrollRefreshHandler(OverscrollRefreshHandler handler) {
        assert (this.mOverscrollRefreshHandler == null || handler == null);
        this.mOverscrollRefreshHandler = handler;
    }

    @CalledByNative
    private boolean onOverscrollRefreshStart() {
        if (this.mOverscrollRefreshHandler == null) {
            return false;
        }
        return this.mOverscrollRefreshHandler.start();
    }

    @CalledByNative
    private void onOverscrollRefreshUpdate(float delta) {
        if (this.mOverscrollRefreshHandler != null) {
            this.mOverscrollRefreshHandler.pull(delta);
        }
    }

    @CalledByNative
    private void onOverscrollRefreshRelease(boolean allowRefresh) {
        if (this.mOverscrollRefreshHandler != null) {
            this.mOverscrollRefreshHandler.release(allowRefresh);
        }
    }

    @CalledByNative
    private void onOverscrollRefreshReset() {
        if (this.mOverscrollRefreshHandler != null) {
            this.mOverscrollRefreshHandler.reset();
        }
    }

    @CalledByNative
    private void onSelectionChanged(String text) {
        this.mLastSelectedText = text;
        if (this.mContextualSearchClient != null) {
            this.mContextualSearchClient.onSelectionChanged(text);
        }
    }

    @CalledByNative
    private void showPastePopupWithFeedback(int x, int y) {
        if (this.showPastePopup(x, y)) {
            this.mContainerView.performHapticFeedback(0);
        }
    }

    private boolean isPastePopupShowing() {
        if (this.supportsFloatingActionMode()) {
            return this.mActionMode != null;
        }
        return this.mPastePopupMenu != null && this.mPastePopupMenu.isShowing();
    }

    private boolean showPastePopup(int x, int y) {
        if (!this.mHasInsertion || !this.canPaste()) {
            return false;
        }
        if (this.supportsFloatingActionMode()) {
            if (this.mActionMode == null) {
                this.showSelectActionMode(false);
            } else {
                this.invalidateActionModeContentRect();
            }
        }
        if (!this.supportsFloatingActionMode()) {
            assert (this.mActionMode == null);
            float contentOffsetYPix = this.mRenderCoordinates.getContentOffsetYPix();
            this.getPastePopup().showAt(x, (int)((float)y + contentOffsetYPix));
        }
        return true;
    }

    private void hidePastePopup() {
        if (!this.mHasInsertion) {
            return;
        }
        if (this.supportsFloatingActionMode()) {
            this.mUnselectAllOnActionModeDismiss = false;
            this.hideSelectActionMode();
            return;
        }
        if (this.mPastePopupMenu == null) {
            return;
        }
        this.mPastePopupMenu.hide();
    }

    private PastePopupMenu getPastePopup() {
        assert (!this.supportsFloatingActionMode());
        if (this.mPastePopupMenu == null) {
            this.mPastePopupMenu = new PastePopupMenu((View)this.getContainerView(), new PastePopupMenu.PastePopupMenuDelegate(){

                @Override
                public void paste() {
                    ContentViewCore.this.mWebContents.paste();
                    ContentViewCore.this.dismissTextHandles();
                }
            });
        }
        return this.mPastePopupMenu;
    }

    @VisibleForTesting
    public PastePopupMenu getPastePopupForTest() {
        return this.getPastePopup();
    }

    private boolean canPaste() {
        if (!this.mFocusedNodeEditable) {
            return false;
        }
        return ((ClipboardManager)this.mContext.getSystemService("clipboard")).hasPrimaryClip();
    }

    @CalledByNative
    private void onRenderProcessChange() {
        this.attachImeAdapter();
        this.mSystemCaptioningBridge.syncToListener(this);
    }

    public void attachImeAdapter() {
        if (this.mImeAdapter != null && this.mNativeContentViewCore != 0L) {
            this.mImeAdapter.attach(this.nativeGetNativeImeAdapter(this.mNativeContentViewCore));
        }
    }

    @CalledByNative
    private boolean hasFocus() {
        if (!this.mContainerView.isFocusable()) {
            return true;
        }
        return this.mContainerView.hasFocus();
    }

    public boolean canZoomIn() {
        float zoomInExtent = this.mRenderCoordinates.getMaxPageScaleFactor() - this.mRenderCoordinates.getPageScaleFactor();
        return zoomInExtent > 0.007f;
    }

    public boolean canZoomOut() {
        float zoomOutExtent = this.mRenderCoordinates.getPageScaleFactor() - this.mRenderCoordinates.getMinPageScaleFactor();
        return zoomOutExtent > 0.007f;
    }

    public boolean zoomIn() {
        if (!this.canZoomIn()) {
            return false;
        }
        return this.pinchByDelta(1.25f);
    }

    public boolean zoomOut() {
        if (!this.canZoomOut()) {
            return false;
        }
        return this.pinchByDelta(0.8f);
    }

    public boolean zoomReset() {
        if (!this.canZoomOut()) {
            return false;
        }
        return this.pinchByDelta(this.mRenderCoordinates.getMinPageScaleFactor() / this.mRenderCoordinates.getPageScaleFactor());
    }

    public boolean pinchByDelta(float delta) {
        if (this.mNativeContentViewCore == 0L) {
            return false;
        }
        long timeMs = SystemClock.uptimeMillis();
        int xPix = this.getViewportWidthPix() / 2;
        int yPix = this.getViewportHeightPix() / 2;
        this.nativePinchBegin(this.mNativeContentViewCore, timeMs, xPix, yPix);
        this.nativePinchBy(this.mNativeContentViewCore, timeMs, xPix, yPix, delta);
        this.nativePinchEnd(this.mNativeContentViewCore, timeMs);
        return true;
    }

    public void invokeZoomPicker() {
        this.mZoomControlsDelegate.invokeZoomPicker();
    }

    public void setAllowJavascriptInterfacesInspection(boolean allow) {
        this.nativeSetAllowJavascriptInterfacesInspection(this.mNativeContentViewCore, allow);
    }

    public Map<String, Pair<Object, Class>> getJavascriptInterfaces() {
        return this.mJavaScriptInterfaces;
    }

    public void addJavascriptInterface(Object object, String name) {
        this.addPossiblyUnsafeJavascriptInterface(object, name, JavascriptInterface.class);
    }

    public void addPossiblyUnsafeJavascriptInterface(Object object, String name, Class<? extends Annotation> requiredAnnotation) {
        if (this.mNativeContentViewCore != 0L && object != null) {
            this.mJavaScriptInterfaces.put(name, (Pair<Object, Class>)new Pair(object, requiredAnnotation));
            this.nativeAddJavascriptInterface(this.mNativeContentViewCore, object, name, requiredAnnotation);
        }
    }

    public void removeJavascriptInterface(String name) {
        this.mJavaScriptInterfaces.remove(name);
        if (this.mNativeContentViewCore != 0L) {
            this.nativeRemoveJavascriptInterface(this.mNativeContentViewCore, name);
        }
    }

    @VisibleForTesting
    public float getScale() {
        return this.mRenderCoordinates.getPageScaleFactor();
    }

    @CalledByNative
    private void startContentIntent(String contentUrl) {
        this.getContentViewClient().onStartContentIntent(this.getContext(), contentUrl);
    }

    public void onAccessibilityStateChanged(boolean enabled) {
        this.setAccessibilityState(enabled);
    }

    public boolean supportsAccessibilityAction(int action) {
        return this.mAccessibilityInjector.supportsAccessibilityAction(action);
    }

    public boolean performAccessibilityAction(int action, Bundle arguments) {
        if (this.mAccessibilityInjector.supportsAccessibilityAction(action)) {
            return this.mAccessibilityInjector.performAccessibilityAction(action, arguments);
        }
        return false;
    }

    public void setBrowserAccessibilityManager(BrowserAccessibilityManager manager) {
        this.mBrowserAccessibilityManager = manager;
        if (this.mBrowserAccessibilityManager != null && this.mRenderCoordinates.hasFrameInfo()) {
            this.mBrowserAccessibilityManager.notifyFrameInfoInitialized();
        }
    }

    public BrowserAccessibilityManager getBrowserAccessibilityManager() {
        return this.mBrowserAccessibilityManager;
    }

    public AccessibilityNodeProvider getAccessibilityNodeProvider() {
        if (this.mBrowserAccessibilityManager != null) {
            return this.mBrowserAccessibilityManager.getAccessibilityNodeProvider();
        }
        if (this.mNativeAccessibilityAllowed && !this.mNativeAccessibilityEnabled && this.mNativeContentViewCore != 0L && Build.VERSION.SDK_INT >= 16) {
            this.mNativeAccessibilityEnabled = true;
            this.nativeSetAccessibilityEnabled(this.mNativeContentViewCore, true);
        }
        return null;
    }

    public void onProvideVirtualStructure(ViewStructure structure) {
        if (this.getWebContents().isIncognito()) {
            structure.setChildCount(0);
            return;
        }
        structure.setChildCount(1);
        final ViewStructure viewRoot = structure.asyncNewChild(0);
        this.getWebContents().requestAccessibilitySnapshot(new AccessibilitySnapshotCallback(){

            @Override
            public void onAccessibilitySnapshot(AccessibilitySnapshotNode root) {
                viewRoot.setClassName("");
                if (root == null) {
                    viewRoot.asyncCommit();
                    return;
                }
                ContentViewCore.this.createVirtualStructure(viewRoot, root, 0, 0);
            }
        }, this.mRenderCoordinates.getContentOffsetYPix(), this.mRenderCoordinates.getScrollXPix());
    }

    private void createVirtualStructure(ViewStructure viewNode, AccessibilitySnapshotNode node, int parentX, int parentY) {
        viewNode.setClassName(node.className);
        viewNode.setText((CharSequence)node.text);
        viewNode.setDimens(node.x - parentX - node.scrollX, node.y - parentY, 0, node.scrollY, node.width, node.height);
        viewNode.setChildCount(node.children.size());
        if (node.hasStyle) {
            int style2 = (node.bold ? 1 : 0) | (node.italic ? 2 : 0) | (node.underline ? 4 : 0) | (node.lineThrough ? 8 : 0);
            viewNode.setTextStyle(node.textSize, node.color, node.bgcolor, style2);
        }
        for (int i = 0; i < node.children.size(); ++i) {
            this.createVirtualStructure(viewNode.asyncNewChild(i), node.children.get(i), node.x, node.y);
        }
        viewNode.asyncCommit();
    }

    @Override
    @TargetApi(value=19)
    public void onSystemCaptioningChanged(TextTrackSettings settings) {
        if (this.mNativeContentViewCore == 0L) {
            return;
        }
        this.nativeSetTextTrackSettings(this.mNativeContentViewCore, settings.getTextTracksEnabled(), settings.getTextTrackBackgroundColor(), settings.getTextTrackFontFamily(), settings.getTextTrackFontStyle(), settings.getTextTrackFontVariant(), settings.getTextTrackTextColor(), settings.getTextTrackTextShadow(), settings.getTextTrackTextSize());
    }

    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        this.mAccessibilityInjector.onInitializeAccessibilityNodeInfo(info);
    }

    @TargetApi(value=15)
    public void onInitializeAccessibilityEvent(AccessibilityEvent event) {
        event.setClassName((CharSequence)this.getClass().getName());
        event.setScrollX(this.mRenderCoordinates.getScrollXPixInt());
        event.setScrollY(this.mRenderCoordinates.getScrollYPixInt());
        int maxScrollXPix = Math.max(0, this.mRenderCoordinates.getMaxHorizontalScrollPixInt());
        int maxScrollYPix = Math.max(0, this.mRenderCoordinates.getMaxVerticalScrollPixInt());
        event.setScrollable(maxScrollXPix > 0 || maxScrollYPix > 0);
        if (Build.VERSION.SDK_INT >= 15) {
            event.setMaxScrollX(maxScrollXPix);
            event.setMaxScrollY(maxScrollYPix);
        }
    }

    public boolean isDeviceAccessibilityScriptInjectionEnabled() {
        try {
            if (Build.VERSION.SDK_INT >= 16 && !CommandLine.getInstance().hasSwitch("enable-accessibility-script-injection")) {
                return false;
            }
            if (!this.mContentViewClient.isJavascriptEnabled()) {
                return false;
            }
            int result = this.getContext().checkCallingOrSelfPermission("android.permission.INTERNET");
            if (result != 0) {
                return false;
            }
            Field field = Settings.Secure.class.getField("ACCESSIBILITY_SCRIPT_INJECTION");
            field.setAccessible(true);
            String accessibilityScriptInjection = (String)field.get(null);
            ContentResolver contentResolver = this.getContext().getContentResolver();
            if (this.mAccessibilityScriptInjectionObserver == null) {
                ContentObserver contentObserver = new ContentObserver(new Handler()){

                    public void onChange(boolean selfChange, Uri uri) {
                        ContentViewCore.this.setAccessibilityState(ContentViewCore.this.mAccessibilityManager.isEnabled());
                    }
                };
                contentResolver.registerContentObserver(Settings.Secure.getUriFor((String)accessibilityScriptInjection), false, contentObserver);
                this.mAccessibilityScriptInjectionObserver = contentObserver;
            }
            return Settings.Secure.getInt((ContentResolver)contentResolver, (String)accessibilityScriptInjection, (int)0) == 1;
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return false;
    }

    public boolean isInjectingAccessibilityScript() {
        return this.mAccessibilityInjector.accessibilityIsAvailable();
    }

    public boolean isTouchExplorationEnabled() {
        return this.mTouchExplorationEnabled;
    }

    public void setAccessibilityState(boolean state) {
        if (!state) {
            this.setInjectedAccessibility(false);
            this.mNativeAccessibilityAllowed = false;
            this.mTouchExplorationEnabled = false;
        } else {
            boolean useScriptInjection = this.isDeviceAccessibilityScriptInjectionEnabled();
            this.setInjectedAccessibility(useScriptInjection);
            this.mNativeAccessibilityAllowed = !useScriptInjection;
            this.mTouchExplorationEnabled = this.mAccessibilityManager.isTouchExplorationEnabled();
        }
    }

    public void setInjectedAccessibility(boolean enabled) {
        this.mAccessibilityInjector.addOrRemoveAccessibilityApisIfNecessary();
        this.mAccessibilityInjector.setScriptEnabled(enabled);
    }

    public void stopCurrentAccessibilityNotifications() {
        this.mAccessibilityInjector.onPageLostFocus();
    }

    public boolean shouldSetAccessibilityFocusOnPageLoad() {
        return this.mShouldSetAccessibilityFocusOnPageLoad;
    }

    public void setShouldSetAccessibilityFocusOnPageLoad(boolean on) {
        this.mShouldSetAccessibilityFocusOnPageLoad = on;
    }

    public RenderCoordinates getRenderCoordinates() {
        return this.mRenderCoordinates;
    }

    public boolean getIsMobileOptimizedHint() {
        return this.mIsMobileOptimizedHint;
    }

    @CalledByNative
    private static Rect createRect(int x, int y, int right, int bottom) {
        return new Rect(x, y, right, bottom);
    }

    public void extractSmartClipData(int x, int y, int width, int height) {
        if (this.mNativeContentViewCore != 0L) {
            this.nativeExtractSmartClipData(this.mNativeContentViewCore, x += this.mSmartClipOffsetX, y += this.mSmartClipOffsetY, width, height);
        }
    }

    public void setSmartClipOffsets(int offsetX, int offsetY) {
        this.mSmartClipOffsetX = offsetX;
        this.mSmartClipOffsetY = offsetY;
    }

    @CalledByNative
    private void onSmartClipDataExtracted(String text, String html, Rect clipRect) {
        float deviceScale = this.mRenderCoordinates.getDeviceScaleFactor();
        int offsetXInDp = (int)((float)this.mSmartClipOffsetX / deviceScale);
        int offsetYInDp = (int)((float)this.mSmartClipOffsetY / deviceScale);
        clipRect.offset(-offsetXInDp, -offsetYInDp);
        if (this.mSmartClipDataListener != null) {
            this.mSmartClipDataListener.onSmartClipDataExtracted(text, html, clipRect);
        }
    }

    public void setSmartClipDataListener(SmartClipDataListener listener) {
        this.mSmartClipDataListener = listener;
    }

    public void setBackgroundOpaque(boolean opaque) {
        if (this.mNativeContentViewCore != 0L) {
            this.nativeSetBackgroundOpaque(this.mNativeContentViewCore, opaque);
        }
    }

    private boolean offerLongPressToEmbedder() {
        return this.mContainerView.performLongClick();
    }

    private void resetScrollInProgress() {
        if (!this.isScrollInProgress()) {
            return;
        }
        boolean touchScrollInProgress = this.mTouchScrollInProgress;
        int potentiallyActiveFlingCount = this.mPotentiallyActiveFlingCount;
        this.mTouchScrollInProgress = false;
        this.mPotentiallyActiveFlingCount = 0;
        if (touchScrollInProgress) {
            this.updateGestureStateListener(8);
        }
        if (potentiallyActiveFlingCount > 0) {
            this.updateGestureStateListener(11);
        }
    }

    ContentVideoViewClient getContentVideoViewClient() {
        return this.getContentViewClient().getContentVideoViewClient();
    }

    @CalledByNative
    private boolean shouldBlockMediaRequest(String url) {
        return this.getContentViewClient().shouldBlockMediaRequest(url);
    }

    @CalledByNative
    private void onNativeFlingStopped() {
        this.mTouchScrollInProgress = false;
        if (this.mPotentiallyActiveFlingCount <= 0) {
            return;
        }
        --this.mPotentiallyActiveFlingCount;
        this.updateGestureStateListener(11);
    }

    @Override
    public void onScreenOrientationChanged(int orientation) {
        this.sendOrientationChangeEvent(orientation);
    }

    public void setFullscreenRequiredForOrientationLock(boolean value) {
        this.mFullscreenRequiredForOrientationLock = value;
    }

    @CalledByNative
    private boolean isFullscreenRequiredForOrientationLock() {
        return this.mFullscreenRequiredForOrientationLock;
    }

    public void setContextualSearchClient(ContextualSearchClient contextualSearchClient) {
        this.mContextualSearchClient = contextualSearchClient;
    }

    private native long nativeInit(WebContents var1, ViewAndroidDelegate var2, long var3, HashSet<Object> var5);

    private static native ContentViewCore nativeFromWebContentsAndroid(WebContents var0);

    private native WebContents nativeGetWebContentsAndroid(long var1);

    private native WindowAndroid nativeGetJavaWindowAndroid(long var1);

    private native void nativeOnJavaContentViewCoreDestroyed(long var1);

    private native void nativeSetFocus(long var1, boolean var3);

    private native void nativeSendOrientationChangeEvent(long var1, int var3);

    private native boolean nativeOnTouchEvent(long var1, MotionEvent var3, long var4, int var6, int var7, int var8, int var9, float var10, float var11, float var12, float var13, int var14, int var15, float var16, float var17, float var18, float var19, float var20, float var21, float var22, float var23, int var24, int var25, int var26, int var27, boolean var28);

    private native int nativeSendMouseMoveEvent(long var1, long var3, float var5, float var6);

    private native int nativeSendMouseWheelEvent(long var1, long var3, float var5, float var6, float var7, float var8);

    private native void nativeScrollBegin(long var1, long var3, float var5, float var6, float var7, float var8, boolean var9);

    private native void nativeScrollEnd(long var1, long var3);

    private native void nativeScrollBy(long var1, long var3, float var5, float var6, float var7, float var8);

    private native void nativeFlingStart(long var1, long var3, float var5, float var6, float var7, float var8, boolean var9);

    private native void nativeFlingCancel(long var1, long var3);

    private native void nativeSingleTap(long var1, long var3, float var5, float var6);

    private native void nativeDoubleTap(long var1, long var3, float var5, float var6);

    private native void nativeLongPress(long var1, long var3, float var5, float var6);

    private native void nativePinchBegin(long var1, long var3, float var5, float var6);

    private native void nativePinchEnd(long var1, long var3);

    private native void nativePinchBy(long var1, long var3, float var5, float var6, float var7);

    private native void nativeSelectBetweenCoordinates(long var1, float var3, float var4, float var5, float var6);

    private native void nativeMoveCaret(long var1, float var3, float var4);

    private native void nativeDismissTextHandles(long var1);

    private native void nativeSetTextHandlesTemporarilyHidden(long var1, boolean var3);

    private native void nativeResetGestureDetection(long var1);

    private native void nativeSetDoubleTapSupportEnabled(long var1, boolean var3);

    private native void nativeSetMultiTouchZoomSupportEnabled(long var1, boolean var3);

    private native void nativeSelectPopupMenuItems(long var1, long var3, int[] var5);

    private native long nativeGetNativeImeAdapter(long var1);

    private native int nativeGetCurrentRenderProcessId(long var1);

    private native void nativeSetAllowJavascriptInterfacesInspection(long var1, boolean var3);

    private native void nativeAddJavascriptInterface(long var1, Object var3, String var4, Class var5);

    private native void nativeRemoveJavascriptInterface(long var1, String var3);

    private native void nativeWasResized(long var1);

    private native void nativeSetAccessibilityEnabled(long var1, boolean var3);

    private native void nativeSetTextTrackSettings(long var1, boolean var3, String var4, String var5, String var6, String var7, String var8, String var9, String var10);

    private native void nativeExtractSmartClipData(long var1, int var3, int var4, int var5, int var6);

    private native void nativeSetBackgroundOpaque(long var1, boolean var3);

    private native void nativeSetDrawsContent(long var1, boolean var3);

    public static interface SmartClipDataListener {
        public void onSmartClipDataExtracted(String var1, String var2, Rect var3);
    }

    public static interface ZoomControlsDelegate {
        public void invokeZoomPicker();

        public void dismissZoomPicker();

        public void updateZoomControls();
    }

    public static interface InternalAccessDelegate {
        public boolean drawChild(Canvas var1, View var2, long var3);

        public boolean super_onKeyUp(int var1, KeyEvent var2);

        public boolean super_dispatchKeyEventPreIme(KeyEvent var1);

        public boolean super_dispatchKeyEvent(KeyEvent var1);

        public boolean super_onGenericMotionEvent(MotionEvent var1);

        public void super_onConfigurationChanged(Configuration var1);

        public void onScrollChanged(int var1, int var2, int var3, int var4);

        public boolean awakenScrollBars();

        public boolean super_awakenScrollBars(int var1, boolean var2);
    }

    private static class ContentViewWebContentsObserver
    extends WebContentsObserver {
        private final WeakReference<ContentViewCore> mWeakContentViewCore;

        ContentViewWebContentsObserver(ContentViewCore contentViewCore) {
            super(contentViewCore.getWebContents());
            this.mWeakContentViewCore = new WeakReference<ContentViewCore>(contentViewCore);
        }

        @Override
        public void didStartLoading(String url) {
            ContentViewCore contentViewCore = (ContentViewCore)this.mWeakContentViewCore.get();
            if (contentViewCore == null) {
                return;
            }
            contentViewCore.mAccessibilityInjector.onPageLoadStarted();
        }

        @Override
        public void didStopLoading(String url) {
            ContentViewCore contentViewCore = (ContentViewCore)this.mWeakContentViewCore.get();
            if (contentViewCore == null) {
                return;
            }
            contentViewCore.mAccessibilityInjector.onPageLoadStopped();
        }

        @Override
        public void didFailLoad(boolean isProvisionalLoad, boolean isMainFrame, int errorCode, String description, String failingUrl, boolean wasIgnoredByHandler) {
            if (isProvisionalLoad) {
                this.determinedProcessVisibility();
            }
        }

        @Override
        public void didNavigateMainFrame(String url, String baseUrl, boolean isNavigationToDifferentPage, boolean isFragmentNavigation, int statusCode) {
            if (!isNavigationToDifferentPage) {
                return;
            }
            this.resetPopupsAndInput();
        }

        @Override
        public void renderProcessGone(boolean wasOomProtected) {
            this.resetPopupsAndInput();
        }

        @Override
        public void navigationEntryCommitted() {
            this.determinedProcessVisibility();
        }

        private void resetPopupsAndInput() {
            ContentViewCore contentViewCore = (ContentViewCore)this.mWeakContentViewCore.get();
            if (contentViewCore == null) {
                return;
            }
            contentViewCore.mIsMobileOptimizedHint = false;
            contentViewCore.hidePopupsAndClearSelection();
            contentViewCore.resetScrollInProgress();
        }

        private void determinedProcessVisibility() {
            ContentViewCore contentViewCore = (ContentViewCore)this.mWeakContentViewCore.get();
            if (contentViewCore == null) {
                return;
            }
            ChildProcessLauncher.determinedVisibility(contentViewCore.getCurrentRenderProcessId());
        }
    }

    private static class ContentViewAndroidDelegate
    implements ViewAndroidDelegate {
        private final RenderCoordinates mRenderCoordinates;
        private WeakReference<ViewGroup> mCurrentContainerView;
        private Map<View, Position> mAnchorViews = new LinkedHashMap<View, Position>();

        ContentViewAndroidDelegate(ViewGroup containerView, RenderCoordinates renderCoordinates) {
            this.mRenderCoordinates = renderCoordinates;
            this.mCurrentContainerView = new WeakReference<ViewGroup>(containerView);
        }

        @Override
        public View acquireAnchorView() {
            ViewGroup containerView = (ViewGroup)this.mCurrentContainerView.get();
            if (containerView == null) {
                return null;
            }
            View anchorView = new View(containerView.getContext());
            this.mAnchorViews.put(anchorView, null);
            containerView.addView(anchorView);
            return anchorView;
        }

        @Override
        public void setAnchorViewPosition(View view, float x, float y, float width, float height) {
            this.mAnchorViews.put(view, new Position(x, y, width, height));
            this.doSetAnchorViewPosition(view, x, y, width, height);
        }

        private void doSetAnchorViewPosition(View view, float x, float y, float width, float height) {
            if (view.getParent() == null) {
                return;
            }
            ViewGroup containerView = (ViewGroup)this.mCurrentContainerView.get();
            if (containerView == null) {
                return;
            }
            assert (view.getParent() == containerView);
            float scale = (float)DeviceDisplayInfo.create(containerView.getContext()).getDIPScale();
            int leftMargin = Math.round(x * scale);
            int topMargin = Math.round(this.mRenderCoordinates.getContentOffsetYPix() + y * scale);
            int scaledWidth = Math.round(width * scale);
            if (containerView instanceof FrameLayout) {
                int startMargin = ApiCompatibilityUtils.isLayoutRtl((View)containerView) ? containerView.getMeasuredWidth() - Math.round((width + x) * scale) : leftMargin;
                if (scaledWidth + startMargin > containerView.getWidth()) {
                    scaledWidth = containerView.getWidth() - startMargin;
                }
                FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(scaledWidth, Math.round(height * scale));
                ApiCompatibilityUtils.setMarginStart((ViewGroup.MarginLayoutParams)lp, startMargin);
                lp.topMargin = topMargin;
                view.setLayoutParams((ViewGroup.LayoutParams)lp);
            } else if (containerView instanceof AbsoluteLayout) {
                AbsoluteLayout.LayoutParams lp = new AbsoluteLayout.LayoutParams(scaledWidth, (int)(height * scale), leftMargin += this.mRenderCoordinates.getScrollXPixInt(), topMargin += this.mRenderCoordinates.getScrollYPixInt());
                view.setLayoutParams((ViewGroup.LayoutParams)lp);
            } else {
                Log.e(ContentViewCore.TAG, "Unknown layout %s", containerView.getClass().getName());
            }
        }

        @Override
        public void releaseAnchorView(View anchorView) {
            this.mAnchorViews.remove(anchorView);
            ViewGroup containerView = (ViewGroup)this.mCurrentContainerView.get();
            if (containerView != null) {
                containerView.removeView(anchorView);
            }
        }

        void updateCurrentContainerView(ViewGroup containerView) {
            ViewGroup oldContainerView = (ViewGroup)this.mCurrentContainerView.get();
            this.mCurrentContainerView = new WeakReference<ViewGroup>(containerView);
            for (Map.Entry<View, Position> entry : this.mAnchorViews.entrySet()) {
                View anchorView = entry.getKey();
                Position position = entry.getValue();
                if (oldContainerView != null) {
                    oldContainerView.removeView(anchorView);
                }
                containerView.addView(anchorView);
                if (position == null) continue;
                this.doSetAnchorViewPosition(anchorView, position.mX, position.mY, position.mWidth, position.mHeight);
            }
        }

        @VisibleForTesting
        private static class Position {
            private final float mX;
            private final float mY;
            private final float mWidth;
            private final float mHeight;

            public Position(float x, float y, float width, float height) {
                this.mX = x;
                this.mY = y;
                this.mWidth = width;
                this.mHeight = height;
            }
        }
    }
}

