/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;
import org.chromium.content.browser.ContentReadbackHandler;
import org.chromium.content.browser.ContentViewCore;
import org.chromium.ui.base.WindowAndroid;

@JNINamespace(value="content")
public class ContentViewRenderView
extends FrameLayout {
    private long mNativeContentViewRenderView;
    private SurfaceHolder.Callback mSurfaceCallback;
    private final SurfaceView mSurfaceView;
    protected ContentViewCore mContentViewCore;
    private TextureView mTextureView;
    private Surface mSurface;
    private CompositingSurfaceType mCompositingSurfaceType;
    private ContentReadbackHandler mContentReadbackHandler;
    private FirstRenderedFrameListener mFirstRenderedFrameListener;
    private boolean mFirstFrameReceived;

    private void initTextureView(Context context) {
        this.mTextureView = new TextureView(context);
        this.mTextureView.setBackgroundColor(-1);
        this.mTextureView.setSurfaceTextureListener(new TextureView.SurfaceTextureListener(){

            public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int width, int height) {
                assert (ContentViewRenderView.this.mNativeContentViewRenderView != 0L);
                ContentViewRenderView.this.mSurface = new Surface(surfaceTexture);
                ContentViewRenderView.this.nativeSurfaceCreated(ContentViewRenderView.this.mNativeContentViewRenderView);
                this.onSurfaceTextureSizeChanged(surfaceTexture, width, height);
                ContentViewRenderView.this.onReadyToRender();
            }

            public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int width, int height) {
                assert (ContentViewRenderView.this.mNativeContentViewRenderView != 0L && ContentViewRenderView.this.mSurface != null);
                assert (surfaceTexture == ContentViewRenderView.this.mTextureView.getSurfaceTexture());
                assert (ContentViewRenderView.this.mSurface != null);
                int format = 1;
                ContentViewRenderView.this.nativeSurfaceChanged(ContentViewRenderView.this.mNativeContentViewRenderView, format, width, height, ContentViewRenderView.this.mSurface);
                if (ContentViewRenderView.this.mContentViewCore != null) {
                    ContentViewRenderView.this.mContentViewCore.onPhysicalBackingSizeChanged(width, height);
                }
            }

            public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
                assert (ContentViewRenderView.this.mNativeContentViewRenderView != 0L);
                ContentViewRenderView.this.nativeSurfaceDestroyed(ContentViewRenderView.this.mNativeContentViewRenderView);
                ContentViewRenderView.this.mSurface.release();
                ContentViewRenderView.this.mSurface = null;
                return true;
            }

            public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
            }
        });
    }

    public ContentViewRenderView(Context context) {
        this(context, CompositingSurfaceType.SURFACE_VIEW);
    }

    public ContentViewRenderView(Context context, CompositingSurfaceType surfaceType) {
        super(context);
        this.mCompositingSurfaceType = surfaceType;
        if (surfaceType == CompositingSurfaceType.TEXTURE_VIEW) {
            this.initTextureView(context);
            this.addView((View)this.mTextureView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            this.mSurfaceView = null;
            this.mSurfaceCallback = null;
            return;
        }
        this.mSurfaceView = this.createSurfaceView(this.getContext());
        this.mSurfaceView.setZOrderMediaOverlay(true);
        this.setSurfaceViewBackgroundColor(-1);
        this.addView((View)this.mSurfaceView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.mSurfaceView.setVisibility(8);
    }

    public void onNativeLibraryLoaded(WindowAndroid rootWindow) {
        assert (rootWindow != null);
        this.mNativeContentViewRenderView = this.nativeInit(rootWindow.getNativePointer());
        assert (this.mNativeContentViewRenderView != 0L);
        this.mContentReadbackHandler = new ContentReadbackHandler(){

            @Override
            protected boolean readyForReadback() {
                return ContentViewRenderView.this.mNativeContentViewRenderView != 0L && ContentViewRenderView.this.mContentViewCore != null;
            }
        };
        this.mContentReadbackHandler.initNativeContentReadbackHandler();
        if (this.mCompositingSurfaceType == CompositingSurfaceType.TEXTURE_VIEW) {
            return;
        }
        assert (!this.mSurfaceView.getHolder().getSurface().isValid()) : "Surface created before native library loaded.";
        this.mSurfaceCallback = new SurfaceHolder.Callback(){

            public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
                assert (ContentViewRenderView.this.mNativeContentViewRenderView != 0L);
                ContentViewRenderView.this.nativeSurfaceChanged(ContentViewRenderView.this.mNativeContentViewRenderView, format, width, height, holder.getSurface());
                if (ContentViewRenderView.this.mContentViewCore != null) {
                    ContentViewRenderView.this.mContentViewCore.onPhysicalBackingSizeChanged(width, height);
                }
            }

            public void surfaceCreated(SurfaceHolder holder) {
                assert (ContentViewRenderView.this.mNativeContentViewRenderView != 0L);
                ContentViewRenderView.this.nativeSurfaceCreated(ContentViewRenderView.this.mNativeContentViewRenderView);
                ContentViewRenderView.this.onReadyToRender();
            }

            public void surfaceDestroyed(SurfaceHolder holder) {
                assert (ContentViewRenderView.this.mNativeContentViewRenderView != 0L);
                ContentViewRenderView.this.nativeSurfaceDestroyed(ContentViewRenderView.this.mNativeContentViewRenderView);
            }
        };
        this.mSurfaceView.getHolder().addCallback(this.mSurfaceCallback);
        this.mSurfaceView.setVisibility(0);
    }

    public ContentReadbackHandler getContentReadbackHandler() {
        return this.mContentReadbackHandler;
    }

    public void setSurfaceViewBackgroundColor(int color2) {
        if (this.mSurfaceView != null) {
            this.mSurfaceView.setBackgroundColor(color2);
        }
    }

    public SurfaceView getSurfaceView() {
        return this.mSurfaceView;
    }

    public void destroy() {
        this.mContentReadbackHandler.destroy();
        this.mContentReadbackHandler = null;
        if (this.mCompositingSurfaceType == CompositingSurfaceType.TEXTURE_VIEW) {
            this.mTextureView.setSurfaceTextureListener(null);
            if (this.mSurface != null) {
                this.mSurface.release();
                this.mSurface = null;
            }
        } else {
            this.mSurfaceView.getHolder().removeCallback(this.mSurfaceCallback);
        }
        this.nativeDestroy(this.mNativeContentViewRenderView);
        this.mNativeContentViewRenderView = 0L;
    }

    public void setCurrentContentViewCore(ContentViewCore contentViewCore) {
        assert (this.mNativeContentViewRenderView != 0L);
        this.mContentViewCore = contentViewCore;
        if (this.mContentViewCore != null) {
            this.mContentViewCore.onPhysicalBackingSizeChanged(this.getWidth(), this.getHeight());
            this.nativeSetCurrentContentViewCore(this.mNativeContentViewRenderView, this.mContentViewCore.getNativeContentViewCore());
        } else {
            this.nativeSetCurrentContentViewCore(this.mNativeContentViewRenderView, 0L);
        }
    }

    public void setNeedsComposite() {
        if (this.mNativeContentViewRenderView == 0L) {
            return;
        }
        this.nativeSetNeedsComposite(this.mNativeContentViewRenderView);
    }

    protected void onReadyToRender() {
    }

    protected SurfaceView createSurfaceView(Context context) {
        return new SurfaceView(context);
    }

    public void registerFirstRenderedFrameListener(FirstRenderedFrameListener listener) {
        this.mFirstRenderedFrameListener = listener;
        if (this.mFirstFrameReceived && this.mFirstRenderedFrameListener != null) {
            this.mFirstRenderedFrameListener.onFirstFrameReceived();
        }
    }

    public boolean isInitialized() {
        return this.mSurfaceView.getHolder().getSurface() != null || this.mSurface != null;
    }

    public void setZOrderOnTop(boolean onTop) {
        if (this.mSurfaceView == null) {
            return;
        }
        this.mSurfaceView.setZOrderOnTop(onTop);
    }

    public void setOverlayVideoMode(boolean enabled) {
        if (this.mCompositingSurfaceType == CompositingSurfaceType.TEXTURE_VIEW) {
            this.nativeSetOverlayVideoMode(this.mNativeContentViewRenderView, enabled);
            return;
        }
        int format = enabled ? -3 : -1;
        this.mSurfaceView.getHolder().setFormat(format);
        this.nativeSetOverlayVideoMode(this.mNativeContentViewRenderView, enabled);
    }

    @CalledByNative
    protected void onCompositorLayout() {
    }

    @CalledByNative
    private void onSwapBuffersCompleted() {
        if (!this.mFirstFrameReceived && this.mContentViewCore != null && this.mContentViewCore.getWebContents().isReady()) {
            this.mFirstFrameReceived = true;
            if (this.mFirstRenderedFrameListener != null) {
                this.mFirstRenderedFrameListener.onFirstFrameReceived();
            }
        }
        if (this.mCompositingSurfaceType == CompositingSurfaceType.TEXTURE_VIEW) {
            return;
        }
        if (this.mSurfaceView.getBackground() != null) {
            this.post(new Runnable(){

                @Override
                public void run() {
                    ContentViewRenderView.this.mSurfaceView.setBackgroundResource(0);
                }
            });
        }
    }

    public long getUIResourceProvider() {
        return this.nativeGetUIResourceProvider(this.mNativeContentViewRenderView);
    }

    private native long nativeInit(long var1);

    private native long nativeGetUIResourceProvider(long var1);

    private native void nativeDestroy(long var1);

    private native void nativeSetCurrentContentViewCore(long var1, long var3);

    private native void nativeSurfaceCreated(long var1);

    private native void nativeSurfaceDestroyed(long var1);

    private native void nativeSurfaceChanged(long var1, int var3, int var4, int var5, Surface var6);

    private native void nativeSetOverlayVideoMode(long var1, boolean var3);

    private native void nativeSetNeedsComposite(long var1);

    public static interface FirstRenderedFrameListener {
        public void onFirstFrameReceived();
    }

    public static enum CompositingSurfaceType {
        SURFACE_VIEW,
        TEXTURE_VIEW;

    }
}

