/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Handler;
import android.os.HandlerThread;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.chromium.base.CalledByNative;
import org.chromium.base.CollectionUtil;
import org.chromium.base.JNINamespace;
import org.chromium.base.Log;
import org.chromium.base.ThreadUtils;
import org.chromium.base.VisibleForTesting;

@JNINamespace(value="content")
class DeviceSensors
implements SensorEventListener {
    private static final String TAG = "cr.DeviceSensors";
    private Thread mThread;
    private Handler mHandler;
    private final Context mAppContext;
    private final Object mHandlerLock = new Object();
    private long mNativePtr;
    private final Object mNativePtrLock = new Object();
    private float[] mMagneticFieldVector;
    private float[] mTruncatedRotationVector;
    private float[] mDeviceRotationMatrix;
    private double[] mRotationAngles;
    private SensorManagerProxy mSensorManagerProxy;
    private static DeviceSensors sSingleton;
    private static Object sSingletonLock;
    static final int DEVICE_ORIENTATION = 0;
    static final int DEVICE_MOTION = 1;
    static final int DEVICE_LIGHT = 2;
    static final Set<Integer> DEVICE_ORIENTATION_DEFAULT_SENSORS;
    static final Set<Integer> DEVICE_ORIENTATION_BACKUP_SENSORS;
    static final Set<Integer> DEVICE_MOTION_SENSORS;
    static final Set<Integer> DEVICE_LIGHT_SENSORS;
    @VisibleForTesting
    final Set<Integer> mActiveSensors = new HashSet<Integer>();
    Set<Integer> mDeviceOrientationSensors = DEVICE_ORIENTATION_DEFAULT_SENSORS;
    boolean mDeviceLightIsActive = false;
    boolean mDeviceMotionIsActive = false;
    boolean mDeviceOrientationIsActive = false;
    boolean mUseBackupOrientationSensors = false;

    protected DeviceSensors(Context context) {
        this.mAppContext = context.getApplicationContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public boolean start(long nativePtr, int eventType, int rateInMicroseconds) {
        boolean success = false;
        Object object = this.mNativePtrLock;
        synchronized (object) {
            switch (eventType) {
                case 0: {
                    success = this.registerSensors(this.mDeviceOrientationSensors, rateInMicroseconds, true);
                    if (!success) {
                        this.mDeviceOrientationSensors = DEVICE_ORIENTATION_BACKUP_SENSORS;
                        this.mUseBackupOrientationSensors = success = this.registerSensors(this.mDeviceOrientationSensors, rateInMicroseconds, true);
                    }
                    this.ensureRotationStructuresAllocated();
                    break;
                }
                case 1: {
                    success = this.registerSensors(DEVICE_MOTION_SENSORS, rateInMicroseconds, false);
                    break;
                }
                case 2: {
                    success = this.registerSensors(DEVICE_LIGHT_SENSORS, rateInMicroseconds, true);
                    break;
                }
                default: {
                    Log.e(TAG, "Unknown event type: %d", eventType);
                    return false;
                }
            }
            if (success) {
                this.mNativePtr = nativePtr;
                this.setEventTypeActive(eventType, true);
            }
            return success;
        }
    }

    @CalledByNative
    public int getNumberActiveDeviceMotionSensors() {
        HashSet<Integer> deviceMotionSensors = new HashSet<Integer>(DEVICE_MOTION_SENSORS);
        deviceMotionSensors.removeAll(this.mActiveSensors);
        return DEVICE_MOTION_SENSORS.size() - deviceMotionSensors.size();
    }

    @CalledByNative
    public boolean isUsingBackupSensorsForOrientation() {
        return this.mUseBackupOrientationSensors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public void stop(int eventType) {
        HashSet<Integer> sensorsToRemainActive = new HashSet<Integer>();
        Object object = this.mNativePtrLock;
        synchronized (object) {
            switch (eventType) {
                case 0: {
                    if (this.mDeviceMotionIsActive) {
                        sensorsToRemainActive.addAll(DEVICE_MOTION_SENSORS);
                    }
                    if (!this.mDeviceLightIsActive) break;
                    sensorsToRemainActive.addAll(DEVICE_LIGHT_SENSORS);
                    break;
                }
                case 1: {
                    if (this.mDeviceOrientationIsActive) {
                        sensorsToRemainActive.addAll(this.mDeviceOrientationSensors);
                    }
                    if (!this.mDeviceLightIsActive) break;
                    sensorsToRemainActive.addAll(DEVICE_LIGHT_SENSORS);
                    break;
                }
                case 2: {
                    if (this.mDeviceMotionIsActive) {
                        sensorsToRemainActive.addAll(DEVICE_MOTION_SENSORS);
                    }
                    if (!this.mDeviceOrientationIsActive) break;
                    sensorsToRemainActive.addAll(this.mDeviceOrientationSensors);
                    break;
                }
                default: {
                    Log.e(TAG, "Unknown event type: %d", eventType);
                    return;
                }
            }
            HashSet<Integer> sensorsToDeactivate = new HashSet<Integer>(this.mActiveSensors);
            sensorsToDeactivate.removeAll(sensorsToRemainActive);
            this.unregisterSensors(sensorsToDeactivate);
            this.setEventTypeActive(eventType, false);
            if (this.mActiveSensors.isEmpty()) {
                this.mNativePtr = 0L;
            }
        }
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    public void onSensorChanged(SensorEvent event) {
        this.sensorChanged(event.sensor.getType(), event.values);
    }

    @VisibleForTesting
    void sensorChanged(int type, float[] values) {
        switch (type) {
            case 1: {
                if (this.mDeviceMotionIsActive) {
                    this.gotAccelerationIncludingGravity(values[0], values[1], values[2]);
                }
                if (!this.mDeviceOrientationIsActive || !this.mUseBackupOrientationSensors) break;
                this.getOrientationFromGeomagneticVectors(values, this.mMagneticFieldVector);
                break;
            }
            case 10: {
                if (!this.mDeviceMotionIsActive) break;
                this.gotAcceleration(values[0], values[1], values[2]);
                break;
            }
            case 4: {
                if (!this.mDeviceMotionIsActive) break;
                this.gotRotationRate(values[0], values[1], values[2]);
                break;
            }
            case 11: {
                if (!this.mDeviceOrientationIsActive) break;
                if (values.length > 4) {
                    if (this.mTruncatedRotationVector == null) {
                        this.mTruncatedRotationVector = new float[4];
                    }
                    System.arraycopy(values, 0, this.mTruncatedRotationVector, 0, 4);
                    this.getOrientationFromRotationVector(this.mTruncatedRotationVector);
                    break;
                }
                this.getOrientationFromRotationVector(values);
                break;
            }
            case 2: {
                if (!this.mDeviceOrientationIsActive || !this.mUseBackupOrientationSensors) break;
                if (this.mMagneticFieldVector == null) {
                    this.mMagneticFieldVector = new float[3];
                }
                System.arraycopy(values, 0, this.mMagneticFieldVector, 0, this.mMagneticFieldVector.length);
                break;
            }
            case 5: {
                if (!this.mDeviceLightIsActive) break;
                this.gotLight(values[0]);
                break;
            }
            default: {
                return;
            }
        }
    }

    @VisibleForTesting
    public static double[] computeDeviceOrientationFromRotationMatrix(float[] matrixR, double[] values) {
        if (matrixR.length != 9) {
            return values;
        }
        if (matrixR[8] > 0.0f) {
            values[0] = Math.atan2(-matrixR[1], matrixR[4]);
            values[1] = Math.asin(matrixR[7]);
            values[2] = Math.atan2(-matrixR[6], matrixR[8]);
        } else if (matrixR[8] < 0.0f) {
            values[0] = Math.atan2(matrixR[1], -matrixR[4]);
            values[1] = -Math.asin(matrixR[7]);
            values[1] = values[1] + (values[1] >= 0.0 ? -Math.PI : Math.PI);
            values[2] = Math.atan2(matrixR[6], -matrixR[8]);
        } else if (matrixR[6] > 0.0f) {
            values[0] = Math.atan2(-matrixR[1], matrixR[4]);
            values[1] = Math.asin(matrixR[7]);
            values[2] = -1.5707963267948966;
        } else if (matrixR[6] < 0.0f) {
            values[0] = Math.atan2(matrixR[1], -matrixR[4]);
            values[1] = -Math.asin(matrixR[7]);
            values[1] = values[1] + (values[1] >= 0.0 ? -Math.PI : Math.PI);
            values[2] = -1.5707963267948966;
        } else {
            values[0] = Math.atan2(matrixR[3], matrixR[0]);
            values[1] = matrixR[7] > 0.0f ? 1.5707963267948966 : -1.5707963267948966;
            values[2] = 0.0;
        }
        if (values[0] < 0.0) {
            values[0] = values[0] + Math.PI * 2;
        }
        return values;
    }

    private void getOrientationFromRotationVector(float[] rotationVector) {
        SensorManager.getRotationMatrixFromVector((float[])this.mDeviceRotationMatrix, (float[])rotationVector);
        DeviceSensors.computeDeviceOrientationFromRotationMatrix(this.mDeviceRotationMatrix, this.mRotationAngles);
        this.gotOrientation(Math.toDegrees(this.mRotationAngles[0]), Math.toDegrees(this.mRotationAngles[1]), Math.toDegrees(this.mRotationAngles[2]));
    }

    private void getOrientationFromGeomagneticVectors(float[] acceleration, float[] magnetic) {
        if (acceleration == null || magnetic == null) {
            return;
        }
        if (!SensorManager.getRotationMatrix((float[])this.mDeviceRotationMatrix, null, (float[])acceleration, (float[])magnetic)) {
            return;
        }
        DeviceSensors.computeDeviceOrientationFromRotationMatrix(this.mDeviceRotationMatrix, this.mRotationAngles);
        this.gotOrientation(Math.toDegrees(this.mRotationAngles[0]), Math.toDegrees(this.mRotationAngles[1]), Math.toDegrees(this.mRotationAngles[2]));
    }

    private SensorManagerProxy getSensorManagerProxy() {
        if (this.mSensorManagerProxy != null) {
            return this.mSensorManagerProxy;
        }
        ThreadUtils.assertOnUiThread();
        SensorManager sensorManager = (SensorManager)this.mAppContext.getSystemService("sensor");
        if (sensorManager != null) {
            this.mSensorManagerProxy = new SensorManagerProxyImpl(sensorManager);
        }
        return this.mSensorManagerProxy;
    }

    @VisibleForTesting
    void setSensorManagerProxy(SensorManagerProxy sensorManagerProxy) {
        this.mSensorManagerProxy = sensorManagerProxy;
    }

    private void setEventTypeActive(int eventType, boolean value) {
        switch (eventType) {
            case 0: {
                this.mDeviceOrientationIsActive = value;
                return;
            }
            case 1: {
                this.mDeviceMotionIsActive = value;
                return;
            }
            case 2: {
                this.mDeviceLightIsActive = value;
                return;
            }
        }
    }

    private void ensureRotationStructuresAllocated() {
        if (this.mDeviceRotationMatrix == null) {
            this.mDeviceRotationMatrix = new float[9];
        }
        if (this.mRotationAngles == null) {
            this.mRotationAngles = new double[3];
        }
    }

    private boolean registerSensors(Set<Integer> sensorTypes, int rateInMicroseconds, boolean failOnMissingSensor) {
        HashSet<Integer> sensorsToActivate = new HashSet<Integer>(sensorTypes);
        sensorsToActivate.removeAll(this.mActiveSensors);
        boolean success = false;
        for (Integer sensorType : sensorsToActivate) {
            boolean result = this.registerForSensorType(sensorType, rateInMicroseconds);
            if (!result && failOnMissingSensor) {
                this.unregisterSensors(sensorsToActivate);
                return false;
            }
            if (!result) continue;
            this.mActiveSensors.add(sensorType);
            success = true;
        }
        return success;
    }

    private void unregisterSensors(Iterable<Integer> sensorTypes) {
        for (Integer sensorType : sensorTypes) {
            if (!this.mActiveSensors.contains(sensorType)) continue;
            this.getSensorManagerProxy().unregisterListener(this, sensorType);
            this.mActiveSensors.remove(sensorType);
        }
    }

    private boolean registerForSensorType(int type, int rateInMicroseconds) {
        SensorManagerProxy sensorManager = this.getSensorManagerProxy();
        if (sensorManager == null) {
            return false;
        }
        return sensorManager.registerListener(this, type, rateInMicroseconds, this.getHandler());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void gotOrientation(double alpha, double beta, double gamma) {
        Object object = this.mNativePtrLock;
        synchronized (object) {
            if (this.mNativePtr != 0L) {
                this.nativeGotOrientation(this.mNativePtr, alpha, beta, gamma);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void gotAcceleration(double x, double y, double z) {
        Object object = this.mNativePtrLock;
        synchronized (object) {
            if (this.mNativePtr != 0L) {
                this.nativeGotAcceleration(this.mNativePtr, x, y, z);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void gotAccelerationIncludingGravity(double x, double y, double z) {
        Object object = this.mNativePtrLock;
        synchronized (object) {
            if (this.mNativePtr != 0L) {
                this.nativeGotAccelerationIncludingGravity(this.mNativePtr, x, y, z);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void gotRotationRate(double alpha, double beta, double gamma) {
        Object object = this.mNativePtrLock;
        synchronized (object) {
            if (this.mNativePtr != 0L) {
                this.nativeGotRotationRate(this.mNativePtr, alpha, beta, gamma);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void gotLight(double value) {
        Object object = this.mNativePtrLock;
        synchronized (object) {
            if (this.mNativePtr != 0L) {
                this.nativeGotLight(this.mNativePtr, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Handler getHandler() {
        Object object = this.mHandlerLock;
        synchronized (object) {
            if (this.mHandler == null) {
                HandlerThread thread = new HandlerThread("DeviceMotionAndOrientation");
                thread.start();
                this.mHandler = new Handler(thread.getLooper());
            }
            return this.mHandler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    static DeviceSensors getInstance(Context appContext) {
        Object object = sSingletonLock;
        synchronized (object) {
            if (sSingleton == null) {
                sSingleton = new DeviceSensors(appContext);
            }
            return sSingleton;
        }
    }

    private native void nativeGotOrientation(long var1, double var3, double var5, double var7);

    private native void nativeGotAcceleration(long var1, double var3, double var5, double var7);

    private native void nativeGotAccelerationIncludingGravity(long var1, double var3, double var5, double var7);

    private native void nativeGotRotationRate(long var1, double var3, double var5, double var7);

    private native void nativeGotLight(long var1, double var3);

    static {
        sSingletonLock = new Object();
        DEVICE_ORIENTATION_DEFAULT_SENSORS = CollectionUtil.newHashSet(11);
        DEVICE_ORIENTATION_BACKUP_SENSORS = CollectionUtil.newHashSet(1, 2);
        DEVICE_MOTION_SENSORS = CollectionUtil.newHashSet(1, 10, 4);
        DEVICE_LIGHT_SENSORS = CollectionUtil.newHashSet(5);
    }

    static class SensorManagerProxyImpl
    implements SensorManagerProxy {
        private final SensorManager mSensorManager;

        SensorManagerProxyImpl(SensorManager sensorManager) {
            this.mSensorManager = sensorManager;
        }

        @Override
        public boolean registerListener(SensorEventListener listener, int sensorType, int rate, Handler handler) {
            List sensors = this.mSensorManager.getSensorList(sensorType);
            if (sensors.isEmpty()) {
                return false;
            }
            return this.mSensorManager.registerListener(listener, (Sensor)sensors.get(0), rate, handler);
        }

        @Override
        public void unregisterListener(SensorEventListener listener, int sensorType) {
            List sensors = this.mSensorManager.getSensorList(sensorType);
            if (!sensors.isEmpty()) {
                this.mSensorManager.unregisterListener(listener, (Sensor)sensors.get(0));
            }
        }
    }

    static interface SensorManagerProxy {
        public boolean registerListener(SensorEventListener var1, int var2, int var3, Handler var4);

        public void unregisterListener(SensorEventListener var1, int var2);
    }
}

