/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import android.content.Context;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;
import org.chromium.content.browser.ContentViewCore;
import org.chromium.content.browser.ContentViewDownloadDelegate;
import org.chromium.content.browser.DownloadInfo;
import org.chromium.ui.base.WindowAndroid;

@JNINamespace(value="content")
public class DownloadController {
    private static final String LOGTAG = "DownloadController";
    private static final DownloadController sInstance = new DownloadController();
    private static DownloadNotificationService sDownloadNotificationService;

    @CalledByNative
    public static DownloadController getInstance() {
        return sInstance;
    }

    private DownloadController() {
        this.nativeInit();
    }

    private static ContentViewDownloadDelegate downloadDelegateFromView(ContentViewCore view) {
        return view.getDownloadDelegate();
    }

    public static void setDownloadNotificationService(DownloadNotificationService service) {
        sDownloadNotificationService = service;
    }

    @CalledByNative
    public void newHttpGetDownload(ContentViewCore view, String url, String userAgent, String contentDisposition, String mimeType, String cookie, String referer, boolean hasUserGesture, String filename, long contentLength) {
        ContentViewDownloadDelegate downloadDelegate = DownloadController.downloadDelegateFromView(view);
        if (downloadDelegate != null) {
            DownloadInfo downloadInfo = new DownloadInfo.Builder().setUrl(url).setUserAgent(userAgent).setContentDisposition(contentDisposition).setMimeType(mimeType).setCookie(cookie).setReferer(referer).setHasUserGesture(hasUserGesture).setFileName(filename).setContentLength(contentLength).setIsGETRequest(true).build();
            downloadDelegate.requestHttpGetDownload(downloadInfo);
        }
    }

    @CalledByNative
    public void onDownloadStarted(ContentViewCore view, String filename, String mimeType) {
        ContentViewDownloadDelegate downloadDelegate = DownloadController.downloadDelegateFromView(view);
        if (downloadDelegate != null) {
            downloadDelegate.onDownloadStarted(filename, mimeType);
        }
    }

    @CalledByNative
    public void onDownloadCompleted(Context context, String url, String mimeType, String filename, String path, long contentLength, boolean successful, int downloadId, boolean hasUserGesture) {
        if (sDownloadNotificationService != null) {
            DownloadInfo downloadInfo = new DownloadInfo.Builder().setUrl(url).setMimeType(mimeType).setFileName(filename).setFilePath(path).setContentLength(contentLength).setIsSuccessful(successful).setDescription(filename).setDownloadId(downloadId).setHasDownloadId(true).setHasUserGesture(hasUserGesture).build();
            sDownloadNotificationService.onDownloadCompleted(downloadInfo);
        }
    }

    @CalledByNative
    public void onDownloadUpdated(Context context, String url, String mimeType, String filename, String path, long contentLength, boolean successful, int downloadId, int percentCompleted, long timeRemainingInMs, boolean hasUserGesture) {
        if (sDownloadNotificationService != null) {
            DownloadInfo downloadInfo = new DownloadInfo.Builder().setUrl(url).setMimeType(mimeType).setFileName(filename).setFilePath(path).setContentLength(contentLength).setIsSuccessful(successful).setDescription(filename).setDownloadId(downloadId).setHasDownloadId(true).setPercentCompleted(percentCompleted).setTimeRemainingInMillis(timeRemainingInMs).setHasUserGesture(hasUserGesture).build();
            sDownloadNotificationService.onDownloadUpdated(downloadInfo);
        }
    }

    @CalledByNative
    public void onDangerousDownload(ContentViewCore view, String filename, int downloadId) {
        ContentViewDownloadDelegate downloadDelegate = DownloadController.downloadDelegateFromView(view);
        if (downloadDelegate != null) {
            downloadDelegate.onDangerousDownload(filename, downloadId);
        }
    }

    @CalledByNative
    private boolean hasFileAccess(ContentViewCore view) {
        return view.getWindowAndroid().hasFileAccess();
    }

    @CalledByNative
    private void requestFileAccess(ContentViewCore view, final long callbackId) {
        WindowAndroid.FileAccessCallback callback = new WindowAndroid.FileAccessCallback(){

            @Override
            public void onFileAccessResult(boolean granted) {
                DownloadController.this.nativeOnRequestFileAccessResult(callbackId, granted);
            }
        };
        view.getWindowAndroid().requestFileAccess(callback);
    }

    private native void nativeInit();

    private native void nativeOnRequestFileAccessResult(long var1, boolean var3);

    public static interface DownloadNotificationService {
        public void onDownloadCompleted(DownloadInfo var1);

        public void onDownloadUpdated(DownloadInfo var1);
    }
}

