/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import android.content.Context;
import android.location.Criteria;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import java.util.List;
import org.chromium.base.Log;
import org.chromium.base.ThreadUtils;
import org.chromium.base.VisibleForTesting;
import org.chromium.content.browser.LocationProviderAdapter;

public class LocationProviderFactory {
    private static LocationProvider sProviderImpl;

    private LocationProviderFactory() {
    }

    @VisibleForTesting
    public static void setLocationProviderImpl(LocationProvider provider) {
        assert (sProviderImpl == null);
        sProviderImpl = provider;
    }

    public static LocationProvider get(Context context) {
        if (sProviderImpl == null) {
            sProviderImpl = new LocationProviderImpl(context);
        }
        return sProviderImpl;
    }

    private static class LocationProviderImpl
    implements LocationListener,
    LocationProvider {
        private static final String TAG = "cr.LocationProvider";
        private Context mContext;
        private LocationManager mLocationManager;
        private boolean mIsRunning;

        LocationProviderImpl(Context context) {
            this.mContext = context;
        }

        @Override
        public void start(boolean gpsEnabled) {
            this.unregisterFromLocationUpdates();
            this.registerForLocationUpdates(gpsEnabled);
        }

        @Override
        public void stop() {
            this.unregisterFromLocationUpdates();
        }

        @Override
        public boolean isRunning() {
            return this.mIsRunning;
        }

        public void onLocationChanged(Location location) {
            if (this.mIsRunning) {
                this.updateNewLocation(location);
            }
        }

        private void updateNewLocation(Location location) {
            LocationProviderAdapter.newLocationAvailable(location.getLatitude(), location.getLongitude(), (double)location.getTime() / 1000.0, location.hasAltitude(), location.getAltitude(), location.hasAccuracy(), location.getAccuracy(), location.hasBearing(), location.getBearing(), location.hasSpeed(), location.getSpeed());
        }

        public void onStatusChanged(String provider, int status, Bundle extras) {
        }

        public void onProviderEnabled(String provider) {
        }

        public void onProviderDisabled(String provider) {
        }

        private void ensureLocationManagerCreated() {
            if (this.mLocationManager != null) {
                return;
            }
            this.mLocationManager = (LocationManager)this.mContext.getSystemService("location");
            if (this.mLocationManager == null) {
                Log.e(TAG, "Could not get location manager.", new Object[0]);
            }
        }

        private void registerForLocationUpdates(boolean isGpsEnabled) {
            block6: {
                this.ensureLocationManagerCreated();
                if (this.usePassiveOneShotLocation()) {
                    return;
                }
                assert (!this.mIsRunning);
                this.mIsRunning = true;
                try {
                    Criteria criteria = new Criteria();
                    if (isGpsEnabled) {
                        criteria.setAccuracy(1);
                    }
                    this.mLocationManager.requestLocationUpdates(0L, 0.0f, criteria, (LocationListener)this, ThreadUtils.getUiThreadLooper());
                }
                catch (SecurityException e) {
                    Log.e(TAG, "Caught security exception while registering for location updates from the system. The application does not have sufficient geolocation permissions.", new Object[0]);
                    this.unregisterFromLocationUpdates();
                    LocationProviderAdapter.newErrorAvailable("application does not have sufficient geolocation permissions.");
                }
                catch (IllegalArgumentException e) {
                    Log.e(TAG, "Caught IllegalArgumentException registering for location updates.", new Object[0]);
                    this.unregisterFromLocationUpdates();
                    if ($assertionsDisabled) break block6;
                    throw new AssertionError();
                }
            }
        }

        private void unregisterFromLocationUpdates() {
            if (this.mIsRunning) {
                this.mIsRunning = false;
                this.mLocationManager.removeUpdates((LocationListener)this);
            }
        }

        private boolean usePassiveOneShotLocation() {
            if (!this.isOnlyPassiveLocationProviderEnabled()) {
                return false;
            }
            final Location location = this.mLocationManager.getLastKnownLocation("passive");
            if (location != null) {
                ThreadUtils.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        LocationProviderImpl.this.updateNewLocation(location);
                    }
                });
            }
            return true;
        }

        private boolean isOnlyPassiveLocationProviderEnabled() {
            List providers = this.mLocationManager.getProviders(true);
            return providers != null && providers.size() == 1 && ((String)providers.get(0)).equals("passive");
        }
    }

    public static interface LocationProvider {
        public void start(boolean var1);

        public void stop();

        public boolean isRunning();
    }
}

