/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import android.content.Context;
import android.media.AudioManager;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;
import org.chromium.base.Log;

@JNINamespace(value="content")
public class MediaSession
implements AudioManager.OnAudioFocusChangeListener {
    private static final String TAG = "cr.MediaSession";
    private Context mContext;
    private int mFocusType;
    private final long mNativeMediaSession;

    private MediaSession(Context context, long nativeMediaSession) {
        this.mContext = context;
        this.mNativeMediaSession = nativeMediaSession;
    }

    @CalledByNative
    private static MediaSession createMediaSession(Context context, long nativeMediaSession) {
        return new MediaSession(context, nativeMediaSession);
    }

    @CalledByNative
    private boolean requestAudioFocus(boolean transientFocus) {
        this.mFocusType = transientFocus ? 3 : 1;
        return this.requestAudioFocusInternal();
    }

    @CalledByNative
    private void abandonAudioFocus() {
        AudioManager am = (AudioManager)this.mContext.getSystemService("audio");
        am.abandonAudioFocus((AudioManager.OnAudioFocusChangeListener)this);
    }

    private boolean requestAudioFocusInternal() {
        AudioManager am = (AudioManager)this.mContext.getSystemService("audio");
        int result = am.requestAudioFocus((AudioManager.OnAudioFocusChangeListener)this, 3, this.mFocusType);
        return result == 1;
    }

    public void onAudioFocusChange(int focusChange) {
        switch (focusChange) {
            case 1: {
                if (!this.requestAudioFocusInternal()) break;
                this.nativeOnResume(this.mNativeMediaSession);
                break;
            }
            case -3: 
            case -2: {
                this.nativeOnSuspend(this.mNativeMediaSession, true);
                break;
            }
            case -1: {
                this.abandonAudioFocus();
                this.nativeOnSuspend(this.mNativeMediaSession, false);
                break;
            }
            default: {
                Log.w(TAG, "onAudioFocusChange called with unexpected value %d", focusChange);
            }
        }
    }

    private native void nativeOnSuspend(long var1, boolean var3);

    private native void nativeOnResume(long var1);
}

