/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import android.view.View;
import java.lang.ref.WeakReference;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;
import org.chromium.content.browser.ContentViewCore;
import org.chromium.ui.base.ViewAndroidDelegate;

@JNINamespace(value="content")
class PowerSaveBlocker {
    private WeakReference<View> mKeepScreenOnView;

    @CalledByNative
    private static PowerSaveBlocker create() {
        return new PowerSaveBlocker();
    }

    private PowerSaveBlocker() {
    }

    @CalledByNative
    private void applyBlock(ContentViewCore contentViewCore) {
        assert (this.mKeepScreenOnView == null);
        ViewAndroidDelegate delegate = contentViewCore.getViewAndroidDelegate();
        View anchorView = delegate.acquireAnchorView();
        this.mKeepScreenOnView = new WeakReference<View>(anchorView);
        delegate.setAnchorViewPosition(anchorView, 0.0f, 0.0f, 0.0f, 0.0f);
        anchorView.setKeepScreenOn(true);
    }

    @CalledByNative
    private void removeBlock(ContentViewCore contentViewCore) {
        assert (this.mKeepScreenOnView != null);
        View anchorView = (View)this.mKeepScreenOnView.get();
        this.mKeepScreenOnView = null;
        if (anchorView == null) {
            return;
        }
        ViewAndroidDelegate delegate = contentViewCore.getViewAndroidDelegate();
        anchorView.setKeepScreenOn(false);
        delegate.releaseAnchorView(anchorView);
    }
}

