/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import android.annotation.SuppressLint;
import android.content.ComponentCallbacks;
import android.content.Context;
import android.content.res.Configuration;
import android.hardware.display.DisplayManager;
import android.os.Build;
import android.view.WindowManager;
import org.chromium.base.Log;
import org.chromium.base.ObserverList;
import org.chromium.base.ThreadUtils;
import org.chromium.base.VisibleForTesting;
import org.chromium.ui.gfx.DeviceDisplayInfo;

@VisibleForTesting
public class ScreenOrientationListener {
    private static final String TAG = "cr.ScreenOrientation";
    private final ObserverList<ScreenOrientationObserver> mObservers = new ObserverList();
    private int mOrientation;
    private Context mAppContext;
    private ScreenOrientationListenerBackend mBackend = Build.VERSION.SDK_INT >= 17 ? new ScreenOrientationDisplayListener() : new ScreenOrientationConfigurationListener();
    private static ScreenOrientationListener sInstance;

    public static ScreenOrientationListener getInstance() {
        ThreadUtils.assertOnUiThread();
        if (sInstance == null) {
            sInstance = new ScreenOrientationListener();
        }
        return sInstance;
    }

    private ScreenOrientationListener() {
    }

    public void addObserver(ScreenOrientationObserver observer, Context context) {
        if (this.mAppContext == null) {
            this.mAppContext = context.getApplicationContext();
        }
        assert (this.mAppContext == context.getApplicationContext());
        assert (this.mAppContext != null);
        if (!this.mObservers.addObserver(observer)) {
            Log.w(TAG, "Adding an observer that is already present!", new Object[0]);
            return;
        }
        if (this.mObservers.size() == 1) {
            this.updateOrientation();
            this.mBackend.startListening();
        }
        final ScreenOrientationObserver obs = observer;
        ThreadUtils.assertOnUiThread();
        ThreadUtils.postOnUiThread(new Runnable(){

            @Override
            public void run() {
                obs.onScreenOrientationChanged(ScreenOrientationListener.this.mOrientation);
            }
        });
    }

    public void removeObserver(ScreenOrientationObserver observer) {
        if (!this.mObservers.removeObserver(observer)) {
            Log.w(TAG, "Removing an inexistent observer!", new Object[0]);
            return;
        }
        if (this.mObservers.isEmpty()) {
            this.mBackend.stopListening();
        }
    }

    public void startAccurateListening() {
        this.mBackend.startAccurateListening();
    }

    public void stopAccurateListening() {
        this.mBackend.stopAccurateListening();
    }

    private void notifyObservers() {
        int previousOrientation = this.mOrientation;
        this.updateOrientation();
        if (this.mOrientation == previousOrientation) {
            return;
        }
        DeviceDisplayInfo.create(this.mAppContext).updateNativeSharedDisplayInfo();
        for (ScreenOrientationObserver observer : this.mObservers) {
            observer.onScreenOrientationChanged(this.mOrientation);
        }
    }

    private void updateOrientation() {
        WindowManager windowManager = (WindowManager)this.mAppContext.getSystemService("window");
        switch (windowManager.getDefaultDisplay().getRotation()) {
            case 0: {
                this.mOrientation = 0;
                break;
            }
            case 1: {
                this.mOrientation = 90;
                break;
            }
            case 2: {
                this.mOrientation = 180;
                break;
            }
            case 3: {
                this.mOrientation = -90;
                break;
            }
            default: {
                throw new IllegalStateException("Display.getRotation() shouldn't return that value");
            }
        }
    }

    @SuppressLint(value={"NewApi"})
    private class ScreenOrientationDisplayListener
    implements ScreenOrientationListenerBackend,
    DisplayManager.DisplayListener {
        private ScreenOrientationDisplayListener() {
        }

        @Override
        public void startListening() {
            DisplayManager displayManager = (DisplayManager)ScreenOrientationListener.this.mAppContext.getSystemService("display");
            displayManager.registerDisplayListener((DisplayManager.DisplayListener)this, null);
        }

        @Override
        public void stopListening() {
            DisplayManager displayManager = (DisplayManager)ScreenOrientationListener.this.mAppContext.getSystemService("display");
            displayManager.unregisterDisplayListener((DisplayManager.DisplayListener)this);
        }

        @Override
        public void startAccurateListening() {
        }

        @Override
        public void stopAccurateListening() {
        }

        public void onDisplayAdded(int displayId) {
        }

        public void onDisplayRemoved(int displayId) {
        }

        public void onDisplayChanged(int displayId) {
            ScreenOrientationListener.this.notifyObservers();
        }
    }

    private class ScreenOrientationConfigurationListener
    implements ScreenOrientationListenerBackend,
    ComponentCallbacks {
        private static final long POLLING_DELAY = 500L;
        private int mAccurateCount = 0;

        private ScreenOrientationConfigurationListener() {
        }

        @Override
        public void startListening() {
            ScreenOrientationListener.this.mAppContext.registerComponentCallbacks((ComponentCallbacks)this);
        }

        @Override
        public void stopListening() {
            ScreenOrientationListener.this.mAppContext.unregisterComponentCallbacks((ComponentCallbacks)this);
        }

        @Override
        public void startAccurateListening() {
            ++this.mAccurateCount;
            if (this.mAccurateCount > 1) {
                return;
            }
            final ScreenOrientationConfigurationListener self = this;
            ThreadUtils.postOnUiThreadDelayed(new Runnable(){

                @Override
                public void run() {
                    self.onConfigurationChanged(null);
                    if (self.mAccurateCount < 1) {
                        return;
                    }
                    ThreadUtils.postOnUiThreadDelayed(this, 500L);
                }
            }, 500L);
        }

        @Override
        public void stopAccurateListening() {
            --this.mAccurateCount;
            assert (this.mAccurateCount >= 0);
        }

        public void onConfigurationChanged(Configuration newConfig) {
            ScreenOrientationListener.this.notifyObservers();
        }

        public void onLowMemory() {
        }
    }

    private static interface ScreenOrientationListenerBackend {
        public void startListening();

        public void stopListening();

        public void startAccurateListening();

        public void stopAccurateListening();
    }

    public static interface ScreenOrientationObserver {
        public void onScreenOrientationChanged(int var1);
    }
}

