/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import android.app.Activity;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import org.chromium.base.ApplicationStatus;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;
import org.chromium.base.Log;
import org.chromium.base.ThreadUtils;
import org.chromium.content.browser.ScreenOrientationListener;
import org.chromium.ui.gfx.DeviceDisplayInfo;

@JNINamespace(value="content")
public class ScreenOrientationProvider {
    private static final String TAG = "cr.ScreenOrientation";

    private static int getOrientationFromWebScreenOrientations(byte orientation, Activity activity) {
        switch (orientation) {
            case 0: {
                return -1;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 9;
            }
            case 3: {
                return 0;
            }
            case 4: {
                return 8;
            }
            case 7: {
                return 7;
            }
            case 6: {
                return 6;
            }
            case 5: {
                return 10;
            }
            case 8: {
                DeviceDisplayInfo displayInfo = DeviceDisplayInfo.create((Context)activity);
                int rotation = displayInfo.getRotationDegrees();
                if (rotation == 0 || rotation == 180) {
                    if (displayInfo.getDisplayHeight() >= displayInfo.getDisplayWidth()) {
                        return 1;
                    }
                    return 0;
                }
                if (displayInfo.getDisplayHeight() < displayInfo.getDisplayWidth()) {
                    return 1;
                }
                return 0;
            }
        }
        Log.w(TAG, "Trying to lock to unsupported orientation!", new Object[0]);
        return -1;
    }

    @CalledByNative
    static void lockOrientation(byte orientation) {
        ScreenOrientationProvider.lockOrientation(orientation, ApplicationStatus.getLastTrackedFocusedActivity());
    }

    public static void lockOrientation(byte webScreenOrientation, Activity activity) {
        if (activity == null) {
            return;
        }
        int orientation = ScreenOrientationProvider.getOrientationFromWebScreenOrientations(webScreenOrientation, activity);
        if (orientation == -1) {
            return;
        }
        activity.setRequestedOrientation(orientation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    static void unlockOrientation() {
        Activity activity = ApplicationStatus.getLastTrackedFocusedActivity();
        if (activity == null) {
            return;
        }
        int defaultOrientation = -1;
        int orientation = activity.getIntent().getIntExtra("org.chromium.content_public.common.orientation", 0);
        defaultOrientation = ScreenOrientationProvider.getOrientationFromWebScreenOrientations((byte)orientation, activity);
        try {
            if (defaultOrientation == -1) {
                ActivityInfo info = activity.getPackageManager().getActivityInfo(activity.getComponentName(), 128);
                defaultOrientation = info.screenOrientation;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
        }
        finally {
            activity.setRequestedOrientation(defaultOrientation);
        }
    }

    @CalledByNative
    static void startAccurateListening() {
        ThreadUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                ScreenOrientationListener.getInstance().startAccurateListening();
            }
        });
    }

    @CalledByNative
    static void stopAccurateListening() {
        ThreadUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                ScreenOrientationListener.getInstance().stopAccurateListening();
            }
        });
    }

    private ScreenOrientationProvider() {
    }
}

