/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;
import org.chromium.mojo.bindings.Interface;
import org.chromium.mojo.bindings.InterfaceRequest;
import org.chromium.mojo.system.Core;
import org.chromium.mojo.system.MessagePipeHandle;
import org.chromium.mojo.system.impl.CoreImpl;

@JNINamespace(value="content")
public class ServiceRegistry {
    private long mNativeServiceRegistryAndroid;
    private final Core mCore;

    <I extends Interface, P extends Interface.Proxy> void addService(Interface.Manager<I, P> manager, ImplementationFactory<I> factory) {
        this.nativeAddService(this.mNativeServiceRegistryAndroid, manager, factory, manager.getName());
    }

    <I extends Interface, P extends Interface.Proxy> void removeService(Interface.Manager<I, P> manager) {
        this.nativeRemoveService(this.mNativeServiceRegistryAndroid, manager.getName());
    }

    <I extends Interface, P extends Interface.Proxy> void connectToRemoteService(Interface.Manager<I, P> manager, InterfaceRequest<I> request) {
        int nativeHandle = request.passHandle().releaseNativeHandle();
        this.nativeConnectToRemoteService(this.mNativeServiceRegistryAndroid, manager.getName(), nativeHandle);
    }

    private ServiceRegistry(long nativeServiceRegistryAndroid, Core core) {
        this.mNativeServiceRegistryAndroid = nativeServiceRegistryAndroid;
        this.mCore = core;
    }

    @CalledByNative
    private static ServiceRegistry create(long nativeServiceRegistryAndroid) {
        return new ServiceRegistry(nativeServiceRegistryAndroid, CoreImpl.getInstance());
    }

    @CalledByNative
    private void destroy() {
        this.mNativeServiceRegistryAndroid = 0L;
    }

    @CalledByNative
    private void createImplAndAttach(int nativeHandle, Interface.Manager manager, ImplementationFactory factory) {
        MessagePipeHandle handle = this.mCore.acquireNativeHandle(nativeHandle).toMessagePipeHandle();
        manager.bind(factory.createImpl(), handle);
    }

    private native void nativeAddService(long var1, Interface.Manager var3, ImplementationFactory var4, String var5);

    private native void nativeRemoveService(long var1, String var3);

    private native void nativeConnectToRemoteService(long var1, String var3, int var4);

    static interface ImplementationFactory<I extends Interface> {
        public I createImpl();
    }
}

