/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Environment;
import android.text.TextUtils;
import android.widget.Toast;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;
import org.chromium.base.Log;
import org.chromium.content.R;

@JNINamespace(value="content")
public class TracingControllerAndroid {
    private static final String TAG = "cr.TracingController";
    private static final String ACTION_START = "GPU_PROFILER_START";
    private static final String ACTION_STOP = "GPU_PROFILER_STOP";
    private static final String ACTION_LIST_CATEGORIES = "GPU_PROFILER_LIST_CATEGORIES";
    private static final String FILE_EXTRA = "file";
    private static final String CATEGORIES_EXTRA = "categories";
    private static final String RECORD_CONTINUOUSLY_EXTRA = "continuous";
    private static final String DEFAULT_CHROME_CATEGORIES_PLACE_HOLDER = "_DEFAULT_CHROME_CATEGORIES";
    private static final String PROFILER_STARTED_FMT = "Profiler started: %s";
    private static final String PROFILER_FINISHED_FMT = "Profiler finished. Results are in %s.";
    private final Context mContext;
    private final TracingBroadcastReceiver mBroadcastReceiver;
    private final TracingIntentFilter mIntentFilter;
    private boolean mIsTracing;
    private boolean mShowToasts = true;
    private String mFilename;
    private long mNativeTracingControllerAndroid;

    public TracingControllerAndroid(Context context) {
        this.mContext = context;
        this.mBroadcastReceiver = new TracingBroadcastReceiver();
        this.mIntentFilter = new TracingIntentFilter(context);
    }

    public BroadcastReceiver getBroadcastReceiver() {
        return this.mBroadcastReceiver;
    }

    public IntentFilter getIntentFilter() {
        return this.mIntentFilter;
    }

    public void registerReceiver(Context context) {
        context.registerReceiver(this.getBroadcastReceiver(), this.getIntentFilter());
    }

    public void unregisterReceiver(Context context) {
        context.unregisterReceiver(this.getBroadcastReceiver());
    }

    public boolean isTracing() {
        return this.mIsTracing;
    }

    public String getOutputPath() {
        return this.mFilename;
    }

    @CalledByNative
    private static String generateTracingFilePath() {
        String state = Environment.getExternalStorageState();
        if (!"mounted".equals(state)) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd-HHmmss", Locale.US);
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        File dir = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS);
        File file = new File(dir, "chrome-profile-results-" + formatter.format(new Date()));
        return file.getPath();
    }

    public boolean startTracing(boolean showToasts, String categories, String traceOptions) {
        this.mShowToasts = showToasts;
        String filePath = TracingControllerAndroid.generateTracingFilePath();
        if (filePath == null) {
            this.logAndToastError(this.mContext.getString(R.string.profiler_no_storage_toast));
        }
        return this.startTracing(filePath, showToasts, categories, traceOptions);
    }

    private void initializeNativeControllerIfNeeded() {
        if (this.mNativeTracingControllerAndroid == 0L) {
            this.mNativeTracingControllerAndroid = this.nativeInit();
        }
    }

    public boolean startTracing(String filename, boolean showToasts, String categories, String traceOptions) {
        this.mShowToasts = showToasts;
        if (this.isTracing()) {
            Log.e(TAG, "Received startTracing, but we're already tracing", new Object[0]);
            return false;
        }
        this.initializeNativeControllerIfNeeded();
        if (!this.nativeStartTracing(this.mNativeTracingControllerAndroid, categories, traceOptions.toString())) {
            this.logAndToastError(this.mContext.getString(R.string.profiler_error_toast));
            return false;
        }
        this.logForProfiler(String.format(PROFILER_STARTED_FMT, categories));
        this.showToast(this.mContext.getString(R.string.profiler_started_toast) + ": " + categories);
        this.mFilename = filename;
        this.mIsTracing = true;
        return true;
    }

    public void stopTracing() {
        if (this.isTracing()) {
            this.nativeStopTracing(this.mNativeTracingControllerAndroid, this.mFilename);
        }
    }

    @CalledByNative
    protected void onTracingStopped() {
        if (!this.isTracing()) {
            Log.e(TAG, "Received onTracingStopped, but we aren't tracing", new Object[0]);
            return;
        }
        this.logForProfiler(String.format(PROFILER_FINISHED_FMT, this.mFilename));
        this.showToast(this.mContext.getString(R.string.profiler_stopped_toast, new Object[]{this.mFilename}));
        this.mIsTracing = false;
        this.mFilename = null;
    }

    public void getCategoryGroups() {
        this.initializeNativeControllerIfNeeded();
        if (!this.nativeGetKnownCategoryGroupsAsync(this.mNativeTracingControllerAndroid)) {
            Log.e(TAG, "Unable to fetch tracing record groups list.", new Object[0]);
        }
    }

    public void destroy() {
        if (this.mNativeTracingControllerAndroid != 0L) {
            this.nativeDestroy(this.mNativeTracingControllerAndroid);
            this.mNativeTracingControllerAndroid = 0L;
        }
    }

    private void logAndToastError(String str) {
        Log.e(TAG, str, new Object[0]);
        if (this.mShowToasts) {
            Toast.makeText((Context)this.mContext, (CharSequence)str, (int)0).show();
        }
    }

    private void logForProfiler(String str) {
        Log.i(TAG, str, new Object[0]);
    }

    private void showToast(String str) {
        if (this.mShowToasts) {
            Toast.makeText((Context)this.mContext, (CharSequence)str, (int)0).show();
        }
    }

    private native long nativeInit();

    private native void nativeDestroy(long var1);

    private native boolean nativeStartTracing(long var1, String var3, String var4);

    private native void nativeStopTracing(long var1, String var3);

    private native boolean nativeGetKnownCategoryGroupsAsync(long var1);

    private native String nativeGetDefaultCategories();

    class TracingBroadcastReceiver
    extends BroadcastReceiver {
        TracingBroadcastReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().endsWith(TracingControllerAndroid.ACTION_START)) {
                String categories = intent.getStringExtra(TracingControllerAndroid.CATEGORIES_EXTRA);
                categories = TextUtils.isEmpty((CharSequence)categories) ? TracingControllerAndroid.this.nativeGetDefaultCategories() : categories.replaceFirst(TracingControllerAndroid.DEFAULT_CHROME_CATEGORIES_PLACE_HOLDER, TracingControllerAndroid.this.nativeGetDefaultCategories());
                String traceOptions = intent.getStringExtra(TracingControllerAndroid.RECORD_CONTINUOUSLY_EXTRA) == null ? "record-until-full" : "record-continuously";
                String filename = intent.getStringExtra(TracingControllerAndroid.FILE_EXTRA);
                if (filename != null) {
                    TracingControllerAndroid.this.startTracing(filename, true, categories, traceOptions);
                } else {
                    TracingControllerAndroid.this.startTracing(true, categories, traceOptions);
                }
            } else if (intent.getAction().endsWith(TracingControllerAndroid.ACTION_STOP)) {
                TracingControllerAndroid.this.stopTracing();
            } else if (intent.getAction().endsWith(TracingControllerAndroid.ACTION_LIST_CATEGORIES)) {
                TracingControllerAndroid.this.getCategoryGroups();
            } else {
                Log.e(TracingControllerAndroid.TAG, "Unexpected intent: %s", intent);
            }
        }
    }

    private static class TracingIntentFilter
    extends IntentFilter {
        TracingIntentFilter(Context context) {
            this.addAction(context.getPackageName() + "." + TracingControllerAndroid.ACTION_START);
            this.addAction(context.getPackageName() + "." + TracingControllerAndroid.ACTION_STOP);
            this.addAction(context.getPackageName() + "." + TracingControllerAndroid.ACTION_LIST_CATEGORIES);
        }
    }
}

