/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser.accessibility;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.view.accessibility.AccessibilityNodeInfo;
import java.util.Iterator;
import org.chromium.content.browser.ContentViewCore;
import org.chromium.content.browser.JavascriptInterface;
import org.chromium.content.browser.accessibility.AccessibilityInjector;
import org.chromium.content.browser.accessibility.JellyBeanAccessibilityInjector;
import org.json.JSONException;
import org.json.JSONObject;

@TargetApi(value=21)
class LollipopAccessibilityInjector
extends JellyBeanAccessibilityInjector {
    protected LollipopAccessibilityInjector(ContentViewCore view) {
        super(view);
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        info.setMovementGranularities(31);
        info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_NEXT_AT_MOVEMENT_GRANULARITY);
        info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_PREVIOUS_AT_MOVEMENT_GRANULARITY);
        info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_NEXT_HTML_ELEMENT);
        info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_PREVIOUS_HTML_ELEMENT);
        info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_CLICK);
        info.setClickable(true);
    }

    @Override
    protected AccessibilityInjector.TextToSpeechWrapper createTextToSpeechWrapper(View view, Context context) {
        return new LTextToSpeechWrapper(view, context);
    }

    protected static class LTextToSpeechWrapper
    extends AccessibilityInjector.TextToSpeechWrapper {
        private LTextToSpeechWrapper(View view, Context context) {
            super(view, context);
        }

        @Override
        @JavascriptInterface
        public int speak(String text, int queueMode, String jsonParams) {
            Bundle bundle = null;
            try {
                if (jsonParams != null) {
                    bundle = new Bundle();
                    JSONObject json = new JSONObject(jsonParams);
                    Iterator keyIt = json.keys();
                    while (keyIt.hasNext()) {
                        String key = (String)keyIt.next();
                        if (json.optJSONObject(key) != null || json.optJSONArray(key) != null) continue;
                        bundle.putCharSequence(key, (CharSequence)json.getString(key));
                    }
                }
            }
            catch (JSONException e) {
                bundle = null;
            }
            return this.mTextToSpeech.speak((CharSequence)text, queueMode, bundle, null);
        }
    }
}

