/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser.framehost;

import android.graphics.Bitmap;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;
import org.chromium.base.VisibleForTesting;
import org.chromium.content_public.browser.LoadUrlParams;
import org.chromium.content_public.browser.NavigationController;
import org.chromium.content_public.browser.NavigationEntry;
import org.chromium.content_public.browser.NavigationHistory;

@JNINamespace(value="content")
class NavigationControllerImpl
implements NavigationController {
    private long mNativeNavigationControllerAndroid;

    private NavigationControllerImpl(long nativeNavigationControllerAndroid) {
        this.mNativeNavigationControllerAndroid = nativeNavigationControllerAndroid;
    }

    @CalledByNative
    private static NavigationControllerImpl create(long nativeNavigationControllerAndroid) {
        return new NavigationControllerImpl(nativeNavigationControllerAndroid);
    }

    @CalledByNative
    private void destroy() {
        this.mNativeNavigationControllerAndroid = 0L;
    }

    @Override
    public boolean canGoBack() {
        return this.mNativeNavigationControllerAndroid != 0L && this.nativeCanGoBack(this.mNativeNavigationControllerAndroid);
    }

    @Override
    public boolean canGoForward() {
        return this.mNativeNavigationControllerAndroid != 0L && this.nativeCanGoForward(this.mNativeNavigationControllerAndroid);
    }

    @Override
    @VisibleForTesting
    public boolean canGoToOffset(int offset) {
        return this.mNativeNavigationControllerAndroid != 0L && this.nativeCanGoToOffset(this.mNativeNavigationControllerAndroid, offset);
    }

    @Override
    public void goToOffset(int offset) {
        if (this.mNativeNavigationControllerAndroid != 0L) {
            this.nativeGoToOffset(this.mNativeNavigationControllerAndroid, offset);
        }
    }

    @Override
    public void goToNavigationIndex(int index) {
        if (this.mNativeNavigationControllerAndroid != 0L) {
            this.nativeGoToNavigationIndex(this.mNativeNavigationControllerAndroid, index);
        }
    }

    @Override
    public void goBack() {
        if (this.mNativeNavigationControllerAndroid != 0L) {
            this.nativeGoBack(this.mNativeNavigationControllerAndroid);
        }
    }

    @Override
    public void goForward() {
        if (this.mNativeNavigationControllerAndroid != 0L) {
            this.nativeGoForward(this.mNativeNavigationControllerAndroid);
        }
    }

    @Override
    public boolean isInitialNavigation() {
        return this.mNativeNavigationControllerAndroid != 0L && this.nativeIsInitialNavigation(this.mNativeNavigationControllerAndroid);
    }

    @Override
    public void loadIfNecessary() {
        if (this.mNativeNavigationControllerAndroid != 0L) {
            this.nativeLoadIfNecessary(this.mNativeNavigationControllerAndroid);
        }
    }

    @Override
    public void requestRestoreLoad() {
        if (this.mNativeNavigationControllerAndroid != 0L) {
            this.nativeRequestRestoreLoad(this.mNativeNavigationControllerAndroid);
        }
    }

    @Override
    public void reload(boolean checkForRepost) {
        if (this.mNativeNavigationControllerAndroid != 0L) {
            this.nativeReload(this.mNativeNavigationControllerAndroid, checkForRepost);
        }
    }

    @Override
    public void reloadIgnoringCache(boolean checkForRepost) {
        if (this.mNativeNavigationControllerAndroid != 0L) {
            this.nativeReloadIgnoringCache(this.mNativeNavigationControllerAndroid, checkForRepost);
        }
    }

    @Override
    public void cancelPendingReload() {
        if (this.mNativeNavigationControllerAndroid != 0L) {
            this.nativeCancelPendingReload(this.mNativeNavigationControllerAndroid);
        }
    }

    @Override
    public void continuePendingReload() {
        if (this.mNativeNavigationControllerAndroid != 0L) {
            this.nativeContinuePendingReload(this.mNativeNavigationControllerAndroid);
        }
    }

    @Override
    public void loadUrl(LoadUrlParams params) {
        if (this.mNativeNavigationControllerAndroid != 0L) {
            this.nativeLoadUrl(this.mNativeNavigationControllerAndroid, params.getUrl(), params.getLoadUrlType(), params.getTransitionType(), params.getReferrer() != null ? params.getReferrer().getUrl() : null, params.getReferrer() != null ? params.getReferrer().getPolicy() : 0, params.getUserAgentOverrideOption(), params.getExtraHeadersString(), params.getPostData(), params.getBaseUrl(), params.getVirtualUrlForDataUrl(), params.getCanLoadLocalResources(), params.getIsRendererInitiated());
        }
    }

    @Override
    @VisibleForTesting
    public void clearHistory() {
        if (this.mNativeNavigationControllerAndroid != 0L) {
            this.nativeClearHistory(this.mNativeNavigationControllerAndroid);
        }
    }

    @Override
    public NavigationHistory getNavigationHistory() {
        if (this.mNativeNavigationControllerAndroid == 0L) {
            return null;
        }
        NavigationHistory history = new NavigationHistory();
        int currentIndex = this.nativeGetNavigationHistory(this.mNativeNavigationControllerAndroid, history);
        history.setCurrentEntryIndex(currentIndex);
        return history;
    }

    @Override
    public NavigationHistory getDirectedNavigationHistory(boolean isForward, int itemLimit) {
        if (this.mNativeNavigationControllerAndroid == 0L) {
            return null;
        }
        NavigationHistory history = new NavigationHistory();
        this.nativeGetDirectedNavigationHistory(this.mNativeNavigationControllerAndroid, history, isForward, itemLimit);
        return history;
    }

    @Override
    public String getOriginalUrlForVisibleNavigationEntry() {
        if (this.mNativeNavigationControllerAndroid == 0L) {
            return null;
        }
        return this.nativeGetOriginalUrlForVisibleNavigationEntry(this.mNativeNavigationControllerAndroid);
    }

    @Override
    public void clearSslPreferences() {
        if (this.mNativeNavigationControllerAndroid != 0L) {
            this.nativeClearSslPreferences(this.mNativeNavigationControllerAndroid);
        }
    }

    @Override
    public boolean getUseDesktopUserAgent() {
        if (this.mNativeNavigationControllerAndroid == 0L) {
            return false;
        }
        return this.nativeGetUseDesktopUserAgent(this.mNativeNavigationControllerAndroid);
    }

    @Override
    public void setUseDesktopUserAgent(boolean override, boolean reloadOnChange) {
        if (this.mNativeNavigationControllerAndroid != 0L) {
            this.nativeSetUseDesktopUserAgent(this.mNativeNavigationControllerAndroid, override, reloadOnChange);
        }
    }

    @Override
    public NavigationEntry getEntryAtIndex(int index) {
        if (this.mNativeNavigationControllerAndroid != 0L) {
            return this.nativeGetEntryAtIndex(this.mNativeNavigationControllerAndroid, index);
        }
        return null;
    }

    @Override
    public NavigationEntry getPendingEntry() {
        if (this.mNativeNavigationControllerAndroid != 0L) {
            return this.nativeGetPendingEntry(this.mNativeNavigationControllerAndroid);
        }
        return null;
    }

    @Override
    public int getLastCommittedEntryIndex() {
        if (this.mNativeNavigationControllerAndroid != 0L) {
            return this.nativeGetLastCommittedEntryIndex(this.mNativeNavigationControllerAndroid);
        }
        return -1;
    }

    @Override
    public boolean removeEntryAtIndex(int index) {
        if (this.mNativeNavigationControllerAndroid != 0L) {
            return this.nativeRemoveEntryAtIndex(this.mNativeNavigationControllerAndroid, index);
        }
        return false;
    }

    @Override
    public boolean canCopyStateOver() {
        return this.mNativeNavigationControllerAndroid != 0L && this.nativeCanCopyStateOver(this.mNativeNavigationControllerAndroid);
    }

    @Override
    public boolean canPruneAllButLastCommitted() {
        return this.mNativeNavigationControllerAndroid != 0L && this.nativeCanPruneAllButLastCommitted(this.mNativeNavigationControllerAndroid);
    }

    @Override
    public void copyStateFrom(NavigationController source) {
        if (this.mNativeNavigationControllerAndroid == 0L) {
            return;
        }
        NavigationControllerImpl sourceImpl = (NavigationControllerImpl)source;
        if (sourceImpl.mNativeNavigationControllerAndroid == 0L) {
            return;
        }
        this.nativeCopyStateFrom(this.mNativeNavigationControllerAndroid, sourceImpl.mNativeNavigationControllerAndroid);
    }

    @Override
    public void copyStateFromAndPrune(NavigationController source, boolean replaceEntry) {
        if (this.mNativeNavigationControllerAndroid == 0L) {
            return;
        }
        NavigationControllerImpl sourceImpl = (NavigationControllerImpl)source;
        if (sourceImpl.mNativeNavigationControllerAndroid == 0L) {
            return;
        }
        this.nativeCopyStateFromAndPrune(this.mNativeNavigationControllerAndroid, sourceImpl.mNativeNavigationControllerAndroid, replaceEntry);
    }

    @CalledByNative
    private static void addToNavigationHistory(Object history, Object navigationEntry) {
        ((NavigationHistory)history).addEntry((NavigationEntry)navigationEntry);
    }

    @CalledByNative
    private static NavigationEntry createNavigationEntry(int index, String url, String virtualUrl, String originalUrl, String title, Bitmap favicon, int transition) {
        return new NavigationEntry(index, url, virtualUrl, originalUrl, title, favicon, transition);
    }

    private native boolean nativeCanGoBack(long var1);

    private native boolean nativeCanGoForward(long var1);

    private native boolean nativeIsInitialNavigation(long var1);

    private native void nativeLoadIfNecessary(long var1);

    private native void nativeRequestRestoreLoad(long var1);

    private native boolean nativeCanGoToOffset(long var1, int var3);

    private native void nativeGoBack(long var1);

    private native void nativeGoForward(long var1);

    private native void nativeGoToOffset(long var1, int var3);

    private native void nativeGoToNavigationIndex(long var1, int var3);

    private native void nativeCancelPendingReload(long var1);

    private native void nativeContinuePendingReload(long var1);

    private native void nativeReload(long var1, boolean var3);

    private native void nativeReloadIgnoringCache(long var1, boolean var3);

    private native void nativeLoadUrl(long var1, String var3, int var4, int var5, String var6, int var7, int var8, String var9, byte[] var10, String var11, String var12, boolean var13, boolean var14);

    private native void nativeClearHistory(long var1);

    private native int nativeGetNavigationHistory(long var1, Object var3);

    private native void nativeGetDirectedNavigationHistory(long var1, NavigationHistory var3, boolean var4, int var5);

    private native String nativeGetOriginalUrlForVisibleNavigationEntry(long var1);

    private native void nativeClearSslPreferences(long var1);

    private native boolean nativeGetUseDesktopUserAgent(long var1);

    private native void nativeSetUseDesktopUserAgent(long var1, boolean var3, boolean var4);

    private native NavigationEntry nativeGetEntryAtIndex(long var1, int var3);

    private native NavigationEntry nativeGetPendingEntry(long var1);

    private native int nativeGetLastCommittedEntryIndex(long var1);

    private native boolean nativeRemoveEntryAtIndex(long var1, int var3);

    private native boolean nativeCanCopyStateOver(long var1);

    private native boolean nativeCanPruneAllButLastCommitted(long var1);

    private native void nativeCopyStateFrom(long var1, long var3);

    private native void nativeCopyStateFromAndPrune(long var1, long var3, boolean var5);
}

