/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser.input;

import android.os.SystemClock;
import android.text.Editable;
import android.text.Selection;
import android.text.Spannable;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.View;
import android.view.inputmethod.BaseInputConnection;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.ExtractedTextRequest;
import org.chromium.base.VisibleForTesting;
import org.chromium.content.browser.input.ImeAdapter;
import org.chromium.content.browser.input.InputMethodManagerWrapper;

public class AdapterInputConnection
extends BaseInputConnection {
    private static final String TAG = "cr.InputConnection";
    private static final boolean DEBUG = false;
    public static final int INVALID_SELECTION = -1;
    public static final int INVALID_COMPOSITION = -1;
    private final View mInternalView;
    private final ImeAdapter mImeAdapter;
    private final Editable mEditable;
    private boolean mSingleLine;
    private int mNumNestedBatchEdits = 0;
    private int mPendingAccent;
    private int mLastUpdateSelectionStart = -1;
    private int mLastUpdateSelectionEnd = -1;
    private int mLastUpdateCompositionStart = -1;
    private int mLastUpdateCompositionEnd = -1;

    @VisibleForTesting
    AdapterInputConnection(View view, ImeAdapter imeAdapter, Editable editable, EditorInfo outAttrs) {
        super(view, true);
        this.mInternalView = view;
        this.mImeAdapter = imeAdapter;
        this.mImeAdapter.setInputConnection(this);
        this.mEditable = editable;
        this.finishComposingText();
        this.mSingleLine = true;
        outAttrs.imeOptions = 0x12000000;
        outAttrs.inputType = 161;
        int inputType = imeAdapter.getTextInputType();
        int inputFlags = imeAdapter.getTextInputFlags();
        if ((inputFlags & 2) != 0) {
            outAttrs.inputType |= 0x80000;
        }
        if (inputType == 1) {
            outAttrs.imeOptions |= 2;
            if ((inputFlags & 8) == 0) {
                outAttrs.inputType |= 0x8000;
            }
        } else if (inputType == 14 || inputType == 15) {
            outAttrs.inputType |= 0x20000;
            if ((inputFlags & 8) == 0) {
                outAttrs.inputType |= 0x8000;
            }
            outAttrs.imeOptions |= 1;
            this.mSingleLine = false;
        } else if (inputType == 2) {
            outAttrs.inputType = 225;
            outAttrs.imeOptions |= 2;
        } else if (inputType == 3) {
            outAttrs.imeOptions |= 3;
        } else if (inputType == 7) {
            outAttrs.inputType = 17;
            outAttrs.imeOptions |= 2;
        } else if (inputType == 4) {
            outAttrs.inputType = 209;
            outAttrs.imeOptions |= 2;
        } else if (inputType == 6) {
            outAttrs.inputType = 3;
            outAttrs.imeOptions |= 5;
        } else if (inputType == 5) {
            outAttrs.inputType = 8194;
            outAttrs.imeOptions |= 5;
        }
        if ((inputFlags & 0x80) != 0) {
            outAttrs.inputType |= 0x1000;
        } else if ((inputFlags & 0x100) != 0) {
            outAttrs.inputType |= 0x2000;
        } else if ((inputFlags & 0x200) != 0) {
            outAttrs.inputType |= 0x4000;
        }
        if (inputType == 15) {
            outAttrs.inputType |= 0x4000;
        }
        outAttrs.initialSelStart = Selection.getSelectionStart((CharSequence)this.mEditable);
        outAttrs.initialSelEnd = Selection.getSelectionEnd((CharSequence)this.mEditable);
        this.mLastUpdateSelectionStart = outAttrs.initialSelStart;
        this.mLastUpdateSelectionEnd = outAttrs.initialSelEnd;
        Selection.setSelection((Spannable)this.mEditable, (int)outAttrs.initialSelStart, (int)outAttrs.initialSelEnd);
        this.updateSelectionIfRequired();
    }

    @VisibleForTesting
    public void updateState(String text, int selectionStart, int selectionEnd, int compositionStart, int compositionEnd, boolean isNonImeChange) {
        if (!isNonImeChange) {
            return;
        }
        text = text.replace('\u00a0', ' ');
        selectionStart = Math.min(selectionStart, text.length());
        selectionEnd = Math.min(selectionEnd, text.length());
        compositionStart = Math.min(compositionStart, text.length());
        compositionEnd = Math.min(compositionEnd, text.length());
        String prevText = this.mEditable.toString();
        boolean textUnchanged = prevText.equals(text);
        if (!textUnchanged) {
            this.mEditable.replace(0, this.mEditable.length(), (CharSequence)text);
        }
        Selection.setSelection((Spannable)this.mEditable, (int)selectionStart, (int)selectionEnd);
        if (compositionStart == compositionEnd) {
            AdapterInputConnection.removeComposingSpans((Spannable)this.mEditable);
        } else {
            super.setComposingRegion(compositionStart, compositionEnd);
        }
        this.updateSelectionIfRequired();
    }

    public Editable getEditable() {
        return this.mEditable;
    }

    private void updateSelectionIfRequired() {
        if (this.mNumNestedBatchEdits != 0) {
            return;
        }
        int selectionStart = Selection.getSelectionStart((CharSequence)this.mEditable);
        int selectionEnd = Selection.getSelectionEnd((CharSequence)this.mEditable);
        int compositionStart = AdapterInputConnection.getComposingSpanStart((Spannable)this.mEditable);
        int compositionEnd = AdapterInputConnection.getComposingSpanEnd((Spannable)this.mEditable);
        if (this.mLastUpdateSelectionStart == selectionStart && this.mLastUpdateSelectionEnd == selectionEnd && this.mLastUpdateCompositionStart == compositionStart && this.mLastUpdateCompositionEnd == compositionEnd) {
            return;
        }
        this.getInputMethodManagerWrapper().updateSelection(this.mInternalView, selectionStart, selectionEnd, compositionStart, compositionEnd);
        this.mLastUpdateSelectionStart = selectionStart;
        this.mLastUpdateSelectionEnd = selectionEnd;
        this.mLastUpdateCompositionStart = compositionStart;
        this.mLastUpdateCompositionEnd = compositionEnd;
    }

    public boolean setComposingText(CharSequence text, int newCursorPosition) {
        if (this.maybePerformEmptyCompositionWorkaround(text)) {
            return true;
        }
        this.mPendingAccent = 0;
        super.setComposingText(text, newCursorPosition);
        this.updateSelectionIfRequired();
        return this.mImeAdapter.checkCompositionQueueAndCallNative(text, newCursorPosition, false);
    }

    public boolean commitText(CharSequence text, int newCursorPosition) {
        if (this.maybePerformEmptyCompositionWorkaround(text)) {
            return true;
        }
        this.mPendingAccent = 0;
        super.commitText(text, newCursorPosition);
        this.updateSelectionIfRequired();
        return this.mImeAdapter.checkCompositionQueueAndCallNative(text, newCursorPosition, text.length() > 0);
    }

    public boolean performEditorAction(int actionCode) {
        if (actionCode == 5) {
            this.restartInput();
            long timeStampMs = SystemClock.uptimeMillis();
            this.mImeAdapter.sendSyntheticKeyEvent(7, timeStampMs, 61, 0, 0);
        } else {
            this.mImeAdapter.sendKeyEventWithKeyCode(66, 22);
        }
        return true;
    }

    public boolean performContextMenuAction(int id2) {
        return this.mImeAdapter.performContextMenuAction(id2);
    }

    public ExtractedText getExtractedText(ExtractedTextRequest request, int flags) {
        ExtractedText et = new ExtractedText();
        et.text = this.mEditable.toString();
        et.partialEndOffset = this.mEditable.length();
        et.selectionStart = Selection.getSelectionStart((CharSequence)this.mEditable);
        et.selectionEnd = Selection.getSelectionEnd((CharSequence)this.mEditable);
        et.flags = this.mSingleLine ? 1 : 0;
        return et;
    }

    public boolean beginBatchEdit() {
        ++this.mNumNestedBatchEdits;
        return true;
    }

    public boolean endBatchEdit() {
        if (this.mNumNestedBatchEdits == 0) {
            return false;
        }
        --this.mNumNestedBatchEdits;
        if (this.mNumNestedBatchEdits == 0) {
            this.updateSelectionIfRequired();
        }
        return this.mNumNestedBatchEdits != 0;
    }

    public boolean deleteSurroundingText(int beforeLength, int afterLength) {
        return this.deleteSurroundingTextImpl(beforeLength, afterLength, false);
    }

    @VisibleForTesting
    static boolean isIndexBetweenUtf16SurrogatePair(CharSequence str, int index) {
        return index > 0 && index < str.length() && Character.isHighSurrogate(str.charAt(index - 1)) && Character.isLowSurrogate(str.charAt(index));
    }

    private boolean deleteSurroundingTextImpl(int beforeLength, int afterLength, boolean fromPhysicalKey) {
        if (this.mPendingAccent != 0) {
            this.finishComposingText();
        }
        int originalBeforeLength = beforeLength;
        int originalAfterLength = afterLength;
        int selectionStart = Selection.getSelectionStart((CharSequence)this.mEditable);
        int selectionEnd = Selection.getSelectionEnd((CharSequence)this.mEditable);
        int availableBefore = selectionStart;
        int availableAfter = this.mEditable.length() - selectionEnd;
        beforeLength = Math.min(beforeLength, availableBefore);
        afterLength = Math.min(afterLength, availableAfter);
        if (AdapterInputConnection.isIndexBetweenUtf16SurrogatePair((CharSequence)this.mEditable, selectionStart - beforeLength)) {
            ++beforeLength;
        }
        if (AdapterInputConnection.isIndexBetweenUtf16SurrogatePair((CharSequence)this.mEditable, selectionEnd + afterLength)) {
            ++afterLength;
        }
        super.deleteSurroundingText(beforeLength, afterLength);
        this.updateSelectionIfRequired();
        if (fromPhysicalKey) {
            return true;
        }
        int keyCode = 0;
        if (originalBeforeLength == 1 && originalAfterLength == 0) {
            keyCode = 67;
        } else if (originalBeforeLength == 0 && originalAfterLength == 1) {
            keyCode = 112;
        }
        boolean result = true;
        if (keyCode == 0) {
            result = this.mImeAdapter.sendSyntheticKeyEvent(7, SystemClock.uptimeMillis(), keyCode, 0, 0);
            result &= this.mImeAdapter.deleteSurroundingText(beforeLength, afterLength);
            result &= this.mImeAdapter.sendSyntheticKeyEvent(9, SystemClock.uptimeMillis(), keyCode, 0, 0);
        } else {
            this.mImeAdapter.sendKeyEventWithKeyCode(keyCode, 6);
        }
        return result;
    }

    public boolean sendKeyEvent(KeyEvent event) {
        int action = event.getAction();
        int keycode = event.getKeyCode();
        int unicodeChar = event.getUnicodeChar();
        if (action != 0) {
            this.mImeAdapter.translateAndSendNativeEvents(event);
            return true;
        }
        if (keycode == 67) {
            this.deleteSurroundingTextImpl(1, 0, true);
        } else if (keycode == 112) {
            this.deleteSurroundingTextImpl(0, 1, true);
        } else if (keycode == 66) {
            this.finishComposingText();
        } else {
            if ((unicodeChar & Integer.MIN_VALUE) != 0) {
                int pendingAccent = unicodeChar & Integer.MAX_VALUE;
                StringBuilder builder = new StringBuilder();
                builder.appendCodePoint(pendingAccent);
                this.setComposingText(builder.toString(), 1);
                this.mPendingAccent = pendingAccent;
                return true;
            }
            if (this.mPendingAccent != 0 && unicodeChar != 0) {
                int combined = KeyEvent.getDeadChar((int)this.mPendingAccent, (int)unicodeChar);
                if (combined != 0) {
                    StringBuilder builder = new StringBuilder();
                    builder.appendCodePoint(combined);
                    this.commitText(builder.toString(), 1);
                    return true;
                }
                this.finishComposingText();
            }
        }
        this.replaceSelectionWithUnicodeChar(unicodeChar);
        this.mImeAdapter.translateAndSendNativeEvents(event);
        return true;
    }

    private void replaceSelectionWithUnicodeChar(int unicodeChar) {
        int selectionEnd;
        if (unicodeChar == 0) {
            return;
        }
        int selectionStart = Selection.getSelectionStart((CharSequence)this.mEditable);
        if (selectionStart > (selectionEnd = Selection.getSelectionEnd((CharSequence)this.mEditable))) {
            int temp = selectionStart;
            selectionStart = selectionEnd;
            selectionEnd = temp;
        }
        this.mEditable.replace(selectionStart, selectionEnd, (CharSequence)Character.toString((char)unicodeChar));
        this.updateSelectionIfRequired();
    }

    public boolean finishComposingText() {
        this.mPendingAccent = 0;
        if (AdapterInputConnection.getComposingSpanStart((Spannable)this.mEditable) == AdapterInputConnection.getComposingSpanEnd((Spannable)this.mEditable)) {
            return true;
        }
        super.finishComposingText();
        this.updateSelectionIfRequired();
        this.mImeAdapter.finishComposingText();
        return true;
    }

    public boolean setSelection(int start, int end) {
        int textLength = this.mEditable.length();
        if (start < 0 || end < 0 || start > textLength || end > textLength) {
            return true;
        }
        super.setSelection(start, end);
        this.updateSelectionIfRequired();
        return this.mImeAdapter.setEditableSelectionOffsets(start, end);
    }

    void restartInput() {
        this.getInputMethodManagerWrapper().restartInput(this.mInternalView);
        this.mNumNestedBatchEdits = 0;
        this.mPendingAccent = 0;
    }

    public boolean setComposingRegion(int start, int end) {
        int textLength = this.mEditable.length();
        int a = Math.min(start, end);
        int b = Math.max(start, end);
        if (a < 0) {
            a = 0;
        }
        if (b < 0) {
            b = 0;
        }
        if (a > textLength) {
            a = textLength;
        }
        if (b > textLength) {
            b = textLength;
        }
        CharSequence regionText = null;
        if (a == b) {
            AdapterInputConnection.removeComposingSpans((Spannable)this.mEditable);
        } else {
            if (a == 0 && b == this.mEditable.length()) {
                regionText = this.mEditable.subSequence(a, b);
                for (int i = a; i < b; ++i) {
                    if (regionText.charAt(i) != '\ufffc') continue;
                    return true;
                }
            }
            super.setComposingRegion(a, b);
        }
        this.updateSelectionIfRequired();
        return this.mImeAdapter.setComposingRegion(regionText, a, b);
    }

    boolean isActive() {
        return this.getInputMethodManagerWrapper().isActive(this.mInternalView);
    }

    private InputMethodManagerWrapper getInputMethodManagerWrapper() {
        return this.mImeAdapter.getInputMethodManagerWrapper();
    }

    private boolean maybePerformEmptyCompositionWorkaround(CharSequence text) {
        int selectionStart = Selection.getSelectionStart((CharSequence)this.mEditable);
        int selectionEnd = Selection.getSelectionEnd((CharSequence)this.mEditable);
        int compositionStart = AdapterInputConnection.getComposingSpanStart((Spannable)this.mEditable);
        int compositionEnd = AdapterInputConnection.getComposingSpanEnd((Spannable)this.mEditable);
        if (TextUtils.isEmpty((CharSequence)text) && selectionStart == selectionEnd && compositionStart != -1 && compositionEnd != -1) {
            this.beginBatchEdit();
            this.finishComposingText();
            int selection = Selection.getSelectionStart((CharSequence)this.mEditable);
            this.deleteSurroundingText(selection - compositionStart, selection - compositionEnd);
            this.endBatchEdit();
            return true;
        }
        return false;
    }

    @VisibleForTesting
    ImeState getImeStateForTesting() {
        String text = this.mEditable.toString();
        int selectionStart = Selection.getSelectionStart((CharSequence)this.mEditable);
        int selectionEnd = Selection.getSelectionEnd((CharSequence)this.mEditable);
        int compositionStart = AdapterInputConnection.getComposingSpanStart((Spannable)this.mEditable);
        int compositionEnd = AdapterInputConnection.getComposingSpanEnd((Spannable)this.mEditable);
        return new ImeState(text, selectionStart, selectionEnd, compositionStart, compositionEnd);
    }

    @VisibleForTesting
    static class ImeState {
        public final String text;
        public final int selectionStart;
        public final int selectionEnd;
        public final int compositionStart;
        public final int compositionEnd;

        public ImeState(String text, int selectionStart, int selectionEnd, int compositionStart, int compositionEnd) {
            this.text = text;
            this.selectionStart = selectionStart;
            this.selectionEnd = selectionEnd;
            this.compositionStart = compositionStart;
            this.compositionEnd = compositionEnd;
        }
    }
}

