/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser.input;

import android.os.Handler;
import android.os.ResultReceiver;
import android.os.SystemClock;
import android.text.Editable;
import android.text.SpannableString;
import android.text.style.BackgroundColorSpan;
import android.text.style.CharacterStyle;
import android.text.style.UnderlineSpan;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.View;
import android.view.inputmethod.EditorInfo;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;
import org.chromium.base.VisibleForTesting;
import org.chromium.content.browser.input.AdapterInputConnection;
import org.chromium.content.browser.input.InputMethodManagerWrapper;
import org.chromium.ui.picker.InputDialogContainer;

@JNINamespace(value="content")
public class ImeAdapter {
    private static final int COMPOSITION_KEY_CODE = 229;
    private static final int INPUT_DISMISS_DELAY = 150;
    private final Runnable mDismissInputRunnable = new Runnable(){

        @Override
        public void run() {
            ImeAdapter.this.dismissInput(true);
        }
    };
    static char[] sSingleCharArray = new char[1];
    static KeyCharacterMap sKeyCharacterMap;
    private long mNativeImeAdapterAndroid;
    private InputMethodManagerWrapper mInputMethodManagerWrapper;
    private AdapterInputConnection mInputConnection;
    private final ImeAdapterDelegate mViewEmbedder;
    private final Handler mHandler;
    private int mTextInputType;
    private int mTextInputFlags;
    private String mLastComposeText;
    @VisibleForTesting
    int mLastSyntheticKeyCode;
    @VisibleForTesting
    boolean mIsShowWithoutHideOutstanding = false;

    public ImeAdapter(InputMethodManagerWrapper wrapper, ImeAdapterDelegate embedder) {
        this.mInputMethodManagerWrapper = wrapper;
        this.mViewEmbedder = embedder;
        this.mHandler = new Handler();
    }

    @VisibleForTesting
    public void setInputMethodManagerWrapper(InputMethodManagerWrapper immw) {
        this.mInputMethodManagerWrapper = immw;
    }

    InputMethodManagerWrapper getInputMethodManagerWrapper() {
        return this.mInputMethodManagerWrapper;
    }

    void setInputConnection(AdapterInputConnection inputConnection) {
        this.mInputConnection = inputConnection;
        this.mLastComposeText = null;
    }

    int getTextInputType() {
        return this.mTextInputType;
    }

    int getTextInputFlags() {
        return this.mTextInputFlags;
    }

    private static int getModifiers(int metaState) {
        int modifiers = 0;
        if ((metaState & 1) != 0) {
            modifiers |= 1;
        }
        if ((metaState & 2) != 0) {
            modifiers |= 4;
        }
        if ((metaState & 0x1000) != 0) {
            modifiers |= 2;
        }
        if ((metaState & 0x100000) != 0) {
            modifiers |= 0x200;
        }
        if ((metaState & 0x200000) != 0) {
            modifiers |= 0x400;
        }
        return modifiers;
    }

    public void updateKeyboardVisibility(long nativeImeAdapter, int textInputType, int textInputFlags, boolean showIfNeeded) {
        if (this.mTextInputType == 0 && !showIfNeeded) {
            return;
        }
        if (this.mNativeImeAdapterAndroid != nativeImeAdapter || this.mTextInputType != textInputType) {
            this.attach(nativeImeAdapter, textInputType, textInputFlags, true);
            if (this.mTextInputType != 0) {
                this.mInputMethodManagerWrapper.restartInput(this.mViewEmbedder.getAttachedView());
                if (showIfNeeded) {
                    this.showKeyboard();
                }
            }
        } else if (this.hasInputType() && showIfNeeded) {
            this.showKeyboard();
        }
    }

    private void attach(long nativeImeAdapter, int textInputType, int textInputFlags, boolean delayDismissInput) {
        if (this.mNativeImeAdapterAndroid != 0L) {
            this.nativeResetImeAdapter(this.mNativeImeAdapterAndroid);
        }
        if (nativeImeAdapter != 0L) {
            this.nativeAttachImeAdapter(nativeImeAdapter);
        }
        this.mNativeImeAdapterAndroid = nativeImeAdapter;
        this.mLastComposeText = null;
        this.mTextInputFlags = textInputFlags;
        if (textInputType == this.mTextInputType) {
            return;
        }
        this.mTextInputType = textInputType;
        this.mHandler.removeCallbacks(this.mDismissInputRunnable);
        if (this.mTextInputType == 0) {
            if (delayDismissInput) {
                this.mHandler.postDelayed(this.mDismissInputRunnable, 150L);
                this.mIsShowWithoutHideOutstanding = false;
            } else {
                this.dismissInput(true);
            }
        }
    }

    public void attach(long nativeImeAdapter) {
        this.attach(nativeImeAdapter, 0, 0, false);
    }

    private void showKeyboard() {
        this.mIsShowWithoutHideOutstanding = true;
        this.mInputMethodManagerWrapper.showSoftInput(this.mViewEmbedder.getAttachedView(), 0, this.mViewEmbedder.getNewShowKeyboardReceiver());
        if (this.mViewEmbedder.getAttachedView().getResources().getConfiguration().keyboard != 1) {
            this.mViewEmbedder.onKeyboardBoundsUnchanged();
        }
    }

    private void dismissInput(boolean unzoomIfNeeded) {
        this.mIsShowWithoutHideOutstanding = false;
        View view = this.mViewEmbedder.getAttachedView();
        if (this.mInputMethodManagerWrapper.isActive(view)) {
            this.mInputMethodManagerWrapper.hideSoftInputFromWindow(view.getWindowToken(), 0, unzoomIfNeeded ? this.mViewEmbedder.getNewShowKeyboardReceiver() : null);
        }
    }

    private boolean hasInputType() {
        return this.mTextInputType != 0;
    }

    private static boolean isTextInputType(int type) {
        return type != 0 && !InputDialogContainer.isDialogInputType(type);
    }

    public boolean hasTextInputType() {
        return ImeAdapter.isTextInputType(this.mTextInputType);
    }

    public boolean isSelectionPassword() {
        return this.mTextInputType == 2;
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        if (this.mInputConnection != null) {
            return this.mInputConnection.sendKeyEvent(event);
        }
        return this.translateAndSendNativeEvents(event);
    }

    private int shouldSendKeyEventWithKeyCode(String text) {
        if (text.length() != 1) {
            return 229;
        }
        if (text.equals("\n")) {
            return 66;
        }
        if (text.equals("\t")) {
            return 61;
        }
        return 229;
    }

    private static KeyEvent androidKeyEventForCharacter(char chr) {
        if (sKeyCharacterMap == null) {
            sKeyCharacterMap = KeyCharacterMap.load((int)-1);
        }
        ImeAdapter.sSingleCharArray[0] = chr;
        KeyEvent[] events = sKeyCharacterMap.getEvents(sSingleCharArray);
        if (events == null) {
            return null;
        }
        for (int i = 0; i < events.length; ++i) {
            if (events[i].getAction() != 0 || KeyEvent.isModifierKey((int)events[i].getKeyCode())) continue;
            return events[i];
        }
        return null;
    }

    public boolean performContextMenuAction(int id2) {
        return this.mViewEmbedder.performContextMenuAction(id2);
    }

    @VisibleForTesting
    public static KeyEvent getTypedKeyEventGuess(String oldtext, String newtext) {
        if (oldtext == null) {
            if (newtext.length() == 1) {
                return ImeAdapter.androidKeyEventForCharacter(newtext.charAt(0));
            }
            return null;
        }
        if (newtext.length() > oldtext.length() && newtext.startsWith(oldtext)) {
            return ImeAdapter.androidKeyEventForCharacter(newtext.charAt(newtext.length() - 1));
        }
        if (oldtext.length() > newtext.length() && oldtext.startsWith(newtext)) {
            return new KeyEvent(0, 67);
        }
        return null;
    }

    void sendKeyEventWithKeyCode(int keyCode, int flags) {
        long eventTime = SystemClock.uptimeMillis();
        this.mLastSyntheticKeyCode = keyCode;
        this.translateAndSendNativeEvents(new KeyEvent(eventTime, eventTime, 0, keyCode, 0, 0, -1, 0, flags));
        this.translateAndSendNativeEvents(new KeyEvent(SystemClock.uptimeMillis(), eventTime, 1, keyCode, 0, 0, -1, 0, flags));
    }

    boolean checkCompositionQueueAndCallNative(CharSequence text, int newCursorPosition, boolean isCommit) {
        if (this.mNativeImeAdapterAndroid == 0L) {
            return false;
        }
        this.mViewEmbedder.onImeEvent();
        String textStr = text.toString();
        int keyCode = this.shouldSendKeyEventWithKeyCode(textStr);
        long timeStampMs = SystemClock.uptimeMillis();
        if (keyCode != 229) {
            this.sendKeyEventWithKeyCode(keyCode, 6);
        } else {
            KeyEvent keyEvent = ImeAdapter.getTypedKeyEventGuess(this.mLastComposeText, textStr);
            int modifiers = 0;
            if (keyEvent != null) {
                keyCode = keyEvent.getKeyCode();
                modifiers = ImeAdapter.getModifiers(keyEvent.getMetaState());
            } else {
                keyCode = !textStr.equals(this.mLastComposeText) ? 0 : -1;
            }
            if (keyCode > 0 && isCommit && this.mLastComposeText == null && textStr.length() == 1) {
                this.mLastSyntheticKeyCode = keyCode;
                return this.translateAndSendNativeEvents(keyEvent) && this.translateAndSendNativeEvents(KeyEvent.changeAction((KeyEvent)keyEvent, (int)1));
            }
            keyCode = 229;
            modifiers = 0;
            if (keyCode >= 0) {
                this.nativeSendSyntheticKeyEvent(this.mNativeImeAdapterAndroid, 7, timeStampMs, keyCode, modifiers, 0);
            }
            if (isCommit) {
                this.nativeCommitText(this.mNativeImeAdapterAndroid, textStr);
                textStr = null;
            } else {
                this.nativeSetComposingText(this.mNativeImeAdapterAndroid, text, textStr, newCursorPosition);
            }
            if (keyCode >= 0) {
                this.nativeSendSyntheticKeyEvent(this.mNativeImeAdapterAndroid, 9, timeStampMs, keyCode, modifiers, 0);
            }
            this.mLastSyntheticKeyCode = keyCode;
        }
        this.mLastComposeText = textStr;
        return true;
    }

    @VisibleForTesting
    protected void finishComposingText() {
        this.mLastComposeText = null;
        if (this.mNativeImeAdapterAndroid == 0L) {
            return;
        }
        this.nativeFinishComposingText(this.mNativeImeAdapterAndroid);
    }

    boolean translateAndSendNativeEvents(KeyEvent event) {
        if (this.mNativeImeAdapterAndroid == 0L) {
            return false;
        }
        int action = event.getAction();
        if (action != 0 && action != 1) {
            return false;
        }
        this.mViewEmbedder.onImeEvent();
        return this.nativeSendKeyEvent(this.mNativeImeAdapterAndroid, event, event.getAction(), ImeAdapter.getModifiers(event.getMetaState()), event.getEventTime(), event.getKeyCode(), false, event.getUnicodeChar());
    }

    boolean sendSyntheticKeyEvent(int eventType, long timestampMs, int keyCode, int modifiers, int unicodeChar) {
        if (this.mNativeImeAdapterAndroid == 0L) {
            return false;
        }
        this.nativeSendSyntheticKeyEvent(this.mNativeImeAdapterAndroid, eventType, timestampMs, keyCode, modifiers, unicodeChar);
        return true;
    }

    boolean deleteSurroundingText(int beforeLength, int afterLength) {
        this.mViewEmbedder.onImeEvent();
        if (this.mNativeImeAdapterAndroid == 0L) {
            return false;
        }
        this.nativeDeleteSurroundingText(this.mNativeImeAdapterAndroid, beforeLength, afterLength);
        return true;
    }

    boolean setEditableSelectionOffsets(int start, int end) {
        if (this.mNativeImeAdapterAndroid == 0L) {
            return false;
        }
        this.nativeSetEditableSelectionOffsets(this.mNativeImeAdapterAndroid, start, end);
        return true;
    }

    boolean setComposingRegion(CharSequence text, int start, int end) {
        if (this.mNativeImeAdapterAndroid == 0L) {
            return false;
        }
        this.nativeSetComposingRegion(this.mNativeImeAdapterAndroid, start, end);
        this.mLastComposeText = text != null ? text.toString() : null;
        return true;
    }

    @CalledByNative
    private void focusedNodeChanged(boolean isEditable) {
        if (this.mInputConnection != null && isEditable) {
            this.mInputConnection.restartInput();
        }
    }

    @CalledByNative
    private void populateUnderlinesFromSpans(CharSequence text, long underlines) {
        CharacterStyle[] spans;
        if (!(text instanceof SpannableString)) {
            return;
        }
        SpannableString spannableString = (SpannableString)text;
        for (CharacterStyle span : spans = (CharacterStyle[])spannableString.getSpans(0, text.length(), CharacterStyle.class)) {
            if (span instanceof BackgroundColorSpan) {
                ImeAdapter.nativeAppendBackgroundColorSpan(underlines, spannableString.getSpanStart((Object)span), spannableString.getSpanEnd((Object)span), ((BackgroundColorSpan)span).getBackgroundColor());
                continue;
            }
            if (!(span instanceof UnderlineSpan)) continue;
            ImeAdapter.nativeAppendUnderlineSpan(underlines, spannableString.getSpanStart((Object)span), spannableString.getSpanEnd((Object)span));
        }
    }

    @CalledByNative
    private void cancelComposition() {
        if (this.mInputConnection != null) {
            this.mInputConnection.restartInput();
        }
        this.mLastComposeText = null;
    }

    @CalledByNative
    void detach() {
        this.mHandler.removeCallbacks(this.mDismissInputRunnable);
        this.mNativeImeAdapterAndroid = 0L;
        this.mTextInputType = 0;
    }

    private native boolean nativeSendSyntheticKeyEvent(long var1, int var3, long var4, int var6, int var7, int var8);

    private native boolean nativeSendKeyEvent(long var1, KeyEvent var3, int var4, int var5, long var6, int var8, boolean var9, int var10);

    private static native void nativeAppendUnderlineSpan(long var0, int var2, int var3);

    private static native void nativeAppendBackgroundColorSpan(long var0, int var2, int var3, int var4);

    private native void nativeSetComposingText(long var1, CharSequence var3, String var4, int var5);

    private native void nativeCommitText(long var1, String var3);

    private native void nativeFinishComposingText(long var1);

    private native void nativeAttachImeAdapter(long var1);

    private native void nativeSetEditableSelectionOffsets(long var1, int var3, int var4);

    private native void nativeSetComposingRegion(long var1, int var3, int var4);

    private native void nativeDeleteSurroundingText(long var1, int var3, int var4);

    private native void nativeResetImeAdapter(long var1);

    public static class AdapterInputConnectionFactory {
        public AdapterInputConnection get(View view, ImeAdapter imeAdapter, Editable editable, EditorInfo outAttrs) {
            return new AdapterInputConnection(view, imeAdapter, editable, outAttrs);
        }
    }

    public static interface ImeAdapterDelegate {
        public void onImeEvent();

        public void onKeyboardBoundsUnchanged();

        public boolean performContextMenuAction(int var1);

        public View getAttachedView();

        public ResultReceiver getNewShowKeyboardReceiver();
    }
}

