/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser.input;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.AnimationUtils;
import android.widget.PopupWindow;
import java.lang.ref.WeakReference;
import org.chromium.base.ApiCompatibilityUtils;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;
import org.chromium.content.browser.PositionObserver;
import org.chromium.content.browser.input.HandleViewResources;

@JNINamespace(value="content")
public class PopupTouchHandleDrawable
extends View {
    private Drawable mDrawable;
    private final PopupWindow mContainer;
    private final Context mContext;
    private final PositionObserver.Listener mParentPositionListener;
    private final WeakReference<PopupTouchHandleDrawableDelegate> mDelegate;
    private PositionObserver mParentPositionObserver;
    private int mPositionX;
    private int mPositionY;
    private int mParentPositionX;
    private int mParentPositionY;
    private float mHotspotX;
    private float mHotspotY;
    private float mAlpha;
    private final int[] mTempScreenCoords = new int[2];
    private int mOrientation = 3;
    private static final int FADE_IN_DELAY_MS = 300;
    private static final int FADE_IN_DURATION_MS = 200;
    private Runnable mDeferredHandleFadeInRunnable;
    private long mFadeStartTime;
    private boolean mVisible;
    private boolean mTemporarilyHidden;
    private boolean mDelayVisibilityUpdateWAR;
    private Runnable mInvalidationRunnable;
    private boolean mHasPendingInvalidate;

    public PopupTouchHandleDrawable(PopupTouchHandleDrawableDelegate delegate) {
        super(delegate.getParent().getContext());
        this.mContext = delegate.getParent().getContext();
        this.mDelegate = new WeakReference<PopupTouchHandleDrawableDelegate>(delegate);
        this.mContainer = new PopupWindow(this.mContext, null, 16843464);
        this.mContainer.setSplitTouchEnabled(true);
        this.mContainer.setClippingEnabled(false);
        this.mContainer.setAnimationStyle(0);
        this.mAlpha = 1.0f;
        this.mVisible = this.getVisibility() == 0;
        this.mParentPositionListener = new PositionObserver.Listener(){

            @Override
            public void onPositionChanged(int x, int y) {
                PopupTouchHandleDrawable.this.updateParentPosition(x, y);
            }
        };
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent event) {
        PopupTouchHandleDrawableDelegate delegate = this.getDelegateAndHideIfNull();
        if (delegate == null) {
            return false;
        }
        delegate.getParent().getLocationOnScreen(this.mTempScreenCoords);
        float offsetX = event.getRawX() - event.getX() - (float)this.mTempScreenCoords[0];
        float offsetY = event.getRawY() - event.getY() - (float)this.mTempScreenCoords[1];
        MotionEvent offsetEvent = MotionEvent.obtainNoHistory((MotionEvent)event);
        offsetEvent.offsetLocation(offsetX, offsetY);
        boolean handled = delegate.onTouchHandleEvent(offsetEvent);
        offsetEvent.recycle();
        return handled;
    }

    @CalledByNative
    private void setOrientation(int orientation) {
        assert (orientation >= 0 && orientation <= 3);
        if (this.mOrientation == orientation) {
            return;
        }
        boolean hadValidOrientation = this.mOrientation != 3;
        this.mOrientation = orientation;
        int oldAdjustedPositionX = this.getAdjustedPositionX();
        int oldAdjustedPositionY = this.getAdjustedPositionY();
        switch (orientation) {
            case 0: {
                this.mDrawable = HandleViewResources.getLeftHandleDrawable(this.mContext);
                this.mHotspotX = (float)(this.mDrawable.getIntrinsicWidth() * 3) / 4.0f;
                break;
            }
            case 2: {
                this.mDrawable = HandleViewResources.getRightHandleDrawable(this.mContext);
                this.mHotspotX = (float)this.mDrawable.getIntrinsicWidth() / 4.0f;
                break;
            }
            case 1: {
                this.mDrawable = HandleViewResources.getCenterHandleDrawable(this.mContext);
                this.mHotspotX = (float)this.mDrawable.getIntrinsicWidth() / 2.0f;
                break;
            }
        }
        this.mHotspotY = 0.0f;
        if (hadValidOrientation) {
            this.setFocus(oldAdjustedPositionX, oldAdjustedPositionY);
        }
        this.mDrawable.setAlpha((int)(255.0f * this.mAlpha));
        this.scheduleInvalidate();
    }

    private void updateParentPosition(int parentPositionX, int parentPositionY) {
        if (this.mParentPositionX == parentPositionX && this.mParentPositionY == parentPositionY) {
            return;
        }
        this.mParentPositionX = parentPositionX;
        this.mParentPositionY = parentPositionY;
        this.temporarilyHide();
    }

    private int getContainerPositionX() {
        return this.mParentPositionX + this.mPositionX;
    }

    private int getContainerPositionY() {
        return this.mParentPositionY + this.mPositionY;
    }

    private void updatePosition() {
        this.mContainer.update(this.getContainerPositionX(), this.getContainerPositionY(), this.getRight() - this.getLeft(), this.getBottom() - this.getTop());
    }

    private void updateVisibility() {
        int newVisibility;
        int n = newVisibility = this.mVisible && !this.mTemporarilyHidden ? 0 : 4;
        if (newVisibility == 0 && this.getVisibility() != 0 && !this.mDelayVisibilityUpdateWAR) {
            this.mDelayVisibilityUpdateWAR = true;
            this.scheduleInvalidate();
            return;
        }
        this.mDelayVisibilityUpdateWAR = false;
        this.setVisibility(newVisibility);
    }

    private void updateAlpha() {
        if (this.mAlpha == 1.0f) {
            return;
        }
        long currentTimeMillis = AnimationUtils.currentAnimationTimeMillis();
        this.mAlpha = Math.min(1.0f, (float)(currentTimeMillis - this.mFadeStartTime) / 200.0f);
        this.mDrawable.setAlpha((int)(255.0f * this.mAlpha));
        this.scheduleInvalidate();
    }

    private void temporarilyHide() {
        this.mTemporarilyHidden = true;
        this.updateVisibility();
        this.rescheduleFadeIn();
    }

    private void doInvalidate() {
        if (!this.mContainer.isShowing()) {
            return;
        }
        this.updateVisibility();
        this.updatePosition();
        this.invalidate();
    }

    private void scheduleInvalidate() {
        if (this.mInvalidationRunnable == null) {
            this.mInvalidationRunnable = new Runnable(){

                @Override
                public void run() {
                    PopupTouchHandleDrawable.this.mHasPendingInvalidate = false;
                    PopupTouchHandleDrawable.this.doInvalidate();
                }
            };
        }
        if (this.mHasPendingInvalidate) {
            return;
        }
        this.mHasPendingInvalidate = true;
        ApiCompatibilityUtils.postOnAnimation(this, this.mInvalidationRunnable);
    }

    private void rescheduleFadeIn() {
        if (this.mDeferredHandleFadeInRunnable == null) {
            this.mDeferredHandleFadeInRunnable = new Runnable(){

                @Override
                public void run() {
                    if (PopupTouchHandleDrawable.this.isScrollInProgress()) {
                        PopupTouchHandleDrawable.this.rescheduleFadeIn();
                        return;
                    }
                    PopupTouchHandleDrawable.this.mTemporarilyHidden = false;
                    PopupTouchHandleDrawable.this.beginFadeIn();
                }
            };
        }
        this.removeCallbacks(this.mDeferredHandleFadeInRunnable);
        ApiCompatibilityUtils.postOnAnimationDelayed(this, this.mDeferredHandleFadeInRunnable, 300L);
    }

    private void beginFadeIn() {
        if (this.getVisibility() == 0) {
            return;
        }
        this.mAlpha = 0.0f;
        this.mFadeStartTime = AnimationUtils.currentAnimationTimeMillis();
        this.doInvalidate();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mDrawable == null) {
            this.setMeasuredDimension(0, 0);
            return;
        }
        this.setMeasuredDimension(this.mDrawable.getIntrinsicWidth(), this.mDrawable.getIntrinsicHeight());
    }

    protected void onDraw(Canvas c) {
        if (this.mDrawable == null) {
            return;
        }
        this.updateAlpha();
        this.mDrawable.setBounds(0, 0, this.getRight() - this.getLeft(), this.getBottom() - this.getTop());
        this.mDrawable.draw(c);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.hide();
    }

    private int getAdjustedPositionX() {
        return this.mPositionX + Math.round(this.mHotspotX);
    }

    private int getAdjustedPositionY() {
        return this.mPositionY + Math.round(this.mHotspotY);
    }

    private PopupTouchHandleDrawableDelegate getDelegateAndHideIfNull() {
        PopupTouchHandleDrawableDelegate delegate = (PopupTouchHandleDrawableDelegate)this.mDelegate.get();
        if (delegate == null) {
            this.hide();
        }
        return delegate;
    }

    private boolean isScrollInProgress() {
        PopupTouchHandleDrawableDelegate delegate = this.getDelegateAndHideIfNull();
        if (delegate == null) {
            return false;
        }
        return delegate.isScrollInProgress();
    }

    @CalledByNative
    private void show() {
        if (this.mContainer.isShowing()) {
            return;
        }
        PopupTouchHandleDrawableDelegate delegate = this.getDelegateAndHideIfNull();
        if (delegate == null) {
            return;
        }
        this.mParentPositionObserver = delegate.getParentPositionObserver();
        assert (this.mParentPositionObserver != null);
        this.updateParentPosition(this.mParentPositionObserver.getPositionX(), this.mParentPositionObserver.getPositionY());
        this.mParentPositionObserver.addListener(this.mParentPositionListener);
        this.mContainer.setContentView((View)this);
        this.mContainer.showAtLocation(delegate.getParent(), 0, this.getContainerPositionX(), this.getContainerPositionY());
    }

    @CalledByNative
    private void hide() {
        this.mTemporarilyHidden = false;
        this.mAlpha = 1.0f;
        if (this.mDeferredHandleFadeInRunnable != null) {
            this.removeCallbacks(this.mDeferredHandleFadeInRunnable);
        }
        if (this.mContainer.isShowing()) {
            this.mContainer.dismiss();
        }
        if (this.mParentPositionObserver != null) {
            this.mParentPositionObserver.removeListener(this.mParentPositionListener);
            this.mParentPositionObserver = null;
        }
    }

    @CalledByNative
    private void setFocus(float focusX, float focusY) {
        int x = (int)focusX - Math.round(this.mHotspotX);
        int y = (int)focusY - Math.round(this.mHotspotY);
        if (this.mPositionX == x && this.mPositionY == y) {
            return;
        }
        this.mPositionX = x;
        this.mPositionY = y;
        if (this.isScrollInProgress()) {
            this.temporarilyHide();
        } else {
            this.scheduleInvalidate();
        }
    }

    @CalledByNative
    private void setVisible(boolean visible) {
        int visibility;
        this.mVisible = visible;
        int n = visibility = visible ? 0 : 4;
        if (this.getVisibility() == visibility) {
            return;
        }
        this.scheduleInvalidate();
    }

    @CalledByNative
    private int getPositionX() {
        return this.mPositionX;
    }

    @CalledByNative
    private int getPositionY() {
        return this.mPositionY;
    }

    @CalledByNative
    private int getVisibleWidth() {
        if (this.mDrawable == null) {
            return 0;
        }
        return this.mDrawable.getIntrinsicWidth();
    }

    @CalledByNative
    private int getVisibleHeight() {
        if (this.mDrawable == null) {
            return 0;
        }
        return this.mDrawable.getIntrinsicHeight();
    }

    public static interface PopupTouchHandleDrawableDelegate {
        public View getParent();

        public PositionObserver getParentPositionObserver();

        public boolean onTouchHandleEvent(MotionEvent var1);

        public boolean isScrollInProgress();
    }
}

