/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser.webcontents;

import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;
import org.chromium.base.ObserverList;
import org.chromium.base.ThreadUtils;
import org.chromium.content.browser.webcontents.WebContentsImpl;
import org.chromium.content_public.browser.WebContentsObserver;

@JNINamespace(value="content")
class WebContentsObserverProxy
extends WebContentsObserver {
    private long mNativeWebContentsObserverProxy;
    private final ObserverList<WebContentsObserver> mObservers;
    private final ObserverList.RewindableIterator<WebContentsObserver> mObserversIterator;

    public WebContentsObserverProxy(WebContentsImpl webContents) {
        ThreadUtils.assertOnUiThread();
        this.mNativeWebContentsObserverProxy = this.nativeInit(webContents);
        this.mObservers = new ObserverList();
        this.mObserversIterator = this.mObservers.rewindableIterator();
    }

    void addObserver(WebContentsObserver observer) {
        assert (this.mNativeWebContentsObserverProxy != 0L);
        this.mObservers.addObserver(observer);
    }

    void removeObserver(WebContentsObserver observer) {
        this.mObservers.removeObserver(observer);
    }

    boolean hasObservers() {
        return !this.mObservers.isEmpty();
    }

    @Override
    @CalledByNative
    public void renderViewReady() {
        this.mObserversIterator.rewind();
        while (this.mObserversIterator.hasNext()) {
            ((WebContentsObserver)this.mObserversIterator.next()).renderViewReady();
        }
    }

    @Override
    @CalledByNative
    public void renderProcessGone(boolean wasOomProtected) {
        this.mObserversIterator.rewind();
        while (this.mObserversIterator.hasNext()) {
            ((WebContentsObserver)this.mObserversIterator.next()).renderProcessGone(wasOomProtected);
        }
    }

    @Override
    @CalledByNative
    public void didStartLoading(String url) {
        this.mObserversIterator.rewind();
        while (this.mObserversIterator.hasNext()) {
            ((WebContentsObserver)this.mObserversIterator.next()).didStartLoading(url);
        }
    }

    @Override
    @CalledByNative
    public void didStopLoading(String url) {
        this.mObserversIterator.rewind();
        while (this.mObserversIterator.hasNext()) {
            ((WebContentsObserver)this.mObserversIterator.next()).didStopLoading(url);
        }
    }

    @Override
    @CalledByNative
    public void didFailLoad(boolean isProvisionalLoad, boolean isMainFrame, int errorCode, String description, String failingUrl, boolean wasIgnoredByHandler) {
        this.mObserversIterator.rewind();
        while (this.mObserversIterator.hasNext()) {
            ((WebContentsObserver)this.mObserversIterator.next()).didFailLoad(isProvisionalLoad, isMainFrame, errorCode, description, failingUrl, wasIgnoredByHandler);
        }
    }

    @Override
    @CalledByNative
    public void didNavigateMainFrame(String url, String baseUrl, boolean isNavigationToDifferentPage, boolean isFragmentNavigation, int statusCode) {
        this.mObserversIterator.rewind();
        while (this.mObserversIterator.hasNext()) {
            ((WebContentsObserver)this.mObserversIterator.next()).didNavigateMainFrame(url, baseUrl, isNavigationToDifferentPage, isFragmentNavigation, statusCode);
        }
    }

    @Override
    @CalledByNative
    public void didFirstVisuallyNonEmptyPaint() {
        this.mObserversIterator.rewind();
        while (this.mObserversIterator.hasNext()) {
            ((WebContentsObserver)this.mObserversIterator.next()).didFirstVisuallyNonEmptyPaint();
        }
    }

    @Override
    @CalledByNative
    public void didNavigateAnyFrame(String url, String baseUrl, boolean isReload) {
        this.mObserversIterator.rewind();
        while (this.mObserversIterator.hasNext()) {
            ((WebContentsObserver)this.mObserversIterator.next()).didNavigateAnyFrame(url, baseUrl, isReload);
        }
    }

    @Override
    @CalledByNative
    public void documentAvailableInMainFrame() {
        this.mObserversIterator.rewind();
        while (this.mObserversIterator.hasNext()) {
            ((WebContentsObserver)this.mObserversIterator.next()).documentAvailableInMainFrame();
        }
    }

    @Override
    @CalledByNative
    public void didStartProvisionalLoadForFrame(long frameId, long parentFrameId, boolean isMainFrame, String validatedUrl, boolean isErrorPage, boolean isIframeSrcdoc) {
        this.mObserversIterator.rewind();
        while (this.mObserversIterator.hasNext()) {
            ((WebContentsObserver)this.mObserversIterator.next()).didStartProvisionalLoadForFrame(frameId, parentFrameId, isMainFrame, validatedUrl, isErrorPage, isIframeSrcdoc);
        }
    }

    @Override
    @CalledByNative
    public void didCommitProvisionalLoadForFrame(long frameId, boolean isMainFrame, String url, int transitionType) {
        this.mObserversIterator.rewind();
        while (this.mObserversIterator.hasNext()) {
            ((WebContentsObserver)this.mObserversIterator.next()).didCommitProvisionalLoadForFrame(frameId, isMainFrame, url, transitionType);
        }
    }

    @Override
    @CalledByNative
    public void didFinishLoad(long frameId, String validatedUrl, boolean isMainFrame) {
        this.mObserversIterator.rewind();
        while (this.mObserversIterator.hasNext()) {
            ((WebContentsObserver)this.mObserversIterator.next()).didFinishLoad(frameId, validatedUrl, isMainFrame);
        }
    }

    @Override
    @CalledByNative
    public void documentLoadedInFrame(long frameId) {
        this.mObserversIterator.rewind();
        while (this.mObserversIterator.hasNext()) {
            ((WebContentsObserver)this.mObserversIterator.next()).documentLoadedInFrame(frameId);
        }
    }

    @Override
    @CalledByNative
    public void navigationEntryCommitted() {
        this.mObserversIterator.rewind();
        while (this.mObserversIterator.hasNext()) {
            ((WebContentsObserver)this.mObserversIterator.next()).navigationEntryCommitted();
        }
    }

    @Override
    @CalledByNative
    public void didAttachInterstitialPage() {
        this.mObserversIterator.rewind();
        while (this.mObserversIterator.hasNext()) {
            ((WebContentsObserver)this.mObserversIterator.next()).didAttachInterstitialPage();
        }
    }

    @Override
    @CalledByNative
    public void didDetachInterstitialPage() {
        this.mObserversIterator.rewind();
        while (this.mObserversIterator.hasNext()) {
            ((WebContentsObserver)this.mObserversIterator.next()).didDetachInterstitialPage();
        }
    }

    @Override
    @CalledByNative
    public void didChangeThemeColor(int color2) {
        this.mObserversIterator.rewind();
        while (this.mObserversIterator.hasNext()) {
            ((WebContentsObserver)this.mObserversIterator.next()).didChangeThemeColor(color2);
        }
    }

    @Override
    @CalledByNative
    public void didStartNavigationToPendingEntry(String url) {
        this.mObserversIterator.rewind();
        while (this.mObserversIterator.hasNext()) {
            ((WebContentsObserver)this.mObserversIterator.next()).didStartNavigationToPendingEntry(url);
        }
    }

    @Override
    @CalledByNative
    public void mediaSessionStateChanged(boolean isControllable, boolean isSuspended) {
        this.mObserversIterator.rewind();
        while (this.mObserversIterator.hasNext()) {
            ((WebContentsObserver)this.mObserversIterator.next()).mediaSessionStateChanged(isControllable, isSuspended);
        }
    }

    @Override
    @CalledByNative
    public void destroy() {
        ThreadUtils.assertOnUiThread();
        this.mObserversIterator.rewind();
        while (this.mObserversIterator.hasNext()) {
            ((WebContentsObserver)this.mObserversIterator.next()).destroy();
        }
        assert (this.mObservers.isEmpty());
        this.mObservers.clear();
        if (this.mNativeWebContentsObserverProxy != 0L) {
            this.nativeDestroy(this.mNativeWebContentsObserverProxy);
            this.mNativeWebContentsObserverProxy = 0L;
        }
    }

    private native long nativeInit(WebContentsImpl var1);

    private native void nativeDestroy(long var1);
}

