/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.common;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.Surface;
import org.chromium.content.common.SurfaceWrapper;

public interface IChildProcessCallback
extends IInterface {
    public void establishSurfacePeer(int var1, Surface var2, int var3, int var4) throws RemoteException;

    public SurfaceWrapper getViewSurface(int var1) throws RemoteException;

    public void registerSurfaceTextureSurface(int var1, int var2, Surface var3) throws RemoteException;

    public void unregisterSurfaceTextureSurface(int var1, int var2) throws RemoteException;

    public SurfaceWrapper getSurfaceTextureSurface(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IChildProcessCallback {
        private static final String DESCRIPTOR = "org.chromium.content.common.IChildProcessCallback";
        static final int TRANSACTION_establishSurfacePeer = 1;
        static final int TRANSACTION_getViewSurface = 2;
        static final int TRANSACTION_registerSurfaceTextureSurface = 3;
        static final int TRANSACTION_unregisterSurfaceTextureSurface = 4;
        static final int TRANSACTION_getSurfaceTextureSurface = 5;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IChildProcessCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IChildProcessCallback) {
                return (IChildProcessCallback)iin;
            }
            return new Proxy(obj);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            switch (code) {
                case 1598968902: {
                    reply.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    Surface _arg1 = 0 != data.readInt() ? (Surface)Surface.CREATOR.createFromParcel(data) : null;
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    this.establishSurfacePeer(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 2: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    SurfaceWrapper _result = this.getViewSurface(_arg0);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 3: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    Surface _arg2 = 0 != data.readInt() ? (Surface)Surface.CREATOR.createFromParcel(data) : null;
                    this.registerSurfaceTextureSurface(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 4: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    this.unregisterSurfaceTextureSurface(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 5: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    SurfaceWrapper _result = this.getSurfaceTextureSurface(_arg0);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        private static class Proxy
        implements IChildProcessCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void establishSurfacePeer(int pid, Surface surface, int primaryID, int secondaryID) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(pid);
                    if (surface != null) {
                        _data.writeInt(1);
                        surface.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(primaryID);
                    _data.writeInt(secondaryID);
                    this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SurfaceWrapper getViewSurface(int surfaceId) throws RemoteException {
                SurfaceWrapper _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(surfaceId);
                    this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? (SurfaceWrapper)SurfaceWrapper.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerSurfaceTextureSurface(int surfaceTextureId, int clientId, Surface surface) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(surfaceTextureId);
                    _data.writeInt(clientId);
                    if (surface != null) {
                        _data.writeInt(1);
                        surface.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterSurfaceTextureSurface(int surfaceTextureId, int clientId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(surfaceTextureId);
                    _data.writeInt(clientId);
                    this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SurfaceWrapper getSurfaceTextureSurface(int surfaceTextureId) throws RemoteException {
                SurfaceWrapper _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(surfaceTextureId);
                    this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? (SurfaceWrapper)SurfaceWrapper.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }
}

