/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.device.battery;

import android.content.Context;
import android.util.Log;
import java.util.HashSet;
import org.chromium.base.ThreadUtils;
import org.chromium.device.battery.BatteryMonitorImpl;
import org.chromium.device.battery.BatteryStatusManager;
import org.chromium.mojom.device.BatteryMonitor;
import org.chromium.mojom.device.BatteryStatus;

public class BatteryMonitorFactory {
    static final String TAG = "BatteryMonitorFactory";
    private final BatteryStatusManager mManager;
    private final HashSet<BatteryMonitorImpl> mSubscribedMonitors = new HashSet();
    private final BatteryStatusManager.BatteryStatusCallback mCallback = new BatteryStatusManager.BatteryStatusCallback(){

        @Override
        public void onBatteryStatusChanged(BatteryStatus batteryStatus) {
            ThreadUtils.assertOnUiThread();
            for (BatteryMonitorImpl monitor : BatteryMonitorFactory.this.mSubscribedMonitors) {
                monitor.didChange(batteryStatus);
            }
        }
    };

    public BatteryMonitorFactory(Context applicationContext) {
        assert (applicationContext != null);
        this.mManager = new BatteryStatusManager(applicationContext, this.mCallback);
    }

    public BatteryMonitor createMonitor() {
        ThreadUtils.assertOnUiThread();
        if (this.mSubscribedMonitors.isEmpty() && !this.mManager.start()) {
            Log.e((String)TAG, (String)"BatteryStatusManager failed to start.");
        }
        BatteryMonitorImpl monitor = new BatteryMonitorImpl(this);
        this.mSubscribedMonitors.add(monitor);
        return monitor;
    }

    void unsubscribe(BatteryMonitorImpl monitor) {
        ThreadUtils.assertOnUiThread();
        assert (this.mSubscribedMonitors.contains(monitor));
        this.mSubscribedMonitors.remove(monitor);
        if (this.mSubscribedMonitors.isEmpty()) {
            this.mManager.stop();
        }
    }
}

