/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.device.bluetooth;

import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;
import org.chromium.base.Log;
import org.chromium.device.bluetooth.Wrappers;

@JNINamespace(value="device")
final class ChromeBluetoothAdapter {
    private static final String TAG = "cr.Bluetooth";
    private Wrappers.BluetoothAdapterWrapper mAdapter;

    private ChromeBluetoothAdapter(Wrappers.BluetoothAdapterWrapper adapterWrapper) {
        this.mAdapter = adapterWrapper;
        if (adapterWrapper == null) {
            Log.i(TAG, "ChromeBluetoothAdapter created with no adapterWrapper.", new Object[0]);
        } else {
            Log.i(TAG, "ChromeBluetoothAdapter created with provided adapterWrapper.", new Object[0]);
        }
    }

    @CalledByNative
    public static ChromeBluetoothAdapter create(Object adapterWrapper) {
        return new ChromeBluetoothAdapter((Wrappers.BluetoothAdapterWrapper)adapterWrapper);
    }

    @CalledByNative
    private String getAddress() {
        if (this.isPresent()) {
            return this.mAdapter.getAddress();
        }
        return "";
    }

    @CalledByNative
    private String getName() {
        if (this.isPresent()) {
            return this.mAdapter.getName();
        }
        return "";
    }

    @CalledByNative
    private boolean isPresent() {
        return this.mAdapter != null;
    }

    @CalledByNative
    private boolean isPowered() {
        return this.isPresent() && this.mAdapter.isEnabled();
    }

    @CalledByNative
    private boolean isDiscoverable() {
        return this.isPresent() && this.mAdapter.getScanMode() == 23;
    }

    @CalledByNative
    private boolean isDiscovering() {
        return this.isPresent() && this.mAdapter.isDiscovering();
    }
}

