/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.media;

import android.annotation.SuppressLint;
import android.media.AudioRecord;
import android.media.audiofx.AcousticEchoCanceler;
import android.os.Process;
import java.nio.ByteBuffer;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;
import org.chromium.base.Log;

@JNINamespace(value="media")
class AudioRecordInput {
    private static final String TAG = "cr.media";
    private static final boolean DEBUG = false;
    private static final int HARDWARE_DELAY_MS = 100;
    private final long mNativeAudioRecordInputStream;
    private final int mSampleRate;
    private final int mChannels;
    private final int mBitsPerSample;
    private final int mHardwareDelayBytes;
    private final boolean mUsePlatformAEC;
    private ByteBuffer mBuffer;
    private AudioRecord mAudioRecord;
    private AudioRecordThread mAudioRecordThread;
    private AcousticEchoCanceler mAEC;

    @CalledByNative
    private static AudioRecordInput createAudioRecordInput(long nativeAudioRecordInputStream, int sampleRate, int channels, int bitsPerSample, int bytesPerBuffer, boolean usePlatformAEC) {
        return new AudioRecordInput(nativeAudioRecordInputStream, sampleRate, channels, bitsPerSample, bytesPerBuffer, usePlatformAEC);
    }

    private AudioRecordInput(long nativeAudioRecordInputStream, int sampleRate, int channels, int bitsPerSample, int bytesPerBuffer, boolean usePlatformAEC) {
        this.mNativeAudioRecordInputStream = nativeAudioRecordInputStream;
        this.mSampleRate = sampleRate;
        this.mChannels = channels;
        this.mBitsPerSample = bitsPerSample;
        this.mHardwareDelayBytes = 100 * sampleRate / 1000 * bitsPerSample / 8;
        this.mUsePlatformAEC = usePlatformAEC;
        this.mBuffer = ByteBuffer.allocateDirect(bytesPerBuffer);
        this.nativeCacheDirectBufferAddress(this.mNativeAudioRecordInputStream, this.mBuffer);
    }

    @SuppressLint(value={"NewApi"})
    @CalledByNative
    private boolean open() {
        int audioFormat;
        int channelConfig;
        if (this.mAudioRecord != null) {
            Log.e(TAG, "open() called twice without a close()", new Object[0]);
            return false;
        }
        if (this.mChannels == 1) {
            channelConfig = 16;
        } else if (this.mChannels == 2) {
            channelConfig = 12;
        } else {
            Log.e(TAG, "Unsupported number of channels: %d", this.mChannels);
            return false;
        }
        if (this.mBitsPerSample == 8) {
            audioFormat = 3;
        } else if (this.mBitsPerSample == 16) {
            audioFormat = 2;
        } else {
            Log.e(TAG, "Unsupported bits per sample: %d", this.mBitsPerSample);
            return false;
        }
        int minBufferSize = AudioRecord.getMinBufferSize((int)this.mSampleRate, (int)channelConfig, (int)audioFormat);
        if (minBufferSize < 0) {
            Log.e(TAG, "getMinBufferSize error: %d", minBufferSize);
            return false;
        }
        int audioRecordBufferSizeInBytes = Math.max(this.mBuffer.capacity(), minBufferSize);
        try {
            this.mAudioRecord = new AudioRecord(7, this.mSampleRate, channelConfig, audioFormat, audioRecordBufferSizeInBytes);
        }
        catch (IllegalArgumentException e) {
            Log.e(TAG, "AudioRecord failed", e);
            return false;
        }
        if (AcousticEchoCanceler.isAvailable()) {
            this.mAEC = AcousticEchoCanceler.create((int)this.mAudioRecord.getAudioSessionId());
            if (this.mAEC == null) {
                Log.e(TAG, "AcousticEchoCanceler.create failed", new Object[0]);
                return false;
            }
            int ret = this.mAEC.setEnabled(this.mUsePlatformAEC);
            if (ret != 0) {
                Log.e(TAG, "setEnabled error: %d", ret);
                return false;
            }
        }
        return true;
    }

    @CalledByNative
    private void start() {
        if (this.mAudioRecord == null) {
            Log.e(TAG, "start() called before open().", new Object[0]);
            return;
        }
        if (this.mAudioRecordThread != null) {
            return;
        }
        this.mAudioRecordThread = new AudioRecordThread();
        this.mAudioRecordThread.start();
    }

    @CalledByNative
    private void stop() {
        if (this.mAudioRecordThread == null) {
            return;
        }
        this.mAudioRecordThread.joinRecordThread();
        this.mAudioRecordThread = null;
    }

    @SuppressLint(value={"NewApi"})
    @CalledByNative
    private void close() {
        if (this.mAudioRecordThread != null) {
            Log.e(TAG, "close() called before stop().", new Object[0]);
            return;
        }
        if (this.mAudioRecord == null) {
            return;
        }
        if (this.mAEC != null) {
            this.mAEC.release();
            this.mAEC = null;
        }
        this.mAudioRecord.release();
        this.mAudioRecord = null;
    }

    private native void nativeCacheDirectBufferAddress(long var1, ByteBuffer var3);

    private native void nativeOnData(long var1, int var3, int var4);

    private class AudioRecordThread
    extends Thread {
        private volatile boolean mKeepAlive = true;

        private AudioRecordThread() {
        }

        @Override
        public void run() {
            Process.setThreadPriority((int)-19);
            try {
                AudioRecordInput.this.mAudioRecord.startRecording();
            }
            catch (IllegalStateException e) {
                Log.e(AudioRecordInput.TAG, "startRecording failed", e);
                return;
            }
            while (this.mKeepAlive) {
                int bytesRead = AudioRecordInput.this.mAudioRecord.read(AudioRecordInput.this.mBuffer, AudioRecordInput.this.mBuffer.capacity());
                if (bytesRead > 0) {
                    AudioRecordInput.this.nativeOnData(AudioRecordInput.this.mNativeAudioRecordInputStream, bytesRead, AudioRecordInput.this.mHardwareDelayBytes);
                    continue;
                }
                Log.e(AudioRecordInput.TAG, "read failed: %d", bytesRead);
                if (bytesRead != -3) continue;
                this.mKeepAlive = false;
            }
            try {
                AudioRecordInput.this.mAudioRecord.stop();
            }
            catch (IllegalStateException e) {
                Log.e(AudioRecordInput.TAG, "stop failed", e);
            }
        }

        public void joinRecordThread() {
            this.mKeepAlive = false;
            while (this.isAlive()) {
                try {
                    this.join();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

